/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.om.OMAttribute;
import org.apache.axis2.om.OMElement;

public class ModuleBuilder
extends DescriptionBuilder {
    private AxisConfiguration axisConfig;
    private ModuleDescription module;

    public ModuleBuilder(InputStream serviceInputStream, ModuleDescription module, AxisConfiguration axisConfig) {
        super(serviceInputStream, axisConfig);
        this.axisConfig = axisConfig;
        this.module = module;
    }

    private void loadModuleClass(ModuleDescription module, String moduleClassName) throws DeploymentException {
        try {
            if (moduleClassName != null && !"".equals(moduleClassName)) {
                Class<?> moduleClass = Class.forName(moduleClassName, true, module.getModuleClassLoader());
                module.setModule((Module)moduleClass.newInstance());
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    public void populateModule() throws DeploymentException {
        try {
            OMElement outFaultFlow;
            OMElement inFaultFlow;
            OMElement outFlow;
            Iterator policyRefElements;
            PolicyInclude policyInclude;
            String moduleClass;
            OMAttribute moduleClassAtt;
            String moduleName;
            OMElement moduleElement = this.buildOM();
            OMAttribute moduleNameAtt = moduleElement.getAttribute(new QName("name"));
            if (moduleNameAtt != null && (moduleName = moduleNameAtt.getAttributeValue()) != null && !"".equals(moduleName)) {
                this.module.setName(new QName(moduleName));
            }
            if ((moduleClassAtt = moduleElement.getAttribute(new QName("class"))) != null && (moduleClass = moduleClassAtt.getAttributeValue()) != null && !"".equals(moduleClass)) {
                this.loadModuleClass(this.module, moduleClass);
            }
            if (this.axisConfig != null) {
                PolicyInclude parent = this.axisConfig.getPolicyInclude();
                policyInclude = new PolicyInclude(parent);
            } else {
                policyInclude = new PolicyInclude();
            }
            this.module.setPolicyInclude(policyInclude);
            Iterator policyElements = moduleElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            if (policyElements != null) {
                this.processPolicyElements(3, policyElements, this.module.getPolicyInclude());
            }
            if ((policyRefElements = moduleElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null) {
                this.processPolicyRefElements(3, policyRefElements, this.module.getPolicyInclude());
            }
            Iterator itr = moduleElement.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, this.module, this.module.getParent());
            OMElement inFlow = moduleElement.getFirstChildWithName(new QName("inflow"));
            if (inFlow != null) {
                this.module.setInFlow(this.processFlow(inFlow, this.module));
            }
            if ((outFlow = moduleElement.getFirstChildWithName(new QName("outflow"))) != null) {
                this.module.setOutFlow(this.processFlow(outFlow, this.module));
            }
            if ((inFaultFlow = moduleElement.getFirstChildWithName(new QName("INfaultflow"))) != null) {
                this.module.setFaultInFlow(this.processFlow(inFaultFlow, this.module));
            }
            if ((outFaultFlow = moduleElement.getFirstChildWithName(new QName("Outfaultflow"))) != null) {
                this.module.setFaultOutFlow(this.processFlow(outFaultFlow, this.module));
            }
            Iterator op_itr = moduleElement.getChildrenWithName(new QName("operation"));
            ArrayList operations = this.processOperations(op_itr);
            for (int i = 0; i < operations.size(); ++i) {
                AxisOperation operation = (AxisOperation)operations.get(i);
                this.module.addOperation(operation);
            }
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList processOperations(Iterator operationsIterator) throws DeploymentException {
        ArrayList<void> operations = new ArrayList<void>();
        while (operationsIterator.hasNext()) {
            void var7_7;
            AxisOperation op_descrip;
            OMElement operation = (OMElement)operationsIterator.next();
            OMAttribute op_name_att = operation.getAttribute(new QName("name"));
            if (op_name_att == null) {
                throw new DeploymentException(Messages.getMessage(Messages.getMessage("invalid_op", "operation name missing")));
            }
            OMAttribute op_mep_att = operation.getAttribute(new QName("mep"));
            String mepURL = null;
            if (op_mep_att != null) {
                mepURL = op_mep_att.getAttributeValue();
            }
            if (mepURL == null) {
                op_descrip = new InOnlyAxisOperation();
            } else {
                try {
                    op_descrip = AxisOperationFactory.getOperationDescription(mepURL);
                }
                catch (AxisFault axisFault) {
                    throw new DeploymentException(Messages.getMessage(Messages.getMessage("op_error", axisFault.getMessage())));
                }
            }
            String opname = op_name_att.getAttributeValue();
            var7_7.setName(new QName(opname));
            Iterator parameters = operation.getChildrenWithName(new QName("parameter"));
            ArrayList wsamapping = this.processParameters(parameters, (ParameterInclude)var7_7, this.module);
            var7_7.setWsamappingList(wsamapping);
            OMElement receiverElement = operation.getFirstChildWithName(new QName("messageReceiver"));
            if (receiverElement != null) {
                MessageReceiver messageReceiver = this.loadMessageReceiver(this.module.getModuleClassLoader(), receiverElement);
                var7_7.setMessageReceiver(messageReceiver);
            } else {
                MessageReceiver msgReceiver = this.loadDefaultMessageReceiver(mepURL, null);
                var7_7.setMessageReceiver(msgReceiver);
            }
            Iterator modules = operation.getChildrenWithName(new QName("module"));
            this.processOperationModuleRefs(modules, (AxisOperation)var7_7);
            PhasesInfo info = this.axisConfig.getPhasesInfo();
            try {
                info.setOperationPhases((AxisOperation)var7_7);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
            operations.add(var7_7);
        }
        return operations;
    }
}

