/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMAttribute;
import org.apache.axis2.om.OMElement;

public class ServiceBuilder
extends DescriptionBuilder {
    private AxisConfiguration axisConfig;
    private AxisService service;

    public ServiceBuilder(AxisConfiguration axisConfig, AxisService service) {
        this.service = service;
        this.axisConfig = axisConfig;
        ((DescriptionBuilder)this).axisConfig = axisConfig;
    }

    public ServiceBuilder(InputStream serviceInputStream, AxisConfiguration axisConfig, AxisService service) {
        super(serviceInputStream, axisConfig);
        this.service = service;
    }

    public AxisService populateService(OMElement service_element) throws DeploymentException {
        try {
            String sessionScope;
            Iterator policyRefElements;
            Iterator itr = service_element.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, this.service, this.service.getParent());
            OMElement descriptionElement = service_element.getFirstChildWithName(new QName("description"));
            if (descriptionElement != null) {
                OMElement descriptionValue = descriptionElement.getFirstElement();
                if (descriptionValue != null) {
                    StringWriter writer = new StringWriter();
                    descriptionValue.build();
                    descriptionValue.serialize(writer);
                    writer.flush();
                    this.service.setServiceDescription(writer.toString());
                } else {
                    this.service.setServiceDescription(descriptionElement.getText());
                }
            } else {
                OMAttribute serviceNameatt = service_element.getAttribute(new QName("name"));
                if (serviceNameatt != null) {
                    this.service.setServiceDescription(serviceNameatt.getAttributeValue());
                }
            }
            Iterator policyElements = service_element.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            if (policyElements != null) {
                this.processPolicyElements(2, policyElements, this.service.getPolicyInclude());
            }
            if ((policyRefElements = service_element.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null) {
                this.processPolicyRefElements(2, policyRefElements, this.service.getPolicyInclude());
            }
            if ((sessionScope = service_element.getAttributeValue(new QName("scope"))) != null) {
                this.service.setScope(sessionScope);
            }
            Iterator moduleRefs = service_element.getChildrenWithName(new QName("module"));
            this.processModuleRefs(moduleRefs);
            OMElement messageReceiver = service_element.getFirstChildWithName(new QName("messageReceivers"));
            if (messageReceiver != null) {
                HashMap mrs = this.processMessageReceivers(this.service.getClassLoader(), messageReceiver);
                Iterator keys = mrs.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.service.addMessageReceiver(key, (MessageReceiver)mrs.get(key));
                }
            }
            Iterator operationsIterator = service_element.getChildrenWithName(new QName("operation"));
            ArrayList ops = this.processOperations(operationsIterator);
            for (int i = 0; i < ops.size(); ++i) {
                AxisOperation operationDesc = (AxisOperation)ops.get(i);
                ArrayList wsamappings = operationDesc.getWsamappingList();
                for (int j = 0; j < wsamappings.size(); ++j) {
                    Parameter parameter = (Parameter)wsamappings.get(j);
                    this.service.mapActionToOperation((String)parameter.getValue(), operationDesc);
                }
                this.service.addOperation(operationDesc);
            }
            Iterator operations = this.service.getPublishedOperations().iterator();
            while (operations.hasNext()) {
                AxisOperation operation = (AxisOperation)operations.next();
                if (operation.getMessageReceiver() != null) continue;
                operation.setMessageReceiver(this.loadDefaultMessageReceiver(operation.getMessageExchangePattern(), this.service));
            }
            Iterator moduleConfigs = service_element.getChildrenWithName(new QName("moduleConfig"));
            this.processServiceModuleConfig(moduleConfigs, this.service, this.service);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(Messages.getMessage("op_error", axisFault.getMessage()));
        }
        return this.service;
    }

    private void processMessages(Iterator messages, AxisOperation operation) throws DeploymentException {
        while (messages.hasNext()) {
            Iterator policyRefElements;
            OMElement messageElement = (OMElement)messages.next();
            OMAttribute lable = messageElement.getAttribute(new QName("label"));
            if (lable == null) {
                throw new DeploymentException("message lebel can not be null");
            }
            AxisMessage message = operation.getMessage(lable.getAttributeValue());
            Iterator parameters = messageElement.getChildrenWithName(new QName("parameter"));
            Iterator policyElements = messageElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            if (policyElements != null) {
                this.processPolicyElements(15, policyElements, message.getPolicyInclude());
            }
            if ((policyRefElements = messageElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null) {
                this.processPolicyRefElements(15, policyRefElements, message.getPolicyInclude());
            }
            this.processParameters(parameters, message, operation);
        }
    }

    protected void processModuleRefs(Iterator moduleRefs) throws DeploymentException {
        try {
            while (moduleRefs.hasNext()) {
                OMElement moduleref = (OMElement)moduleRefs.next();
                OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
                if (moduleRefAttribute == null) continue;
                String refName = moduleRefAttribute.getAttributeValue();
                if (this.axisConfig.getModule(new QName(refName)) == null) {
                    throw new DeploymentException(Messages.getMessage("modulenotfound", refName));
                }
                this.service.addModuleref(new QName(refName));
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
    }

    protected void processOperationModuleConfig(Iterator moduleConfigs, ParameterInclude parent, AxisOperation operation) throws DeploymentException {
        while (moduleConfigs.hasNext()) {
            OMElement moduleConfig = (OMElement)moduleConfigs.next();
            OMAttribute moduleName_att = moduleConfig.getAttribute(new QName("name"));
            if (moduleName_att == null) {
                throw new DeploymentException(Messages.getMessage("invalidmoduleconfig"));
            }
            String module = moduleName_att.getAttributeValue();
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration(new QName(module), parent);
            Iterator parameters = moduleConfig.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, moduleConfiguration, parent);
            operation.addModuleConfig(moduleConfiguration);
        }
    }

    private ArrayList processOperations(Iterator operationsIterator) throws AxisFault {
        ArrayList<AxisOperation> operations = new ArrayList<AxisOperation>();
        while (operationsIterator.hasNext()) {
            Iterator policyRefElements;
            Iterator policyElements;
            String opname;
            AxisOperation op_descrip;
            OMElement operation = (OMElement)operationsIterator.next();
            OMAttribute op_name_att = operation.getAttribute(new QName("name"));
            if (op_name_att == null) {
                throw new DeploymentException(Messages.getMessage(Messages.getMessage("invalid_op", "operation name missing")));
            }
            OMAttribute op_mep_att = operation.getAttribute(new QName("mep"));
            String mepurl = null;
            if (op_mep_att != null) {
                mepurl = op_mep_att.getAttributeValue();
            }
            if ((op_descrip = this.service.getOperation(new QName(opname = op_name_att.getAttributeValue()))) == null) {
                if (mepurl == null) {
                    op_descrip = new InOutAxisOperation();
                    op_descrip.setParent(this.service);
                } else {
                    op_descrip = AxisOperationFactory.getOperationDescription(mepurl);
                }
                op_descrip.setName(new QName(opname));
            }
            if ((policyElements = operation.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"))) != null) {
                this.processPolicyElements(14, policyElements, op_descrip.getPolicyInclude());
            }
            if ((policyRefElements = operation.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null) {
                this.processPolicyRefElements(14, policyRefElements, op_descrip.getPolicyInclude());
            }
            Iterator parameters = operation.getChildrenWithName(new QName("parameter"));
            ArrayList wsamappings = this.processParameters(parameters, op_descrip, this.service);
            op_descrip.setWsamappingList(wsamappings);
            OMElement receiverElement = operation.getFirstChildWithName(new QName("messageReceiver"));
            if (receiverElement != null) {
                MessageReceiver messageReceiver = this.loadMessageReceiver(this.service.getClassLoader(), receiverElement);
                op_descrip.setMessageReceiver(messageReceiver);
            } else {
                MessageReceiver msgReceiver = this.loadDefaultMessageReceiver(null, this.service);
                op_descrip.setMessageReceiver(msgReceiver);
            }
            Iterator modules = operation.getChildrenWithName(new QName("module"));
            this.processOperationModuleRefs(modules, op_descrip);
            Iterator messages = operation.getChildrenWithName(new QName("message"));
            this.processMessages(messages, op_descrip);
            if (this.axisConfig != null) {
                PhasesInfo info = this.axisConfig.getPhasesInfo();
                info.setOperationPhases(op_descrip);
            }
            Iterator moduleConfigs = operation.getChildrenWithName(new QName("moduleConfig"));
            this.processOperationModuleConfig(moduleConfigs, op_descrip, op_descrip);
            operations.add(op_descrip);
        }
        return operations;
    }

    protected void processServiceModuleConfig(Iterator moduleConfigs, ParameterInclude parent, AxisService service) throws DeploymentException {
        while (moduleConfigs.hasNext()) {
            OMElement moduleConfig = (OMElement)moduleConfigs.next();
            OMAttribute moduleName_att = moduleConfig.getAttribute(new QName("name"));
            if (moduleName_att == null) {
                throw new DeploymentException(Messages.getMessage("invalidmoduleconfig"));
            }
            String module = moduleName_att.getAttributeValue();
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration(new QName(module), parent);
            Iterator parameters = moduleConfig.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, moduleConfiguration, parent);
            service.addModuleConfig(moduleConfiguration);
        }
    }
}

