/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.listener;

import java.io.File;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.listener.RepositoryListener;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.repository.util.WSInfoList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryListenerImpl
implements RepositoryListener,
DeploymentConstants {
    protected Log log = LogFactory.getLog(this.getClass());
    private DeploymentEngine deploymentEngine;
    private String folderName;
    private WSInfoList wsInfoList;

    public RepositoryListenerImpl(String folderName, DeploymentEngine deploymentEngine) {
        this.folderName = folderName;
        this.wsInfoList = new WSInfoList(deploymentEngine);
        this.deploymentEngine = deploymentEngine;
        this.init();
    }

    public void checkModules() {
        String modulepath = this.folderName + "/modules/";
        File root = new File(modulepath);
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isDirectory()) {
                    if (!ArchiveFileData.isModuleArchiveFile(file.getName())) continue;
                    this.wsInfoList.addWSInfoItem(file, 1);
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, 1);
            }
        }
    }

    public void checkServices() {
        String modulepath = this.folderName + "/services/";
        this.findServicesInDirectory(modulepath);
        this.update();
    }

    public void init() {
        this.wsInfoList.init();
        this.checkModules();
        this.deploymentEngine.doDeploy();
    }

    private void findServicesInDirectory(String folderName) {
        File root = new File(folderName);
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isDirectory()) {
                    if (!ArchiveFileData.isServiceArchiveFile(file.getName())) continue;
                    this.wsInfoList.addWSInfoItem(file, 0);
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, 0);
            }
        }
    }

    public void startListener() {
        this.checkServices();
        this.update();
    }

    public void update() {
        this.wsInfoList.update();
    }
}

