/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.repository.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.i18n.Messages;

public class ArchiveFileData {
    private File file = null;
    private ArrayList deployableServices = new ArrayList();
    private ClassLoader classLoader;
    private String messageReceiver;
    private String name;
    private int type;

    public ArchiveFileData(File file, int type) {
        this.file = file;
        this.type = type;
    }

    public ArchiveFileData(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ArrayList getDeployableServices() {
        return this.deployableServices;
    }

    public File getFile() {
        return this.file;
    }

    public String getMessageReceiver() {
        return this.messageReceiver;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getServiceName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public static boolean isModuleArchiveFile(String filename) {
        return filename.endsWith(".jar") || filename.endsWith(".mar");
    }

    public static boolean isServiceArchiveFile(String filename) {
        return filename.endsWith(".jar") | filename.endsWith(".aar");
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassLoader(boolean extractArichive, ClassLoader parent) throws AxisFault {
        if (!extractArichive) {
            if (this.file != null) {
                try {
                    if (!this.file.exists()) {
                        throw new AxisFault(Messages.getMessage("fileNotFound", this.file.getAbsolutePath()));
                    }
                    URL[] urlsToLoadFrom = new URL[]{this.file.toURL()};
                    this.classLoader = new DeploymentClassLoader(urlsToLoadFrom, parent);
                }
                catch (Exception e) {
                    throw new AxisFault(e);
                }
            }
        } else if (this.file != null) {
            this.classLoader = Utils.getClassLoader(parent, this.file);
        }
    }

    public void setDeployableServices(ArrayList deployableServices) {
        this.deployableServices = deployableServices;
    }

    public void setMessageReceiver(String messageReceiver) {
        this.messageReceiver = messageReceiver;
    }
}

