/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.repository.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.deployment.AxisServiceBuilder;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMAttribute;
import org.apache.axis2.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArchiveReader
implements DeploymentConstants {
    private Log log = LogFactory.getLog(this.getClass());

    private ArrayList buildServiceGroup(InputStream zin, DeploymentEngine engine, AxisServiceGroup axisServiceGroup, HashMap wsdlServices, AxisConfiguration axisConfig) throws XMLStreamException, DeploymentException {
        DescriptionBuilder builder = new DescriptionBuilder(zin, axisConfig);
        OMElement rootElement = builder.buildOM();
        String elementName = rootElement.getLocalName();
        if ("service".equals(elementName)) {
            AxisService axisService = null;
            OMAttribute serviceNameatt = rootElement.getAttribute(new QName("name"));
            String serviceName = serviceNameatt.getAttributeValue();
            if (serviceName != null) {
                axisService = (AxisService)wsdlServices.get(serviceName);
            }
            if (axisService == null) {
                axisService = (AxisService)wsdlServices.get(DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getName()));
            }
            if (axisService == null) {
                axisService = new AxisService(DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getName()));
            } else {
                axisService.setWsdlfound(true);
            }
            axisService.setParent(axisServiceGroup);
            axisService.setClassLoader(engine.getCurrentFileItem().getClassLoader());
            ServiceBuilder serviceBuilder = new ServiceBuilder(axisConfig, axisService);
            AxisService service = serviceBuilder.populateService(rootElement);
            ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
            if (!axisService.isWsdlfound()) {
                try {
                    Utils.fillAxisService(service, axisConfig);
                }
                catch (Exception e) {
                    this.log.info((Object)("Error in schema generating :" + e.getMessage()));
                }
            }
            serviceList.add(service);
            return serviceList;
        }
        if ("serviceGroup".equals(elementName)) {
            ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, wsdlServices, axisConfig);
            return groupBuilder.populateServiceGroup(axisServiceGroup);
        }
        return null;
    }

    public File creatModuleArchivefromResource(String moduleName, String axis2repository) throws DeploymentException {
        File modulearchiveFile;
        try {
            ZipEntry entry;
            File modules;
            int BUFFER = 2048;
            if (axis2repository == null) {
                String userHome = System.getProperty("java.io.tmpdir");
                File userHomedir = new File(userHome);
                File repository = new File(userHomedir, ".axis2");
                modules = new File(repository, "modules");
            } else {
                modules = new File(axis2repository, "modules");
            }
            String modulearchiveName = moduleName + ".mar";
            modulearchiveFile = new File(modules, modulearchiveName);
            if (modulearchiveFile.exists()) {
                return modulearchiveFile;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream in = cl.getResourceAsStream("modules/" + moduleName + ".mar");
            if (in == null) {
                in = cl.getResourceAsStream("modules/" + moduleName + ".jar");
            }
            if (in == null) {
                throw new DeploymentException(Messages.getMessage("modulexmlnotfound", moduleName));
            }
            if (!modules.exists()) {
                modules.mkdirs();
            }
            modulearchiveFile.createNewFile();
            FileOutputStream dest = new FileOutputStream(modulearchiveFile);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[BUFFER];
            ZipInputStream zin = new ZipInputStream(in);
            while ((entry = zin.getNextEntry()) != null) {
                int count;
                ZipEntry zip = new ZipEntry(entry);
                out.putNextEntry(zip);
                while ((count = zin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
            }
            out.close();
            zin.close();
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return modulearchiveFile;
    }

    public ArrayList processServiceGroup(String filename, DeploymentEngine engine, AxisServiceGroup axisServiceGroup, boolean extractService, HashMap wsdls, AxisConfiguration axisConfig) throws DeploymentException {
        if (!extractService) {
            try {
                ZipEntry entry;
                ZipInputStream zin = new ZipInputStream(new FileInputStream(filename));
                while ((entry = zin.getNextEntry()) != null) {
                    if (!entry.getName().equals("META-INF/services.xml")) continue;
                    axisServiceGroup.setServiceGroupName(DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getName()));
                    return this.buildServiceGroup(zin, engine, axisServiceGroup, wsdls, axisConfig);
                }
                throw new DeploymentException(Messages.getMessage("servicexmlnotfound", filename));
            }
            catch (Exception e) {
                throw new DeploymentException(e);
            }
        }
        File file = new File(filename, "META-INF/services.xml");
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                axisServiceGroup.setServiceGroupName(engine.getCurrentFileItem().getName());
                return this.buildServiceGroup(in, engine, axisServiceGroup, wsdls, axisConfig);
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
            }
            catch (XMLStreamException e) {
                throw new DeploymentException(Messages.getMessage("StreamException", e.getMessage()));
            }
        }
        throw new DeploymentException(Messages.getMessage("servicexmlnotfound"));
    }

    private AxisService processWSDLFile(InputStream in) throws DeploymentException {
        AxisServiceBuilder axisServiceBuilder = new AxisServiceBuilder();
        return axisServiceBuilder.getAxisService(in);
    }

    public HashMap processWSDLs(ArchiveFileData file, DeploymentEngine depengine) throws DeploymentException {
        File serviceFile = file.getFile();
        HashMap<String, AxisService> servicesMap = new HashMap<String, AxisService>();
        boolean isDirectory = serviceFile.isDirectory();
        if (isDirectory) {
            try {
                File meta_inf = new File(serviceFile, "META-INF");
                if (!meta_inf.exists()) {
                    throw new DeploymentException(Messages.getMessage("noMetaInf", serviceFile.getName()));
                }
                File[] files = meta_inf.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file1 = files[i];
                    if (!file1.getName().toLowerCase().endsWith(".wsdl")) continue;
                    FileInputStream in = new FileInputStream(file1);
                    AxisService service = this.processWSDLFile(in);
                    servicesMap.put(service.getName(), service);
                    try {
                        ((InputStream)in).close();
                        continue;
                    }
                    catch (IOException e) {
                        this.log.info((Object)e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(e);
            }
            catch (IOException e) {
                throw new DeploymentException(e);
            }
        }
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new FileInputStream(serviceFile));
            byte[] buf = new byte[1024];
            while ((entry = zin.getNextEntry()) != null) {
                int read;
                String entryName = entry.getName().toLowerCase();
                if (!entryName.startsWith("META-INF".toLowerCase()) || !entryName.endsWith(".wsdl")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((read = zin.read(buf)) > 0) {
                    out.write(buf, 0, read);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                AxisService service = this.processWSDLFile(in);
                servicesMap.put(service.getName(), service);
            }
            try {
                zin.close();
            }
            catch (IOException e) {
                this.log.info((Object)e);
            }
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException(e);
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        return servicesMap;
    }

    public void readModuleArchive(String filename, DeploymentEngine engine, ModuleDescription module, boolean explodedDir, AxisConfiguration axisConfig) throws DeploymentException {
        block9: {
            boolean foundmoduleXML = false;
            if (!explodedDir) {
                try {
                    ZipEntry entry;
                    ZipInputStream zin = new ZipInputStream(new FileInputStream(filename));
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().equals("META-INF/module.xml")) continue;
                        foundmoduleXML = true;
                        ModuleBuilder builder = new ModuleBuilder(zin, module, axisConfig);
                        module.setName(new QName(DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getServiceName())));
                        builder.populateModule();
                        break;
                    }
                    zin.close();
                    if (!foundmoduleXML) {
                        throw new DeploymentException(Messages.getMessage("modulexmlnotfound", filename));
                    }
                    break block9;
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            File file = new File(filename, "META-INF/module.xml");
            if (file.exists()) {
                try {
                    FileInputStream in = new FileInputStream(file);
                    ModuleBuilder builder = new ModuleBuilder(in, module, axisConfig);
                    module.setName(new QName(DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getServiceName())));
                    builder.populateModule();
                }
                catch (FileNotFoundException e) {
                    throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
                }
            } else {
                throw new DeploymentException(Messages.getMessage("modulexmlnotfound", filename));
            }
        }
    }
}

