/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.phaseresolver.PhaseException;

public class PhasesInfo {
    private ArrayList INPhases = new ArrayList();
    private ArrayList IN_FaultPhases = new ArrayList();
    private ArrayList OUTPhases = new ArrayList();
    private ArrayList OUT_FaultPhases = new ArrayList();

    private Phase copyPhase(Phase phase) throws DeploymentException {
        Phase newPhase = new Phase(phase.getPhaseName());
        Iterator handlers = phase.getHandlers().iterator();
        while (handlers.hasNext()) {
            try {
                Handler handlerDescription = (Handler)handlers.next();
                newPhase.addHandler(handlerDescription.getHandlerDesc());
            }
            catch (PhaseException e) {
                throw new DeploymentException(e);
            }
        }
        return newPhase;
    }

    HandlerDescription makeHandler(OMElement handlerElement) {
        String name = handlerElement.getAttributeValue(new QName("name"));
        QName qname = handlerElement.resolveQName(name);
        HandlerDescription desc = new HandlerDescription(qname);
        String className = handlerElement.getAttributeValue(new QName("class"));
        desc.setClassName(className);
        return desc;
    }

    public Phase makePhase(OMElement phaseElement) throws PhaseException {
        String phaseName = phaseElement.getAttributeValue(new QName("name"));
        Phase phase = new Phase(phaseName);
        Iterator children = phaseElement.getChildElements();
        while (children.hasNext()) {
            OMElement handlerElement = (OMElement)children.next();
            HandlerDescription handlerDesc = this.makeHandler(handlerElement);
            phase.addHandler(handlerDesc);
        }
        return phase;
    }

    public ArrayList getGlobalInflow() {
        ArrayList<Phase> globalphase = new ArrayList<Phase>();
        for (int i = 0; i < this.INPhases.size(); ++i) {
            Phase phase = (Phase)this.INPhases.get(i);
            String phaseName = phase.getPhaseName();
            if (!"TransportIn".equals(phaseName) && !"PreDispatch".equals(phaseName) && !"Dispatch".equals(phaseName) && !"PostDispatch".equals(phaseName)) continue;
            globalphase.add(phase);
        }
        return globalphase;
    }

    public ArrayList getGlobalOutPhaseList() throws DeploymentException {
        ArrayList<Phase> globalPhaseList = new ArrayList<Phase>();
        for (int i = 0; i < this.OUTPhases.size(); ++i) {
            Phase phase = (Phase)this.OUTPhases.get(i);
            String phaseName = phase.getPhaseName();
            if (!"PolicyDetermination".equals(phaseName) && !"MessageOut".equals(phaseName)) continue;
            globalPhaseList.add(this.copyPhase(phase));
        }
        return globalPhaseList;
    }

    public ArrayList getINPhases() {
        return this.INPhases;
    }

    public ArrayList getIN_FaultPhases() {
        return this.IN_FaultPhases;
    }

    public ArrayList getOUTPhases() {
        return this.OUTPhases;
    }

    public ArrayList getOUT_FaultPhases() {
        return this.OUT_FaultPhases;
    }

    public ArrayList getOperationInFaultPhases() throws DeploymentException {
        ArrayList<Phase> oprationIN_FaultPhases = new ArrayList<Phase>();
        for (int i = 0; i < this.IN_FaultPhases.size(); ++i) {
            Phase phase = (Phase)this.IN_FaultPhases.get(i);
            oprationIN_FaultPhases.add(this.copyPhase(phase));
        }
        return oprationIN_FaultPhases;
    }

    public ArrayList getOperationInPhases() throws DeploymentException {
        ArrayList<Phase> operationINPhases = new ArrayList<Phase>();
        for (int i = 0; i < this.INPhases.size(); ++i) {
            Phase phase = (Phase)this.INPhases.get(i);
            String phaseName = phase.getPhaseName();
            if ("TransportIn".equals(phaseName) || "PreDispatch".equals(phaseName) || "Dispatch".equals(phaseName) || "PostDispatch".equals(phaseName)) continue;
            operationINPhases.add(this.copyPhase(phase));
        }
        return operationINPhases;
    }

    public ArrayList getOperationOutFaultPhases() throws DeploymentException {
        ArrayList<Phase> oprationOUT_FaultPhases = new ArrayList<Phase>();
        for (int i = 0; i < this.OUT_FaultPhases.size(); ++i) {
            Phase phase = (Phase)this.OUT_FaultPhases.get(i);
            oprationOUT_FaultPhases.add(this.copyPhase(phase));
        }
        return oprationOUT_FaultPhases;
    }

    public ArrayList getOperationOutPhases() throws DeploymentException {
        ArrayList<Phase> oprationOUTPhases = new ArrayList<Phase>();
        for (int i = 0; i < this.OUTPhases.size(); ++i) {
            Phase phase = (Phase)this.OUTPhases.get(i);
            String phaseName = phase.getPhaseName();
            if ("PolicyDetermination".equals(phaseName) || "MessageOut".equals(phaseName)) continue;
            oprationOUTPhases.add(this.copyPhase(phase));
        }
        return oprationOUTPhases;
    }

    public void setINPhases(ArrayList INPhases) {
        this.INPhases = INPhases;
    }

    public void setIN_FaultPhases(ArrayList IN_FaultPhases) {
        this.IN_FaultPhases = IN_FaultPhases;
    }

    public void setOUTPhases(ArrayList OUTPhases) {
        this.OUTPhases = OUTPhases;
    }

    public void setOUT_FaultPhases(ArrayList OUT_FaultPhases) {
        this.OUT_FaultPhases = OUT_FaultPhases;
    }

    public void setOperationPhases(AxisOperation axisOperation) throws AxisFault {
        if (axisOperation != null) {
            try {
                axisOperation.setRemainingPhasesInFlow(this.getOperationInPhases());
                axisOperation.setPhasesOutFlow(this.getOperationOutPhases());
                axisOperation.setPhasesInFaultFlow(this.getOperationInFaultPhases());
                axisOperation.setPhasesOutFaultFlow(this.getOperationOutFaultPhases());
            }
            catch (DeploymentException e) {
                throw new AxisFault(e);
            }
        }
    }
}

