/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterImpl;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.wsdl.java2wsdl.SchemaGenerator;
import org.apache.axis2.wsdl.java2wsdl.TypeTable;
import org.codehaus.jam.JMethod;

public class Utils {
    public static void addFlowHandlers(Flow flow, ClassLoader clsLoader) throws AxisFault {
        int count = flow.getHandlerCount();
        for (int j = 0; j < count; ++j) {
            HandlerDescription handlermd = flow.getHandler(j);
            Class handlerClass = Utils.getHandlerClass(handlermd.getClassName(), clsLoader);
            try {
                Handler handler = (Handler)handlerClass.newInstance();
                handler.init(handlermd);
                handlermd.setHandler(handler);
                continue;
            }
            catch (InstantiationException e) {
                throw new AxisFault(e);
            }
            catch (IllegalAccessException e) {
                throw new AxisFault(e);
            }
        }
    }

    public static void loadHandler(ClassLoader loader1, HandlerDescription desc) throws DeploymentException {
        String handlername = desc.getClassName();
        try {
            Class<?> handlerClass = Class.forName(handlername, true, loader1);
            Handler handler = (Handler)handlerClass.newInstance();
            handler.init(desc);
            desc.setHandler(handler);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(e);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public static ClassLoader getClassLoader(ClassLoader parent, String path) throws DeploymentException {
        return Utils.getClassLoader(parent, new File(path));
    }

    public static ClassLoader getClassLoader(ClassLoader parent, File file) throws DeploymentException {
        if (file != null) {
            try {
                File jarfile;
                int i;
                File[] jarfiles;
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(file.toURL());
                File libfiles = new File(file, "lib");
                if (libfiles.exists()) {
                    urls.add(libfiles.toURL());
                    jarfiles = libfiles.listFiles();
                    for (i = 0; i < jarfiles.length; ++i) {
                        jarfile = jarfiles[i];
                        if (!jarfile.getName().endsWith(".jar")) continue;
                        urls.add(jarfile.toURL());
                    }
                }
                if ((libfiles = new File(file, "Lib")).exists()) {
                    urls.add(libfiles.toURL());
                    jarfiles = libfiles.listFiles();
                    for (i = 0; i < jarfiles.length; ++i) {
                        jarfile = jarfiles[i];
                        if (!jarfile.getName().endsWith(".jar")) continue;
                        urls.add(jarfile.toURL());
                    }
                }
                URL[] urllist = new URL[urls.size()];
                for (i = 0; i < urls.size(); ++i) {
                    urllist[i] = (URL)urls.get(i);
                }
                URLClassLoader classLoader = new URLClassLoader(urllist, parent);
                return classLoader;
            }
            catch (MalformedURLException e) {
                throw new DeploymentException(e);
            }
        }
        return null;
    }

    private static Class getHandlerClass(String className, ClassLoader loader1) throws AxisFault {
        Class<?> handlerClass;
        try {
            handlerClass = Class.forName(className, true, loader1);
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault(e.getMessage());
        }
        return handlerClass;
    }

    public static void fillAxisService(AxisService axisService, AxisConfiguration axisConfig) throws Exception {
        Parameter implInfoParam = axisService.getParameter("ServiceClass");
        String serviceClass = (String)implInfoParam.getValue();
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        SchemaGenerator schemaGenerator = new SchemaGenerator(serviceClassLoader, serviceClass, null, null);
        axisService.setSchema(schemaGenerator.generateSchema());
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            JMethod jmethod = method[i];
            if (!jmethod.isPublic() || jmethod.getSimpleName().equals("init")) continue;
            String opName = jmethod.getSimpleName();
            AxisOperation operation = axisService.getOperation(new QName(opName));
            if (operation != null) {
                AxisMessage inMessage = operation.getMessage("In");
                if (inMessage != null) {
                    inMessage.setElementQName(table.getComplexScheamType(jmethod.getSimpleName() + SchemaGenerator.METHOD_REQUEST_WRAPPER));
                }
                if (jmethod.getReturnType().isVoidType()) continue;
                AxisMessage outMessage = operation.getMessage("Out");
                outMessage.setElementQName(table.getQNamefortheType(jmethod.getSimpleName() + SchemaGenerator.METHOD_RESPONSE_WRAPPER));
                continue;
            }
            operation = Utils.getAxisOperationforJmethod(jmethod, table);
            MessageReceiver mr = axisService.getMessageReceiver(operation.getMessageExchangePattern());
            if (mr != null) {
                operation.setMessageReceiver(mr);
            } else {
                mr = axisConfig.getMessageReceiver(operation.getMessageExchangePattern());
                operation.setMessageReceiver(mr);
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig) throws AxisFault {
        ParameterImpl parameter = new ParameterImpl("ServiceClass", implClass);
        AxisService axisService = new AxisService();
        axisService.setUseDefaultChains(false);
        axisService.addParameter(parameter);
        int index = implClass.lastIndexOf(".");
        String serviceName = index > 0 ? implClass.substring(index + 1, implClass.length()) : implClass;
        axisService.setName(serviceName);
        axisService.setClassLoader(axisConfig.getServiceClassLoader());
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        SchemaGenerator schemaGenerator = new SchemaGenerator(serviceClassLoader, implClass, null, null);
        try {
            axisService.setSchema(schemaGenerator.generateSchema());
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            JMethod jmethod = method[i];
            if (!jmethod.isPublic()) continue;
            AxisOperation operation = Utils.getAxisOperationforJmethod(jmethod, table);
            try {
                Class<?> clazz = Class.forName("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
                MessageReceiver messageReceiver = (MessageReceiver)clazz.newInstance();
                operation.setMessageReceiver(messageReceiver);
            }
            catch (ClassNotFoundException e) {
                throw new AxisFault("ClassNotFoundException occurd during message receiver loading" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new AxisFault("IllegalAccessException occurd during message receiver loading" + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new AxisFault("InstantiationException occurd during message receiver loading" + e.getMessage());
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
        return axisService;
    }

    private static AxisOperation getAxisOperationforJmethod(JMethod jmethod, TypeTable table) throws AxisFault {
        AxisOperation operation;
        String opName = jmethod.getSimpleName();
        if (jmethod.getReturnType().isVoidType()) {
            operation = AxisOperationFactory.getAxisOperation(10);
        } else {
            operation = AxisOperationFactory.getAxisOperation(12);
            AxisMessage outMessage = operation.getMessage("Out");
            outMessage.setElementQName(table.getQNamefortheType(jmethod.getSimpleName() + SchemaGenerator.METHOD_RESPONSE_WRAPPER));
        }
        operation.setName(new QName(opName));
        AxisMessage inMessage = operation.getMessage("In");
        if (inMessage != null) {
            inMessage.setElementQName(table.getComplexScheamType(jmethod.getSimpleName() + SchemaGenerator.METHOD_REQUEST_WRAPPER));
        }
        return operation;
    }
}

