/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.DescriptionConstants;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisError;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wsdl.WSDLConstants;

public abstract class AxisOperation
implements ParameterInclude,
DescriptionConstants,
WSDLConstants {
    public static final String STYLE_RPC = "rpc";
    public static final String STYLE_MSG = "msg";
    public static final String STYLE_DOC = "doc";
    private Log log = LogFactory.getLog(this.getClass());
    private int mep = -1;
    public static final String SOAP_ACTION = "soapaction";
    private ArrayList engagedModules = new ArrayList();
    private boolean controlOperation = false;
    private String style = "doc";
    private String mepURI = "http://www.w3.org/2004/08/wsdl/in-out";
    private MessageReceiver messageReceiver;
    private HashMap moduleConfigmap;
    private ArrayList modulerefs;
    private QName name;
    private ParameterInclude parameterInclude = new ParameterIncludeImpl();
    private AxisService parent;
    private ArrayList wsamappingList;
    private PolicyInclude policyInclude;

    public AxisOperation() {
        this.modulerefs = new ArrayList();
        this.moduleConfigmap = new HashMap();
        this.policyInclude = new PolicyInclude();
    }

    public AxisOperation(QName name) {
        this();
        this.setName(name);
    }

    public abstract void addMessage(AxisMessage var1, String var2);

    public abstract void addMessageContext(MessageContext var1, OperationContext var2) throws AxisFault;

    public void addModule(QName moduleName) {
        this.modulerefs.add(moduleName);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addParameter(Parameter param) throws AxisFault {
        if (param == null) {
            return;
        }
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault("Parmter is locked can not overide: " + param.getName());
        }
        this.parameterInclude.addParameter(param);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameterInclude.deserializeParameters(parameterElement);
    }

    public final void engageModule(ModuleDescription moduleref, AxisConfiguration axisConfig) throws AxisFault {
        if (moduleref == null) {
            return;
        }
        boolean needToadd = true;
        Iterator module_itr = this.engagedModules.iterator();
        while (module_itr.hasNext()) {
            ModuleDescription module = (ModuleDescription)module_itr.next();
            if (!module.getName().equals(moduleref.getName())) continue;
            this.log.debug((Object)(moduleref.getName().getLocalPart() + " module has already engaged to the operation" + "  operation terminated !!!"));
            needToadd = false;
        }
        new PhaseResolver(axisConfig).engageModuleToOperation(this, moduleref);
        if (needToadd) {
            this.engagedModules.add(moduleref);
        }
    }

    public OperationContext findForExistingOperationContext(MessageContext msgContext) throws AxisFault {
        OperationContext operationContext = msgContext.getOperationContext();
        if (operationContext != null) {
            return operationContext;
        }
        if (null == msgContext.getRelatesTo()) {
            return null;
        }
        ConfigurationContext configContext = msgContext.getConfigurationContext();
        operationContext = configContext.getOperationContext(msgContext.getRelatesTo().getValue());
        if (null == operationContext) {
            throw new AxisFault(Messages.getMessage("cannotCorrealteMsg", this.getName().toString(), msgContext.getRelatesTo().getValue()));
        }
        return operationContext;
    }

    public OperationContext findOperationContext(MessageContext msgContext, ServiceContext serviceContext) throws AxisFault {
        OperationContext operationContext;
        if (null == msgContext.getRelatesTo()) {
            operationContext = new OperationContext(this, serviceContext);
        } else {
            ConfigurationContext configContext = msgContext.getConfigurationContext();
            operationContext = configContext.getOperationContext(msgContext.getRelatesTo().getValue());
            if (null == operationContext) {
                throw new AxisFault(Messages.getMessage("cannotCorrelateMsg", this.getName().toString(), msgContext.getRelatesTo().getValue()));
            }
        }
        this.registerOperationContext(msgContext, operationContext);
        return operationContext;
    }

    public void registerOperationContext(MessageContext msgContext, OperationContext operationContext) throws AxisFault {
        msgContext.getConfigurationContext().registerOperationContext(msgContext.getMessageID(), operationContext);
        operationContext.addMessageContext(msgContext);
        msgContext.setOperationContext(operationContext);
        if (operationContext.isComplete()) {
            operationContext.cleanup();
        }
    }

    public int getAxisSpecifMEPConstant() {
        if (this.mep != -1) {
            return this.mep;
        }
        int temp = -1;
        if ("http://www.w3.org/2004/08/wsdl/in-out".equals(this.getMessageExchangePattern())) {
            temp = 12;
        } else if ("http://www.w3.org/2004/08/wsdl/in-only".equals(this.getMessageExchangePattern())) {
            temp = 10;
        } else if ("http://www.w3.org/2004/08/wsdl/in-opt-out".equals(this.getMessageExchangePattern())) {
            temp = 13;
        } else if ("http://www.w3.org/2004/08/wsdl/out-in".equals(this.getMessageExchangePattern())) {
            temp = 16;
        } else if ("http://www.w3.org/2004/08/wsdl/out-only".equals(this.getMessageExchangePattern())) {
            temp = 14;
        } else if ("http://www.w3.org/2004/08/wsdl/out-opt-in".equals(this.getMessageExchangePattern())) {
            temp = 17;
        } else if ("http://www.w3.org/2004/08/wsdl/robust-in-only".equals(this.getMessageExchangePattern())) {
            temp = 11;
        } else if ("http://www.w3.org/2004/08/wsdl/robust-out-only".equals(this.getMessageExchangePattern())) {
            temp = 15;
        }
        if (temp == -1) {
            throw new AxisError("Could not Map the MEP URI to a axis MEP constant value");
        }
        this.mep = temp;
        return this.mep;
    }

    public Collection getEngagedModules() {
        return this.engagedModules;
    }

    public abstract AxisMessage getMessage(String var1);

    public String getMessageExchangePattern() {
        return this.mepURI;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public ModuleConfiguration getModuleConfig(QName moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public ArrayList getModuleRefs() {
        return this.modulerefs;
    }

    public QName getName() {
        return this.name;
    }

    public Parameter getParameter(String name) {
        return this.parameterInclude.getParameter(name);
    }

    public ArrayList getParameters() {
        return this.parameterInclude.getParameters();
    }

    public AxisService getParent() {
        return this.parent;
    }

    public abstract ArrayList getPhasesInFaultFlow();

    public abstract ArrayList getPhasesOutFaultFlow();

    public abstract ArrayList getPhasesOutFlow();

    public abstract ArrayList getRemainingPhasesInFlow();

    public String getStyle() {
        return this.style;
    }

    public ArrayList getWsamappingList() {
        return this.wsamappingList;
    }

    public boolean isControlOperation() {
        return this.controlOperation;
    }

    public boolean isParameterLocked(String parameterName) {
        boolean locked = false;
        if (this.getParent() != null) {
            locked = this.getParent().isParameterLocked(parameterName);
        }
        if (locked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setControlOperation(boolean controlOperation) {
        this.controlOperation = controlOperation;
    }

    public void setMessageExchangePattern(String mepURI) {
        this.mepURI = mepURI;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public void setParent(AxisService parent) {
        this.parent = parent;
        if (parent.getPolicyInclude() != null) {
            this.policyInclude.setParent(parent.getPolicyInclude());
        }
    }

    public abstract void setPhasesInFaultFlow(ArrayList var1);

    public abstract void setPhasesOutFaultFlow(ArrayList var1);

    public abstract void setPhasesOutFlow(ArrayList var1);

    public abstract void setRemainingPhasesInFlow(ArrayList var1);

    public void setStyle(String style) {
        this.style = style;
    }

    public void setWsamappingList(ArrayList wsamappingList) {
        this.wsamappingList = wsamappingList;
    }

    public OperationClient createClient(ServiceContext sc, Options options) {
        throw new UnsupportedOperationException("The MEP you are using (" + this.mepURI + ") has not implemented createClient().");
    }

    public void setPolicyInclude(PolicyInclude policyInclude) {
        this.policyInclude = policyInclude;
    }

    public PolicyInclude getPolicyInclude() {
        return this.policyInclude;
    }
}

