/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService2WOM;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.DescriptionConstants;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.wsdl.writer.WOMWriter;
import org.apache.axis2.wsdl.writer.WOMWriterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.wsdl.WSDLDescription;

public class AxisService
implements ParameterInclude,
DescriptionConstants {
    private Definition definition = null;
    private Log log = LogFactory.getLog(this.getClass());
    private String fileName = "";
    private HashMap operationsAliasesMap = null;
    private HashMap operations = new HashMap();
    private ArrayList moduleRefs = new ArrayList();
    private ArrayList engagedModules = new ArrayList();
    private String serviceDescription;
    private long lastupdate;
    private HashMap moduleConfigmap;
    private String name;
    private ParameterInclude parameterInclude = new ParameterIncludeImpl();
    private AxisServiceGroup parent;
    private ClassLoader serviceClassLoader;
    private XmlSchema schema;
    private boolean wsdlfound = false;
    private String scope = "request";
    private HashMap messageReceivers;
    private PolicyInclude policyInclude;
    private boolean useDefaultChains = true;

    public AxisService() {
        this.operationsAliasesMap = new HashMap();
        this.moduleConfigmap = new HashMap();
        this.messageReceivers = new HashMap();
        this.policyInclude = new PolicyInclude();
    }

    public AxisService(String name) {
        this();
        this.name = name;
    }

    public void addMessageReceiver(String mepURL, MessageReceiver messageReceiver) {
        this.messageReceivers.put(mepURL, messageReceiver);
    }

    public MessageReceiver getMessageReceiver(String mepURL) {
        return (MessageReceiver)this.messageReceivers.get(mepURL);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addModuleOperations(ModuleDescription module, AxisConfiguration axisConfig) throws AxisFault {
        HashMap map = module.getOperations();
        Collection col = map.values();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = this.copyOperation((AxisOperation)iterator.next());
            ArrayList wsamappings = axisOperation.getWsamappingList();
            for (int j = 0; j < wsamappings.size(); ++j) {
                Parameter parameter = (Parameter)wsamappings.get(j);
                this.mapActionToOperation((String)parameter.getValue(), axisOperation);
            }
            axisOperation.setControlOperation(true);
            this.addOperation(axisOperation);
        }
    }

    public void addModuleref(QName moduleref) {
        this.moduleRefs.add(moduleref);
    }

    public void addOperation(AxisOperation axisOperation) {
        axisOperation.setParent(this);
        Iterator modules = this.getEngagedModules().iterator();
        while (modules.hasNext()) {
            ModuleDescription module = (ModuleDescription)modules.next();
            AxisServiceGroup parent = this.getParent();
            AxisConfiguration axisConfig = null;
            if (parent != null) {
                axisConfig = parent.getParent();
            }
            try {
                axisOperation.engageModule(module, axisConfig);
            }
            catch (AxisFault axisFault) {
                this.log.info((Object)("Trying to engage a module which is already engege:" + module.getName().getLocalPart()));
            }
        }
        this.operations.put(axisOperation.getName(), axisOperation);
        this.operationsAliasesMap.put(axisOperation.getName().getLocalPart(), axisOperation);
    }

    public void addParameter(Parameter param) throws AxisFault {
        if (param == null) {
            return;
        }
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault("Parmter is locked can not overide: " + param.getName());
        }
        this.parameterInclude.addParameter(param);
    }

    private AxisOperation copyOperation(AxisOperation axisOperation) throws AxisFault {
        AxisOperation operation = AxisOperationFactory.getOperationDescription(axisOperation.getMessageExchangePattern());
        operation.setMessageReceiver(axisOperation.getMessageReceiver());
        operation.setName(axisOperation.getName());
        Iterator parameters = axisOperation.getParameters().iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            operation.addParameter(parameter);
        }
        operation.setWsamappingList(axisOperation.getWsamappingList());
        operation.setRemainingPhasesInFlow(axisOperation.getRemainingPhasesInFlow());
        operation.setPhasesInFaultFlow(axisOperation.getPhasesInFaultFlow());
        operation.setPhasesOutFaultFlow(axisOperation.getPhasesOutFaultFlow());
        operation.setPhasesOutFlow(axisOperation.getPhasesOutFlow());
        return operation;
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameterInclude.deserializeParameters(parameterElement);
    }

    public void engageModule(ModuleDescription moduleref, AxisConfiguration axisConfig) throws AxisFault {
        if (moduleref == null) {
            return;
        }
        boolean needToadd = true;
        Iterator itr_engageModules = this.engagedModules.iterator();
        while (itr_engageModules.hasNext()) {
            ModuleDescription module = (ModuleDescription)itr_engageModules.next();
            if (!module.getName().equals(moduleref.getName())) continue;
            this.log.debug((Object)(moduleref.getName().getLocalPart() + " module has already been engaged on the service. " + " Operation terminated !!!"));
            needToadd = false;
        }
        this.addModuleOperations(moduleref, axisConfig);
        Iterator operations = this.getOperations().values().iterator();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            axisOperation.engageModule(moduleref, axisConfig);
        }
        if (needToadd) {
            this.engagedModules.add(moduleref);
        }
    }

    public void mapActionToOperation(String action, AxisOperation axisOperation) {
        this.operationsAliasesMap.put(action, axisOperation);
    }

    public void printSchema(OutputStream out) throws AxisFault {
        this.schema.write(out);
    }

    public void printWSDL(OutputStream out, String serviceURL) throws AxisFault {
        if (this.getWSDLDefinition() != null) {
            this.printUsingWSDLDefinition(out, serviceURL);
        } else {
            this.printUsingWOM(out, serviceURL);
        }
    }

    public void printUsingWSDLDefinition(OutputStream out, String serviceURL) throws AxisFault {
        try {
            Definition wsdlDefinition = this.getWSDLDefinition();
            Collection services = wsdlDefinition.getServices().values();
            Iterator iterator = services.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                Collection ports = service.getPorts().values();
                Iterator iterator1 = ports.iterator();
                while (iterator1.hasNext()) {
                    Port port = (Port)iterator1.next();
                    service.setQName(new QName(this.getName()));
                    SOAPAddressImpl soapAddress = new SOAPAddressImpl();
                    soapAddress.setElementType(SOAPConstants.Q_ELEM_SOAP_ADDRESS);
                    soapAddress.setLocationURI(serviceURL);
                    port.getExtensibilityElements().clear();
                    port.addExtensibilityElement((ExtensibilityElement)soapAddress);
                }
            }
            WSDLFactory.newInstance().newWSDLWriter().writeWSDL(wsdlDefinition, out);
            out.flush();
        }
        catch (WSDLException e) {
            throw new AxisFault(e);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public void printUsingWOM(OutputStream out, String serviceURL) throws AxisFault {
        AxisService2WOM axisService2WOM = new AxisService2WOM(this.getSchema(), this, null, null, serviceURL);
        try {
            WSDLDescription desc = axisService2WOM.generateWOM();
            PolicyUtil.populatePolicy(desc, this);
            WOMWriter womWriter = WOMWriterFactory.createWriter(1);
            womWriter.setdefaultWSDLPrefix("wsdl");
            womWriter.writeWOM(desc, out);
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public ClassLoader getClassLoader() {
        return this.serviceClassLoader;
    }

    public ArrayList getControlOperations() {
        Iterator op_itr = this.getOperations().values().iterator();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = (AxisOperation)op_itr.next();
            if (!operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public Collection getEngagedModules() {
        return this.engagedModules;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getLastupdate() {
        return this.lastupdate;
    }

    public ModuleConfiguration getModuleConfig(QName moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public ArrayList getModules() {
        return this.moduleRefs;
    }

    public String getName() {
        return this.name;
    }

    public AxisOperation getOperation(QName operationName) {
        AxisOperation axisOperation = (AxisOperation)this.operations.get(operationName);
        if (axisOperation == null) {
            axisOperation = (AxisOperation)this.operationsAliasesMap.get(operationName.getLocalPart());
        }
        return axisOperation;
    }

    public AxisOperation getOperationByAction(String action) {
        return (AxisOperation)this.operationsAliasesMap.get(action);
    }

    public AxisOperation getOperationBySOAPAction(String soapAction) {
        if (soapAction == null || soapAction.equals("")) {
            return null;
        }
        AxisOperation operation = (AxisOperation)this.operations.get(new QName(soapAction));
        if (operation != null) {
            return operation;
        }
        operation = (AxisOperation)this.operationsAliasesMap.get(soapAction);
        return operation;
    }

    public HashMap getOperations() {
        return this.operations;
    }

    public Parameter getParameter(String name) {
        return this.parameterInclude.getParameter(name);
    }

    public ArrayList getParameters() {
        return this.parameterInclude.getParameters();
    }

    public AxisServiceGroup getParent() {
        return this.parent;
    }

    public ArrayList getPublishedOperations() {
        Iterator op_itr = this.getOperations().values().iterator();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = (AxisOperation)op_itr.next();
            if (operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public Definition getWSDLDefinition() {
        return this.definition;
    }

    public boolean isParameterLocked(String parameterName) {
        boolean loscked = false;
        if (this.getParent() != null) {
            loscked = this.getParent().getAxisDescription().isParameterLocked(parameterName);
        }
        if (loscked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.serviceClassLoader = classLoader;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLastupdate() {
        this.lastupdate = new Date().getTime();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(AxisServiceGroup parent) {
        this.parent = parent;
        if (parent.getPolicyInclude() != null) {
            this.policyInclude.setParent(parent.getPolicyInclude());
        }
    }

    public void setWSDLDefinition(Definition difDefinition) {
        this.definition = difDefinition;
    }

    public XmlSchema getSchema() {
        return this.schema;
    }

    public void setSchema(XmlSchema schema) {
        this.schema = schema;
    }

    public boolean isWsdlfound() {
        return this.wsdlfound;
    }

    public void setWsdlfound(boolean wsdlfound) {
        this.wsdlfound = wsdlfound;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if ("application".equals(scope) || "transportsession".equals(scope) || "soapsession".equals(scope) || "request".equals(scope)) {
            this.scope = scope;
        }
    }

    public void setPolicyInclude(PolicyInclude policyInclude) {
        this.policyInclude = policyInclude;
    }

    public PolicyInclude getPolicyInclude() {
        return this.policyInclude;
    }

    public boolean isUseDefaultChains() {
        return this.useDefaultChains;
    }

    public void setUseDefaultChains(boolean useDefaultChains) {
        this.useDefaultChains = useDefaultChains;
    }
}

