/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.wsdl.builder.WSDLComponentFactory;
import org.apache.axis2.wsdl.java2wsdl.SchemaGenerator;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.wsdl.MessageReference;
import org.apache.wsdl.WSDLBinding;
import org.apache.wsdl.WSDLBindingMessageReference;
import org.apache.wsdl.WSDLBindingOperation;
import org.apache.wsdl.WSDLDescription;
import org.apache.wsdl.WSDLEndpoint;
import org.apache.wsdl.WSDLInterface;
import org.apache.wsdl.WSDLOperation;
import org.apache.wsdl.WSDLService;
import org.apache.wsdl.WSDLTypes;
import org.apache.wsdl.extensions.ExtensionConstants;
import org.apache.wsdl.extensions.ExtensionFactory;
import org.apache.wsdl.extensions.SOAPBinding;
import org.apache.wsdl.extensions.SOAPBody;
import org.apache.wsdl.extensions.SOAPOperation;
import org.apache.wsdl.extensions.Schema;
import org.apache.wsdl.extensions.impl.SOAPAddressImpl;
import org.apache.wsdl.impl.WSDLDescriptionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AxisService2WOM {
    private XmlSchema schema;
    private AxisService axisService;
    private String url;
    private String targetNamespece;
    private String targetNamespecheprefix;

    public AxisService2WOM(XmlSchema schema, AxisService service, String targetNamespece, String targetNamespecheprefix, String serviceURL) {
        this.schema = schema;
        this.axisService = service;
        this.url = serviceURL;
        this.targetNamespece = targetNamespece != null && !targetNamespece.trim().equals("") ? targetNamespece : SchemaGenerator.TARGET_NAMESPACE;
        this.targetNamespecheprefix = targetNamespecheprefix != null && !targetNamespecheprefix.trim().equals("") ? targetNamespecheprefix : SchemaGenerator.TARGET_NAMESPACE_PREFIX;
    }

    public WSDLDescription generateWOM() throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        StringWriter writer = new StringWriter();
        if (this.schema == null) {
            throw new Exception("no scheam found for the service");
        }
        this.schema.write((Writer)writer);
        writer.flush();
        Document doc = domBuilder.parse(new ByteArrayInputStream(writer.toString().getBytes()));
        Element documentElement = doc.getDocumentElement();
        WSDLDescriptionImpl wsdlComponentFactory = new WSDLDescriptionImpl();
        WSDLDescription womDescription = wsdlComponentFactory.createDescription();
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        namespaceMap.put("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        namespaceMap.put(this.targetNamespecheprefix, this.targetNamespece);
        namespaceMap.put("ns1", "http://org.apache.axis2/xsd");
        namespaceMap.put("xs", "http://www.w3.org/2001/XMLSchema");
        womDescription.setNamespaces(namespaceMap);
        womDescription.setTargetNameSpace(this.targetNamespece);
        WSDLInterface portType = this.generatePortType(womDescription, wsdlComponentFactory, documentElement);
        womDescription.addInterface(portType);
        QName bindingName = new QName(this.targetNamespece, this.axisService.getName() + "Binding", this.targetNamespecheprefix);
        WSDLBinding binding = this.generateBinding(wsdlComponentFactory, portType, bindingName, "document", "literal", "http://schemas.xmlsoap.org/soap/http", "http://www.org.apache.axis2");
        womDescription.addBinding(binding);
        WSDLService service = this.generateService(wsdlComponentFactory, binding, this.axisService.getName(), this.url);
        womDescription.addService(service);
        return womDescription;
    }

    private WSDLInterface generatePortType(WSDLDescription womDescription, WSDLComponentFactory wsdlComponentFactory, Element documentElement) {
        WSDLTypes wsdlTypes = wsdlComponentFactory.createTypes();
        ExtensionFactory extensionFactory = wsdlComponentFactory.createExtensionFactory();
        Schema schemaExtensibilityElement = (Schema)extensionFactory.getExtensionElement(ExtensionConstants.SCHEMA);
        wsdlTypes.addExtensibilityElement(schemaExtensibilityElement);
        schemaExtensibilityElement.setElement(documentElement);
        womDescription.setTypes(wsdlTypes);
        WSDLInterface portType = womDescription.createInterface();
        portType.setName(new QName(this.axisService.getName() + "Port"));
        Iterator operations = this.axisService.getOperations().values().iterator();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            WSDLOperation wsdlOperation = womDescription.createOperation();
            wsdlOperation.setName(axisOperation.getName());
            AxisMessage inaxisMessage = axisOperation.getMessage("In");
            if (inaxisMessage != null) {
                MessageReference messageRefinput = wsdlComponentFactory.createMessageReference();
                messageRefinput.setElementQName(inaxisMessage.getElementQName());
                messageRefinput.setDirection("in");
                wsdlOperation.setInputMessage(messageRefinput);
            }
            try {
                AxisMessage outaxisMessage = axisOperation.getMessage("Out");
                if (outaxisMessage != null && outaxisMessage.getElementQName() != null) {
                    MessageReference messageRefout = wsdlComponentFactory.createMessageReference();
                    messageRefout.setElementQName(outaxisMessage.getElementQName());
                    messageRefout.setDirection("out");
                    wsdlOperation.setOutputMessage(messageRefout);
                }
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            portType.setOperation(wsdlOperation);
        }
        return portType;
    }

    private WSDLService generateService(WSDLComponentFactory wsdlComponentFactory, WSDLBinding binding, String ServiceName2, String URL2) {
        WSDLService service = wsdlComponentFactory.createService();
        service.setName(new QName(ServiceName2));
        WSDLEndpoint endpoints = wsdlComponentFactory.createEndpoint();
        endpoints.setBinding(binding);
        endpoints.setName(new QName(ServiceName2 + "PortType"));
        SOAPAddressImpl address = new SOAPAddressImpl();
        address.setLocationURI(URL2);
        endpoints.addExtensibilityElement(address);
        service.setEndpoint(endpoints);
        return service;
    }

    private WSDLBinding generateBinding(WSDLComponentFactory wsdlComponentFactory, WSDLInterface portType, QName bindingName, String style, String use, String trsportURI, String namespeceURI) {
        WSDLBinding binding = wsdlComponentFactory.createBinding();
        ExtensionFactory extensionFactory = wsdlComponentFactory.createExtensionFactory();
        binding.setBoundInterface(portType);
        binding.setName(bindingName);
        SOAPBinding soapbindingImpl = (SOAPBinding)extensionFactory.getExtensionElement(ExtensionConstants.SOAP_11_BINDING);
        soapbindingImpl.setStyle(style);
        soapbindingImpl.setTransportURI(trsportURI);
        binding.addExtensibilityElement(soapbindingImpl);
        Iterator op_itr = portType.getOperations().keySet().iterator();
        while (op_itr.hasNext()) {
            MessageReference outMessage;
            String opName = (String)op_itr.next();
            WSDLOperation wsdlOperation = portType.getOperation(opName);
            MessageReference inMessage = wsdlOperation.getInputMessage();
            WSDLBindingOperation bindingoperation = wsdlComponentFactory.createWSDLBindingOperation();
            bindingoperation.setName(new QName(opName));
            bindingoperation.setOperation(wsdlOperation);
            binding.addBindingOperation(bindingoperation);
            SOAPOperation soapOpimpl = (SOAPOperation)extensionFactory.getExtensionElement(ExtensionConstants.SOAP_11_OPERATION);
            soapOpimpl.setStyle(style);
            soapOpimpl.setSoapAction(opName);
            bindingoperation.addExtensibilityElement(soapOpimpl);
            if (inMessage != null) {
                WSDLBindingMessageReference bindingInMessage = wsdlComponentFactory.createWSDLBindingMessageReference();
                bindingInMessage.setDirection("in");
                bindingoperation.setInput(bindingInMessage);
                SOAPBody requestSoapbody = (SOAPBody)extensionFactory.getExtensionElement(ExtensionConstants.SOAP_11_BODY);
                requestSoapbody.setUse(use);
                requestSoapbody.setNamespaceURI(namespeceURI);
                bindingInMessage.addExtensibilityElement(requestSoapbody);
            }
            if ((outMessage = wsdlOperation.getOutputMessage()) == null) continue;
            WSDLBindingMessageReference bindingOutMessage = wsdlComponentFactory.createWSDLBindingMessageReference();
            bindingOutMessage.setDirection("out");
            bindingoperation.setOutput(bindingOutMessage);
            SOAPBody resSoapbody = (SOAPBody)extensionFactory.getExtensionElement(ExtensionConstants.SOAP_11_BODY);
            resSoapbody.setUse(use);
            resSoapbody.setNamespaceURI(namespeceURI);
            bindingOutMessage.addExtensibilityElement(resSoapbody);
        }
        return binding;
    }
}

