/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServiceGroup
implements ParameterInclude {
    private Log log = LogFactory.getLog(this.getClass());
    private ArrayList modulesList = new ArrayList();
    private ArrayList engagedModules;
    private HashMap moduleConfigmap;
    protected ParameterInclude paramInclude = new ParameterIncludeImpl();
    private AxisConfiguration parent;
    private ClassLoader serviceGroupClassLoader;
    private String serviceGroupName;
    private PolicyInclude policyInclude;
    private HashMap services = new HashMap();

    public AxisServiceGroup() {
        this.moduleConfigmap = new HashMap();
        this.engagedModules = new ArrayList();
        this.policyInclude = new PolicyInclude();
    }

    public AxisServiceGroup(AxisConfiguration axisDescription) {
        this();
        this.setParent(axisDescription);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        if (this.moduleConfigmap == null) {
            this.moduleConfigmap = new HashMap();
        }
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addModuleref(QName moduleref) {
        this.modulesList.add(moduleref);
    }

    public void addParameter(Parameter param) throws AxisFault {
        this.paramInclude.addParameter(param);
    }

    public void addService(AxisService service) throws AxisFault {
        service.setParent(this);
        AxisConfiguration axisConfig = this.getParent();
        if (axisConfig != null) {
            Iterator modules = this.getEngagedModules().iterator();
            while (modules.hasNext()) {
                QName moduleName = (QName)modules.next();
                ModuleDescription moduleDesc = axisConfig.getModule(moduleName);
                if (moduleDesc != null) {
                    service.engageModule(moduleDesc, axisConfig);
                    continue;
                }
                throw new AxisFault("Trying to engage a module which is not available : " + moduleName.getLocalPart());
            }
        }
        service.setLastupdate();
        this.services.put(service.getName(), service);
    }

    public void addToengagedModules(QName moduleName) {
        this.engagedModules.add(moduleName);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.paramInclude.deserializeParameters(parameterElement);
    }

    public void engageModule(ModuleDescription module) throws AxisFault {
        QName moduleName = module.getName();
        boolean needToadd = true;
        Iterator iterator = this.engagedModules.iterator();
        while (iterator.hasNext()) {
            QName modu = (QName)iterator.next();
            if (!modu.getLocalPart().equals(moduleName.getLocalPart())) continue;
            this.log.debug((Object)(moduleName.getLocalPart() + " module has already been engaged on the service Group. " + " Operation terminated !!!"));
            needToadd = false;
        }
        Iterator srevice = this.getServices();
        while (srevice.hasNext()) {
            AxisService axisService = (AxisService)srevice.next();
            try {
                axisService.engageModule(module, this.parent);
            }
            catch (AxisFault axisFault) {
                this.log.info((Object)axisFault.getMessage());
            }
        }
        if (needToadd) {
            this.addToengagedModules(moduleName);
        }
    }

    public void removeService(String name) throws AxisFault {
        AxisService service = this.getService(name);
        if (service != null) {
            this.parent.notifyObservers(1, service);
        }
        this.services.remove(name);
    }

    public AxisConfiguration getAxisDescription() {
        return this.parent;
    }

    public ArrayList getEngagedModules() {
        return this.engagedModules;
    }

    public ModuleConfiguration getModuleConfig(QName moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public ArrayList getModuleRefs() {
        return this.modulesList;
    }

    public Parameter getParameter(String name) {
        return this.paramInclude.getParameter(name);
    }

    public ArrayList getParameters() {
        return this.paramInclude.getParameters();
    }

    public AxisConfiguration getParent() {
        return this.parent;
    }

    public AxisService getService(String name) throws AxisFault {
        return (AxisService)this.services.get(name);
    }

    public ClassLoader getServiceGroupClassLoader() {
        return this.serviceGroupClassLoader;
    }

    public String getServiceGroupName() {
        return this.serviceGroupName;
    }

    public Iterator getServices() {
        return this.services.values().iterator();
    }

    public boolean isParameterLocked(String parameterName) {
        boolean loscked = false;
        if (this.getParent() != null) {
            loscked = this.getParent().isParameterLocked(parameterName);
        }
        if (loscked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setAxisDescription(AxisConfiguration axisDescription) {
        this.parent = axisDescription;
    }

    public void setParent(AxisConfiguration parent) {
        this.parent = parent;
        if (parent.getPolicyInclude() != null) {
            this.policyInclude.setParent(parent.getPolicyInclude());
        }
    }

    public void setServiceGroupClassLoader(ClassLoader serviceGroupClassLoader) {
        this.serviceGroupClassLoader = serviceGroupClassLoader;
    }

    public void setServiceGroupName(String serviceGroupName) {
        this.serviceGroupName = serviceGroupName;
    }

    public PolicyInclude getPolicyInclude() {
        return this.policyInclude;
    }

    public void setPolicyInclude(PolicyInclude policyInclude) {
        this.policyInclude = policyInclude;
    }
}

