/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;

public class InOnlyAxisOperation
extends AxisOperation {
    private AxisMessage inFaultMessage;
    private AxisMessage inMessage;
    private AxisMessage outFaultMessage;
    private ArrayList outPhase;

    public InOnlyAxisOperation() {
        this.createMessage();
    }

    public InOnlyAxisOperation(QName name) {
        super(name);
        this.createMessage();
    }

    public void addMessage(AxisMessage message, String label) {
        if (!"In".equals(label)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.inMessage = message;
    }

    public void addMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        if (opContext.isComplete()) {
            throw new AxisFault("Invalid message addition , operation context completed");
        }
        opContext.getMessageContexts().put("In", msgContext);
        opContext.setComplete(true);
    }

    private void createMessage() {
        this.inMessage = new AxisMessage();
        this.inMessage.setDirection("in");
        this.inMessage.setParent(this);
        this.inFaultMessage = new AxisMessage();
        this.inFaultMessage.setParent(this);
        this.outFaultMessage = new AxisMessage();
        this.outFaultMessage.setParent(this);
        this.outPhase = new ArrayList();
    }

    public AxisMessage getMessage(String label) {
        if ("In".equals(label)) {
            return this.inMessage;
        }
        throw new UnsupportedOperationException("In valid acess");
    }

    public ArrayList getPhasesInFaultFlow() {
        return this.inFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFaultFlow() {
        return this.outFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFlow() {
        return this.outPhase;
    }

    public ArrayList getRemainingPhasesInFlow() {
        return this.inMessage.getMessageFlow();
    }

    public void setPhasesInFaultFlow(ArrayList list) {
        this.inFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFaultFlow(ArrayList list) {
        this.outFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFlow(ArrayList list) {
        this.outPhase = list;
    }

    public void setRemainingPhasesInFlow(ArrayList list) {
        this.inMessage.setMessageFlow(list);
    }
}

