/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;

public class InOutAxisOperation
extends AxisOperation {
    private AxisMessage inFaultMessage;
    private AxisMessage inMessage;
    private AxisMessage outFaultMessage;
    private AxisMessage outMessage;

    public InOutAxisOperation() {
        this.createMessages();
    }

    public InOutAxisOperation(QName name) {
        super(name);
        this.createMessages();
    }

    public void addMessage(AxisMessage message, String label) {
        if ("Out".equals(label)) {
            this.outMessage = message;
        } else if ("In".equals(label)) {
            this.inMessage = message;
        } else {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public void addMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        HashMap mep = opContext.getMessageContexts();
        MessageContext inMsgContext = (MessageContext)mep.get("In");
        MessageContext outmsgContext = (MessageContext)mep.get("Out");
        if (inMsgContext != null && outmsgContext != null) {
            throw new AxisFault("Invalid message addition , operation context completed");
        }
        if (inMsgContext == null) {
            mep.put("In", msgContext);
        } else {
            mep.put("Out", msgContext);
            opContext.setComplete(true);
            opContext.cleanup();
        }
    }

    private void createMessages() {
        this.inMessage = new AxisMessage();
        this.inMessage.setDirection("in");
        this.inMessage.setParent(this);
        this.inFaultMessage = new AxisMessage();
        this.inFaultMessage.setParent(this);
        this.outFaultMessage = new AxisMessage();
        this.outFaultMessage.setParent(this);
        this.outMessage = new AxisMessage();
        this.outMessage.setDirection("out");
        this.outMessage.setParent(this);
    }

    public AxisMessage getMessage(String label) {
        if ("Out".equals(label)) {
            return this.outMessage;
        }
        if ("In".equals(label)) {
            return this.inMessage;
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ArrayList getPhasesInFaultFlow() {
        return this.inFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFaultFlow() {
        return this.outFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFlow() {
        return this.outMessage.getMessageFlow();
    }

    public ArrayList getRemainingPhasesInFlow() {
        return this.inMessage.getMessageFlow();
    }

    public void setPhasesInFaultFlow(ArrayList list) {
        this.inFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFaultFlow(ArrayList list) {
        this.outFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFlow(ArrayList list) {
        this.outMessage.setMessageFlow(list);
    }

    public void setRemainingPhasesInFlow(ArrayList list) {
        this.inMessage.setMessageFlow(list);
    }
}

