/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ListenerManager;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.util.UUIDGenerator;

class OutOnlyAxisOperationClient
implements OperationClient {
    OutOnlyAxisOperation axisOp;
    ServiceContext sc;
    Options options;
    MessageContext mc;
    OperationContext oc;
    boolean completed;

    OutOnlyAxisOperationClient(OutOnlyAxisOperation axisOp, ServiceContext sc, Options options) {
        this.axisOp = axisOp;
        this.sc = sc;
        this.options = new Options(options);
        this.completed = false;
        this.oc = new OperationContext(axisOp, sc);
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void addMessageContext(MessageContext mc) throws AxisFault {
        if (this.mc != null) {
            throw new AxisFault("Can't add message context again until client has been executed");
        }
        this.mc = mc;
        if (mc.getMessageID() == null) {
            this.setMessageID(mc);
        }
        this.axisOp.registerOperationContext(mc, this.oc);
        this.completed = false;
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        if (messageLabel.equals("Out")) {
            return this.mc;
        }
        throw new AxisFault("Unknown message label: '" + messageLabel + "'");
    }

    public void setCallback(Callback callback) {
        throw new UnsupportedOperationException("This feature is not supported by this MEP");
    }

    private void setMessageID(MessageContext mc) {
        String messageId = this.options.getMessageId();
        if (messageId == null || "".equals(messageId)) {
            messageId = UUIDGenerator.getUUID();
        }
        mc.setMessageID(messageId);
    }

    public void execute(boolean block) throws AxisFault {
        Parameter soapaction;
        if (this.completed) {
            throw new AxisFault("MEP is already completed- need to reset() before re-executing.");
        }
        ConfigurationContext cc = this.sc.getConfigurationContext();
        this.mc.setOptions(this.options);
        TransportOutDescription senderTransport = this.options.getTranportOut();
        if (senderTransport == null) {
            EndpointReference toEPR = this.options.getTo() != null ? this.options.getTo() : this.mc.getTo();
            senderTransport = ClientUtils.inferOutTransport(cc.getAxisConfiguration(), toEPR);
        }
        this.mc.setTransportOut(senderTransport);
        if (this.mc.getSoapAction() == null && (soapaction = this.axisOp.getParameter("soapaction")) != null) {
            this.mc.setSoapAction((String)soapaction.getValue());
        }
        OperationContext oc = new OperationContext(this.axisOp, this.sc);
        oc.addMessageContext(this.mc);
        AxisEngine engine = new AxisEngine(cc);
        engine.send(this.mc);
        this.completed = true;
    }

    public void reset() throws AxisFault {
        if (!this.completed) {
            throw new AxisFault("MEP is not yet complete: cannot reset");
        }
        this.mc = null;
        this.completed = false;
    }

    public void complete(MessageContext msgCtxt) throws AxisFault {
        ListenerManager.stop(msgCtxt.getConfigurationContext(), msgCtxt.getTransportIn().getName().getLocalPart());
    }
}

