/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.util.PolicyRegistry;

public class PolicyInclude {
    public static final String ANON_POLICY = "anonymous";
    public static final int AXIS_POLICY = 1;
    public static final int AXIS_SERVICE_POLICY = 2;
    public static final int AXIS_OPERATION_POLICY = 14;
    public static final int AXIS_MESSAGE_POLICY = 15;
    public static final int MODULE_POLICY = 3;
    public static final int SERVICE_POLICY = 3;
    public static final int PORT_POLICY = 4;
    public static final int PORT_TYPE_POLICY = 5;
    public static final int BINDING_POLICY = 6;
    public static final int OPERATION_POLICY = 7;
    public static final int BINDING_OPERATION_POLICY = 8;
    public static final int INPUT_POLICY = 9;
    public static final int OUTPUT_POLICY = 10;
    public static final int BINDING_INPUT_POLICY = 11;
    public static final int BINDING_OUTPUT_POLICY = 12;
    public static final int MESSAGE_POLICY = 13;
    private Policy policy = null;
    private Policy effectivePolicy = null;
    private PolicyInclude parent = null;
    private PolicyRegistry reg;
    private ArrayList policyElements = new ArrayList();

    public PolicyInclude() {
        this.reg = new PolicyRegistry();
    }

    public PolicyInclude(PolicyInclude parent) {
        this.reg = new PolicyRegistry();
        this.setParent(parent);
    }

    public void setParent(PolicyInclude parent) {
        this.parent = parent;
        this.reg.setParent(parent.getPolicyRegistry());
    }

    public void setPolicyRegistry(PolicyRegistry reg) {
        this.reg = reg;
    }

    public PolicyRegistry getPolicyRegistry() {
        return this.reg;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public Policy getPolicy() {
        if (this.policy == null) {
            Iterator iterator = this.policyElements.iterator();
            while (iterator.hasNext()) {
                Object policyElement = ((PolicyElement)iterator.next()).value;
                Policy p = null;
                if (policyElement instanceof PolicyReference) {
                    p = (Policy)((PolicyReference)policyElement).normalize(this.getPolicyRegistry());
                } else if (policyElement instanceof Policy) {
                    p = (Policy)policyElement;
                }
                this.policy = this.policy == null ? (Policy)p.normalize(this.reg) : (Policy)this.policy.merge((Assertion)p, this.reg);
            }
        }
        return this.policy;
    }

    public Policy getEffectivePolicy() {
        if (this.effectivePolicy != null) {
            return this.effectivePolicy;
        }
        Policy parentEffectivePolicy = this.parent.getEffectivePolicy();
        if (this.parent == null || parentEffectivePolicy == null) {
            return this.getPolicy();
        }
        if (this.getPolicy() != null) {
            return this.parent.getEffectivePolicy();
        }
        return (Policy)parentEffectivePolicy.merge((Assertion)this.getPolicy(), this.reg);
    }

    public ArrayList getPolicyElements() {
        ArrayList<Object> policyElementsList = new ArrayList<Object>();
        Iterator policyElementIterator = this.policyElements.iterator();
        while (policyElementIterator.hasNext()) {
            policyElementsList.add(((PolicyElement)policyElementIterator.next()).value);
        }
        return policyElementsList;
    }

    public ArrayList getPolicyElements(int type) {
        ArrayList<Object> policyElementList = new ArrayList<Object>();
        Iterator policyElementIterator = this.policyElements.iterator();
        while (policyElementIterator.hasNext()) {
            PolicyElement policyElement = (PolicyElement)policyElementIterator.next();
            if (policyElement.type != type) continue;
            policyElementList.add(policyElement.value);
        }
        return policyElementList;
    }

    public void registerPolicy(Policy policy) {
        this.reg.register(policy.getPolicyURI(), policy);
    }

    public Policy getPolicy(String policyURI) {
        return this.reg.lookup(policyURI);
    }

    public void addPolicyElement(int type, Policy policy) {
        PolicyElement policyElement = new PolicyElement();
        policyElement.type = type;
        policyElement.value = policy;
        this.policyElements.add(policyElement);
        if (policy.getPolicyURI() != null) {
            this.reg.register(policy.getPolicyURI(), policy);
        }
    }

    public void addPolicyRefElement(int type, PolicyReference policyReference) {
        PolicyElement policyElement = new PolicyElement();
        policyElement.type = type;
        policyElement.value = policyReference;
        this.policyElements.add(policyElement);
    }

    private class PolicyElement {
        int type;
        Object value;

        private PolicyElement() {
        }
    }
}

