/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingBasedDispatcher
extends AbstractDispatcher
implements AddressingConstants {
    private static final long serialVersionUID = 8294130617631587374L;
    public static final QName NAME = new QName("http://ws.apache.org/axis2/", "AddressingBasedDispatcher");
    private Log log = LogFactory.getLog(this.getClass());

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        this.log.debug((Object)("Checking for Operation using WSAAction : " + messageContext.getWSAAction()));
        String action = messageContext.getWSAAction();
        if (action != null) {
            return service.getOperationByAction(action);
        }
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        AxisService service = null;
        if (toEPR != null) {
            String address = toEPR.getAddress();
            this.log.debug((Object)("Checking for Service using toEPR's address : " + address));
            if ("http://www.w3.org/2005/08/addressing/anonymous".equals(address) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(address)) {
                return null;
            }
            QName serviceName = new QName(address);
            String[] values = Utils.parseRequestURLForServiceAndOperation(address);
            this.log.debug((Object)("Checking for Service using toEPR : " + values[0]));
            if (values[0] != null) {
                serviceName = new QName(values[0]);
                AxisConfiguration registry = messageContext.getConfigurationContext().getAxisConfiguration();
                return registry.getService(serviceName.getLocalPart());
            }
        }
        return service;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    public void invoke(MessageContext msgctx) throws AxisFault {
        if (msgctx.getRelatesTo() != null) {
            OperationContext operationContext;
            this.log.debug((Object)("Checking RelatesTo : " + msgctx.getRelatesTo()));
            String relatesTo = msgctx.getRelatesTo().getValue();
            if ((relatesTo != null || "".equals(relatesTo)) && (operationContext = msgctx.getConfigurationContext().getOperationContext(relatesTo)) != null) {
                msgctx.setAxisOperation(operationContext.getAxisOperation());
                msgctx.setOperationContext(operationContext);
                msgctx.setServiceContext((ServiceContext)operationContext.getParent());
                msgctx.setAxisService(((ServiceContext)operationContext.getParent()).getAxisService());
                msgctx.getAxisOperation().registerOperationContext(msgctx, operationContext);
                msgctx.setServiceGroupContextId(((ServiceGroupContext)msgctx.getServiceContext().getParent()).getId());
            }
            return;
        }
        super.invoke(msgctx);
    }
}

