/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AddressingBasedDispatcher;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.InstanceDispatcher;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.engine.RequestURIBasedDispatcher;
import org.apache.axis2.engine.SOAPActionBasedDispatcher;
import org.apache.axis2.engine.SOAPMessageBodyBasedDispatcher;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.receivers.RawXMLINOnlyMessageReceiver;
import org.apache.axis2.receivers.RawXMLINOutMessageReceiver;
import org.apache.axis2.util.HostConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisConfiguration
implements ParameterInclude {
    private Log log = LogFactory.getLog(this.getClass());
    private final HashMap allModules = new HashMap();
    private final HashMap nameToverionMap = new HashMap();
    private final HashMap serviceGroups = new HashMap();
    private final HashMap transportsIn = new HashMap();
    private final HashMap transportsOut = new HashMap();
    private ArrayList observersList = null;
    private String axis2Repository = null;
    private HashMap allservices = new HashMap();
    private final List engagedModules;
    private Hashtable faultyModules;
    private Hashtable faultyServices;
    private HostConfiguration hostConfiguration;
    private ArrayList inFaultPhases;
    private ArrayList inPhasesUptoAndIncludingPostDispatch;
    private HashMap messageReceivers;
    private PolicyInclude policyInclude;
    private ClassLoader moduleClassLoader;
    private HashMap moduleConfigmap = new HashMap();
    private ArrayList outFaultPhases;
    private ArrayList outPhases;
    protected final ParameterInclude paramInclude = new ParameterIncludeImpl();
    protected PhasesInfo phasesinfo;
    private ClassLoader serviceClassLoader;
    private ClassLoader systemClassLoader;

    public AxisConfiguration() {
        this.engagedModules = new ArrayList();
        this.messageReceivers = new HashMap();
        this.outPhases = new ArrayList();
        this.inFaultPhases = new ArrayList();
        this.outFaultPhases = new ArrayList();
        this.faultyServices = new Hashtable();
        this.faultyModules = new Hashtable();
        this.observersList = new ArrayList();
        this.inPhasesUptoAndIncludingPostDispatch = new ArrayList();
        this.policyInclude = new PolicyInclude();
        this.systemClassLoader = Thread.currentThread().getContextClassLoader();
        this.serviceClassLoader = Thread.currentThread().getContextClassLoader();
        this.moduleClassLoader = Thread.currentThread().getContextClassLoader();
        this.phasesinfo = new PhasesInfo();
        this.createDefaultChain();
        this.addDefaultMessageReceivers();
    }

    public void addMessageReceiver(String mepURL, MessageReceiver messageReceiver) {
        this.messageReceivers.put(mepURL, messageReceiver);
    }

    private void addDefaultMessageReceivers() {
        this.addMessageReceiver("http://www.w3.org/2004/08/wsdl/in-only", new RawXMLINOnlyMessageReceiver());
        this.addMessageReceiver("http://www.w3.org/2004/08/wsdl/in-out", new RawXMLINOutMessageReceiver());
    }

    public void addModule(ModuleDescription module) throws AxisFault {
        module.setParent(this);
        this.allModules.put(module.getName(), module);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addObservers(AxisObserver axisObserver) {
        this.observersList.add(axisObserver);
    }

    public void addParameter(Parameter param) throws AxisFault {
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault("Parmter is locked can not overide: " + param.getName());
        }
        this.paramInclude.addParameter(param);
    }

    public synchronized void addService(AxisService service) throws AxisFault {
        AxisServiceGroup axisServiceGroup = new AxisServiceGroup();
        axisServiceGroup.setServiceGroupName(service.getName());
        axisServiceGroup.setParent(this);
        axisServiceGroup.addService(service);
        this.addServiceGroup(axisServiceGroup);
    }

    public synchronized void addServiceGroup(AxisServiceGroup axisServiceGroup) throws AxisFault {
        AxisService description;
        Iterator services = axisServiceGroup.getServices();
        axisServiceGroup.setParent(this);
        while (services.hasNext()) {
            description = (AxisService)services.next();
            if (this.allservices.get(description.getName()) == null) continue;
            throw new AxisFault("Two services can not have same name, a service with " + description.getName() + " already exists in the system");
        }
        services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            description = (AxisService)services.next();
            if (description.isUseDefaultChains()) {
                Iterator operations = description.getOperations().values().iterator();
                while (operations.hasNext()) {
                    AxisOperation operation = (AxisOperation)operations.next();
                    this.phasesinfo.setOperationPhases(operation);
                }
            }
            this.allservices.put(description.getName(), description);
            this.notifyObservers(1, description);
        }
        Iterator enModule = this.engagedModules.iterator();
        while (enModule.hasNext()) {
            QName moduleName = (QName)enModule.next();
            axisServiceGroup.engageModule(this.getModule(moduleName));
        }
        this.serviceGroups.put(axisServiceGroup.getServiceGroupName(), axisServiceGroup);
    }

    public void addTransportIn(TransportInDescription transport) throws AxisFault {
        this.transportsIn.put(transport.getName(), transport);
    }

    public void addTransportOut(TransportOutDescription transport) throws AxisFault {
        this.transportsOut.put(transport.getName(), transport);
    }

    private void createDefaultChain() {
        Phase transportIN = new Phase("TransportIn");
        Phase preDispatch = new Phase("PreDispatch");
        DispatchPhase dispatchPhase = new DispatchPhase();
        dispatchPhase.setName("Dispatch");
        AddressingBasedDispatcher abd = new AddressingBasedDispatcher();
        abd.initDispatcher();
        RequestURIBasedDispatcher rud = new RequestURIBasedDispatcher();
        rud.initDispatcher();
        SOAPActionBasedDispatcher sabd = new SOAPActionBasedDispatcher();
        sabd.initDispatcher();
        SOAPMessageBodyBasedDispatcher smbd = new SOAPMessageBodyBasedDispatcher();
        smbd.initDispatcher();
        InstanceDispatcher id = new InstanceDispatcher();
        id.init(new HandlerDescription(new QName("InstanceDispatcher")));
        dispatchPhase.addHandler(abd);
        dispatchPhase.addHandler(rud);
        dispatchPhase.addHandler(sabd);
        dispatchPhase.addHandler(smbd);
        dispatchPhase.addHandler(id);
        this.inPhasesUptoAndIncludingPostDispatch.add(transportIN);
        this.inPhasesUptoAndIncludingPostDispatch.add(preDispatch);
        this.inPhasesUptoAndIncludingPostDispatch.add(dispatchPhase);
    }

    public void deserializeParameters(OMElement parameters) throws AxisFault {
        this.paramInclude.deserializeParameters(parameters);
    }

    public void engageModule(QName moduleref) throws AxisFault {
        ModuleDescription module = this.getModule(moduleref);
        if (module == null) {
            String moduleName = moduleref.getLocalPart();
            String defaultModuleVersion = this.getDefaultModuleVersion(moduleName);
            if (defaultModuleVersion != null) {
                QName moduleQName = Utils.getModuleName(moduleName, defaultModuleVersion);
                module = this.loadModulefromResources(moduleQName.getLocalPart());
            } else {
                module = this.loadModulefromResources(moduleName);
            }
        }
        this.engageModule(module, moduleref);
    }

    public void engageModule(String moduleName, String versionID) throws AxisFault {
        QName moduleQName = Utils.getModuleName(moduleName, versionID);
        ModuleDescription module = this.getModule(moduleQName);
        if (module == null) {
            module = this.loadModulefromResources(moduleQName.getLocalPart());
            this.engageModule(module, moduleQName);
        } else {
            this.engageModule(module, moduleQName);
        }
    }

    private void engageModule(ModuleDescription module, QName moduleQName) throws AxisFault {
        if (module != null) {
            Iterator iterator = this.engagedModules.iterator();
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                if (!moduleQName.equals(qName)) continue;
                this.log.info((Object)("Attempt to engage an already engaged module " + qName));
                return;
            }
        } else {
            throw new AxisFault(this + " Refer to invalid module " + moduleQName.getLocalPart() + " has not bean deployed yet !");
        }
        Iterator servicegroups = this.getServiceGroups();
        while (servicegroups.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)servicegroups.next();
            serviceGroup.engageModule(module);
        }
        this.engagedModules.add(module.getName());
    }

    public ModuleDescription loadModulefromResources(String moduleName) throws AxisFault {
        File file = new ArchiveReader().creatModuleArchivefromResource(moduleName, this.getRepository());
        ModuleDescription module = new DeploymentEngine().buildModule(file, this);
        if (module != null) {
            this.addModule(module);
        }
        return module;
    }

    public void notifyObservers(int event_type, AxisService service) {
        AxisEvent event = new AxisEvent(service, event_type);
        for (int i = 0; i < this.observersList.size(); ++i) {
            AxisObserver axisObserver = (AxisObserver)this.observersList.get(i);
            axisObserver.update(event);
        }
    }

    public synchronized void removeService(String name) throws AxisFault {
        AxisService service = (AxisService)this.allservices.remove(name);
        if (service != null) {
            this.log.info((Object)("Removed service " + name));
        }
    }

    public Collection getEngagedModules() {
        return this.engagedModules;
    }

    public Hashtable getFaultyModules() {
        return this.faultyModules;
    }

    public Hashtable getFaultyServices() {
        return this.faultyServices;
    }

    public ArrayList getGlobalOutPhases() {
        return this.outPhases;
    }

    public HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public ArrayList getInFaultFlow() {
        return this.inFaultPhases;
    }

    public ArrayList getInPhasesUptoAndIncludingPostDispatch() {
        return this.inPhasesUptoAndIncludingPostDispatch;
    }

    public MessageReceiver getMessageReceiver(String mepURL) {
        return (MessageReceiver)this.messageReceivers.get(mepURL);
    }

    public ModuleDescription getModule(QName name) {
        String moduleName;
        String defaultModuleVersion;
        ModuleDescription module = (ModuleDescription)this.allModules.get(name);
        if (module != null) {
            return module;
        }
        String moduelName = name.getLocalPart();
        if (moduelName.indexOf(45) < 0 && (defaultModuleVersion = this.getDefaultModuleVersion(moduleName = name.getLocalPart())) != null && (module = (ModuleDescription)this.allModules.get(Utils.getModuleName(moduleName, defaultModuleVersion))) != null) {
            return module;
        }
        return null;
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    public ModuleConfiguration getModuleConfig(QName moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public HashMap getModules() {
        return this.allModules;
    }

    public ArrayList getOutFaultFlow() {
        return this.outFaultPhases;
    }

    public Parameter getParameter(String name) {
        return this.paramInclude.getParameter(name);
    }

    public ArrayList getParameters() {
        return this.paramInclude.getParameters();
    }

    public PhasesInfo getPhasesInfo() {
        return this.phasesinfo;
    }

    public String getRepository() {
        return this.axis2Repository;
    }

    public AxisService getService(String name) {
        return (AxisService)this.allservices.get(name);
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public AxisServiceGroup getServiceGroup(String serviceNameAndGroupString) {
        return (AxisServiceGroup)this.serviceGroups.get(serviceNameAndGroupString);
    }

    public Iterator getServiceGroups() {
        return this.serviceGroups.values().iterator();
    }

    public HashMap getServices() {
        Iterator sgs = this.getServiceGroups();
        while (sgs.hasNext()) {
            AxisServiceGroup axisServiceGroup = (AxisServiceGroup)sgs.next();
            Iterator servics = axisServiceGroup.getServices();
            while (servics.hasNext()) {
                AxisService axisService = (AxisService)servics.next();
                this.allservices.put(axisService.getName(), axisService);
            }
        }
        return this.allservices;
    }

    public ClassLoader getSystemClassLoader() {
        return this.systemClassLoader;
    }

    public TransportInDescription getTransportIn(QName name) throws AxisFault {
        return (TransportInDescription)this.transportsIn.get(name);
    }

    public TransportOutDescription getTransportOut(QName name) throws AxisFault {
        return (TransportOutDescription)this.transportsOut.get(name);
    }

    public HashMap getTransportsIn() {
        return this.transportsIn;
    }

    public HashMap getTransportsOut() {
        return this.transportsOut;
    }

    public boolean isEngaged(QName moduleName) {
        return this.engagedModules.contains(moduleName);
    }

    public boolean isParameterLocked(String parameterName) {
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setGlobalOutPhase(ArrayList outPhases) {
        this.outPhases = outPhases;
    }

    public void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.hostConfiguration = hostConfiguration;
    }

    public void setInFaultPhases(ArrayList list) {
        this.inFaultPhases = list;
    }

    public void setInPhasesUptoAndIncludingPostDispatch(ArrayList inPhasesUptoAndIncludingPostDispatch) {
        this.inPhasesUptoAndIncludingPostDispatch = inPhasesUptoAndIncludingPostDispatch;
    }

    public void setModuleClassLoader(ClassLoader classLoader) {
        this.moduleClassLoader = classLoader;
    }

    public void setOutFaultPhases(ArrayList list) {
        this.outFaultPhases = list;
    }

    public void setPhasesinfo(PhasesInfo phasesInfo) {
        this.phasesinfo = phasesInfo;
    }

    public void setRepository(String axis2Repository) {
        this.axis2Repository = axis2Repository;
    }

    public void setServiceClassLoader(ClassLoader classLoader) {
        this.serviceClassLoader = classLoader;
    }

    public void setSystemClassLoader(ClassLoader classLoader) {
        this.systemClassLoader = classLoader;
    }

    public void setPolicyInclude(PolicyInclude policyInclude) {
        this.policyInclude = policyInclude;
    }

    public PolicyInclude getPolicyInclude() {
        return this.policyInclude;
    }

    public static String getAxis2HomeDirectory() {
        String axis2home = System.getProperty("axis2.home");
        if (axis2home == null && (axis2home = System.getProperty("user.home")) != null) {
            axis2home = axis2home + '/' + ".axis2";
        }
        return axis2home;
    }

    public void addDefaultModuleVersion(String moduleName, String moduleVersion) {
        if (this.nameToverionMap.get(moduleName) == null) {
            this.nameToverionMap.put(moduleName, moduleVersion);
        }
    }

    public String getDefaultModuleVersion(String moduleName) {
        return (String)this.nameToverionMap.get(moduleName);
    }

    public ModuleDescription getDefaultModule(String moduleName) {
        String defualtModuleVersion = this.getDefaultModuleVersion(moduleName);
        if (defualtModuleVersion == null) {
            return (ModuleDescription)this.allModules.get(new QName(moduleName));
        }
        return (ModuleDescription)this.allModules.get(new QName(moduleName + "-" + defualtModuleVersion));
    }
}

