/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFault;
import org.apache.axis2.soap.SOAPFaultCode;
import org.apache.axis2.soap.SOAPFaultDetail;
import org.apache.axis2.soap.SOAPFaultReason;
import org.apache.axis2.soap.SOAPHeaderBlock;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisEngine {
    private Log log = LogFactory.getLog(this.getClass());
    private ConfigurationContext engineContext;

    public AxisEngine(ConfigurationContext engineContext) {
        this.log.debug((Object)"Axis Engine Started");
        this.engineContext = engineContext;
    }

    private void checkMustUnderstand(MessageContext msgContext) throws AxisFault {
        SOAPEnvelope se = msgContext.getEnvelope();
        if (se.getHeader() == null) {
            return;
        }
        Iterator hbs = se.getHeader().examineAllHeaderBlocks();
        while (hbs.hasNext()) {
            SOAPHeaderBlock hb = (SOAPHeaderBlock)hbs.next();
            if (hb.isProcessed() || !hb.getMustUnderstand()) continue;
            String role = hb.getRole();
            if (!(!msgContext.isSOAP11() ? role != null && !"http://www.w3.org/2003/05/soap-envelope/role/next".equals(role) : role != null && !"http://schemas.xmlsoap.org/soap/actor/next".equals(role))) continue;
            throw new AxisFault("Must Understand check failed", "env:MustUnderstand");
        }
    }

    public MessageContext createFaultMessageContext(MessageContext processingContext, Throwable e) throws AxisFault {
        if (processingContext.isProcessingFault()) {
            throw new AxisFault(Messages.getMessage("errorwhileProcessingFault"));
        }
        MessageContext faultContext = new MessageContext();
        faultContext.setConfigurationContext(this.engineContext);
        faultContext.setSessionContext(processingContext.getSessionContext());
        faultContext.setTransportIn(processingContext.getTransportIn());
        faultContext.setTransportOut(processingContext.getTransportOut());
        faultContext.setProcessingFault(true);
        if (processingContext.getFaultTo() != null) {
            faultContext.setFaultTo(processingContext.getFaultTo());
        } else {
            Object writer = processingContext.getProperty("TRANSPORT_OUT");
            if (writer != null) {
                faultContext.setProperty("TRANSPORT_OUT", writer);
            } else {
                throw new AxisFault(Messages.getMessage("nowhereToSendError"));
            }
        }
        faultContext.setOperationContext(processingContext.getOperationContext());
        faultContext.setProcessingFault(true);
        faultContext.setServerSide(true);
        faultContext.setProperty("OutTransportInfo", processingContext.getProperty("OutTransportInfo"));
        SOAPEnvelope envelope = processingContext.isSOAP11() ? OMAbstractFactory.getSOAP11Factory().getDefaultFaultEnvelope() : OMAbstractFactory.getSOAP12Factory().getDefaultFaultEnvelope();
        this.extractFaultInformationFromMessageContext(processingContext, envelope.getBody().getFault(), e);
        faultContext.setEnvelope(envelope);
        faultContext.setProperty("OutTransportInfo", processingContext.getProperty("OutTransportInfo"));
        return faultContext;
    }

    private void extractFaultInformationFromMessageContext(MessageContext context, SOAPFault fault, Throwable e) {
        SOAPProcessingException soapException = null;
        String soapNamespaceURI = !context.isSOAP11() ? "http://www.w3.org/2003/05/soap-envelope" : "http://schemas.xmlsoap.org/soap/envelope/";
        if (e instanceof SOAPProcessingException) {
            soapException = (SOAPProcessingException)e;
        } else if (e instanceof AxisFault && e.getCause() instanceof SOAPProcessingException) {
            soapException = (SOAPProcessingException)e.getCause();
        }
        Object faultCode = context.getProperty("Code");
        String soapFaultCode = "";
        if (faultCode != null) {
            fault.setCode((SOAPFaultCode)faultCode);
        } else if (soapException != null) {
            soapFaultCode = soapException.getFaultCode();
        } else if (e instanceof AxisFault) {
            soapFaultCode = ((AxisFault)e).getFaultCode();
        }
        soapFaultCode = "".equals(soapFaultCode) || soapFaultCode == null ? this.getSenderFaultCode(soapNamespaceURI) : soapFaultCode;
        fault.getCode().getValue().setText(soapFaultCode);
        Object faultReason = context.getProperty("Reason");
        String message = "";
        if (faultReason != null) {
            fault.setReason((SOAPFaultReason)faultReason);
        } else if (soapException != null) {
            message = soapException.getMessage();
        } else if (e instanceof AxisFault) {
            message = e.getMessage();
        }
        message = "".equals(message) || message == null ? "unknown" : message;
        fault.getReason().getSOAPText().setText(message);
        Object faultRole = context.getProperty("Role");
        if (faultRole != null) {
            fault.getRole().setText((String)faultRole);
        } else {
            fault.getRole().setText("http://myAxisServer/role/default");
        }
        Object faultNode = context.getProperty("Node");
        if (faultNode != null) {
            fault.getNode().setText((String)faultNode);
        } else {
            fault.getNode().setText("http://myAxisServer/role/default");
        }
        Object faultDetail = context.getProperty("Detail");
        if (faultDetail != null) {
            fault.setDetail((SOAPFaultDetail)faultDetail);
        } else if (fault.getException() == null) {
            if (e instanceof Exception) {
                fault.setException((Exception)e);
            } else {
                fault.setException(new Exception(e));
            }
        }
    }

    public void receive(MessageContext msgContext) throws AxisFault {
        ConfigurationContext confContext = msgContext.getConfigurationContext();
        ArrayList preCalculatedPhases = confContext.getAxisConfiguration().getInPhasesUptoAndIncludingPostDispatch();
        msgContext.setExecutionChain((ArrayList)preCalculatedPhases.clone());
        msgContext.setFLOW(1);
        this.invoke(msgContext);
        if (msgContext.isServerSide() && !msgContext.isPaused()) {
            this.checkMustUnderstand(msgContext);
            MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
            receiver.receive(msgContext);
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext.getCurrentHandlerIndex() == -1) {
            msgContext.setCurrentHandlerIndex(0);
        }
        while (msgContext.getCurrentHandlerIndex() < msgContext.getExecutionChain().size()) {
            Handler currentHandler = (Handler)msgContext.getExecutionChain().get(msgContext.getCurrentHandlerIndex());
            currentHandler.invoke(msgContext);
            if (msgContext.isPaused()) break;
            msgContext.setCurrentHandlerIndex(msgContext.getCurrentHandlerIndex() + 1);
        }
    }

    public void resumeReceive(MessageContext msgContext) throws AxisFault {
        this.invoke(msgContext);
        if (msgContext.isServerSide() && !msgContext.isPaused()) {
            this.checkMustUnderstand(msgContext);
            MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
            receiver.receive(msgContext);
        }
    }

    public void resumeSend(MessageContext msgContext) throws AxisFault {
        this.invoke(msgContext);
        if (!msgContext.isPaused()) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            TransportSender sender = transportOut.getSender();
            sender.invoke(msgContext);
        }
    }

    public void receiveFault(MessageContext msgContext) throws AxisFault {
    }

    public void resume(MessageContext msgctx) throws AxisFault {
        msgctx.setPaused(false);
        if (msgctx.getFLOW() == 1) {
            this.resumeReceive(msgctx);
        } else {
            this.resumeSend(msgctx);
        }
    }

    public void send(MessageContext msgContext) throws AxisFault {
        OperationContext operationContext = msgContext.getOperationContext();
        ArrayList executionChain = operationContext.getAxisOperation().getPhasesOutFlow();
        ArrayList outPhases = new ArrayList();
        outPhases.addAll((ArrayList)executionChain.clone());
        outPhases.addAll((ArrayList)msgContext.getConfigurationContext().getAxisConfiguration().getGlobalOutPhases().clone());
        msgContext.setExecutionChain(outPhases);
        msgContext.setFLOW(2);
        this.invoke(msgContext);
        if (!msgContext.isPaused()) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            TransportSender sender = transportOut.getSender();
            sender.invoke(msgContext);
        }
    }

    public void sendFault(MessageContext msgContext) throws AxisFault {
        OperationContext opContext = msgContext.getOperationContext();
        if (opContext != null) {
            AxisOperation axisOperation = opContext.getAxisOperation();
            ArrayList faultExecutionChain = axisOperation.getPhasesOutFaultFlow();
            msgContext.setExecutionChain((ArrayList)faultExecutionChain.clone());
            msgContext.setFLOW(2);
            this.invoke(msgContext);
        }
        if (!msgContext.isPaused()) {
            TransportSender sender = msgContext.getTransportOut().getSender();
            sender.invoke(msgContext);
        }
    }

    private String getSenderFaultCode(String soapNamespace) {
        return "http://www.w3.org/2003/05/soap-envelope".equals(soapNamespace) ? "Sender" : "Client";
    }
}

