/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.handlers.AbstractHandler;

public class InstanceDispatcher
extends AbstractHandler {
    private static final long serialVersionUID = -1928612412157492489L;

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext.getOperationContext() != null && msgContext.getServiceContext() != null) {
            msgContext.setServiceGroupContextId(((ServiceGroupContext)msgContext.getServiceContext().getParent()).getId());
            return;
        }
        this.fillContextsFromSessionContext(msgContext);
        AxisOperation axisOperation = msgContext.getAxisOperation();
        if (axisOperation == null) {
            return;
        }
        OperationContext operationContext = axisOperation.findForExistingOperationContext(msgContext);
        if (operationContext != null) {
            axisOperation.registerOperationContext(msgContext, operationContext);
            ServiceContext serviceContext = (ServiceContext)operationContext.getParent();
            ServiceGroupContext serviceGroupContext = (ServiceGroupContext)serviceContext.getParent();
            msgContext.setServiceContext(serviceContext);
            msgContext.setServiceGroupContext(serviceGroupContext);
            msgContext.setServiceGroupContextId(serviceGroupContext.getId());
        } else {
            operationContext = new OperationContext(axisOperation);
            axisOperation.registerOperationContext(msgContext, operationContext);
            if (msgContext.getServiceContext() != null) {
                operationContext.setParent(msgContext.getServiceContext());
            } else {
                msgContext.getConfigurationContext().fillServiceContextAndServiceGroupContext(msgContext);
            }
        }
    }

    private void fillContextsFromSessionContext(MessageContext msgContext) throws AxisFault {
        ServiceContext serviceContext;
        ServiceGroupContext serviceGroupContext;
        AxisService service = msgContext.getAxisService();
        if (service == null) {
            throw new AxisFault("AxisService Not found yet");
        }
        SessionContext sessionContext = msgContext.getSessionContext();
        String serviceGroupContextId = msgContext.getServiceGroupContextId();
        if (serviceGroupContextId != null && sessionContext != null && (serviceGroupContext = sessionContext.getServiceGroupContext(serviceGroupContextId)) != null) {
            msgContext.setServiceGroupContext(serviceGroupContext);
            msgContext.setServiceContext(serviceGroupContext.getServiceContext(service));
            return;
        }
        String scope = service.getScope();
        if ("transportsession".equals(scope) && sessionContext != null && (serviceContext = sessionContext.getServiceContext(service)) != null) {
            msgContext.setServiceContext(serviceContext);
        }
    }
}

