/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Phase
implements Handler {
    private static final long serialVersionUID = -3352439587370050957L;
    private static final int BOTH_BEFORE_AFTER = 0;
    private static final int BEFORE = 1;
    private static final int ANYWHERE = 3;
    private static final int AFTER = 2;
    private Log log = LogFactory.getLog(this.getClass());
    private ArrayList handlers = new ArrayList();
    private boolean isOneHanlder;
    private String phaseName;
    private boolean phasefirstset;
    private boolean phaselastset;

    public Phase() {
        this(null);
    }

    public Phase(String phaseName) {
        this.phaseName = phaseName;
    }

    public void addHandler(Handler handler) {
        this.log.debug((Object)("Handler " + handler.getName() + " added to Phase " + this.phaseName));
        if (this.phaselastset) {
            this.handlers.add(this.handlers.size() - 2, handler);
        } else {
            this.handlers.add(handler);
        }
    }

    public void addHandler(HandlerDescription handler) throws PhaseException {
        Iterator handlers_itr = this.getHandlers().iterator();
        while (handlers_itr.hasNext()) {
            Handler hand = (Handler)handlers_itr.next();
            HandlerDescription handlerDesc = hand.getHandlerDesc();
            if (!handler.getName().getLocalPart().equals(handlerDesc.getName().getLocalPart())) continue;
            return;
        }
        if (this.isOneHanlder) {
            throw new PhaseException(this.getPhaseName() + "can only have one handler, since there is a " + "handler with both phaseFirst and PhaseLast true ");
        }
        if (handler.getRules().isPhaseFirst() && handler.getRules().isPhaseLast()) {
            if (this.handlers.size() > 0) {
                throw new PhaseException(this.getPhaseName() + " can not have more than one handler " + handler.getName() + " is invalid or incorrect phase rules");
            }
            this.handlers.add(handler.getHandler());
            this.isOneHanlder = true;
        } else if (handler.getRules().isPhaseFirst()) {
            this.setPhaseFirst(handler.getHandler());
        } else if (handler.getRules().isPhaseLast()) {
            this.setPhaseLast(handler.getHandler());
        } else {
            this.insertHandler(handler);
        }
    }

    public void addHandler(Handler handler, int index) {
        this.log.debug((Object)("Handler " + handler.getName() + "Added to place " + index + " At the Phase " + this.phaseName));
        this.handlers.add(index, handler);
    }

    public void checkPostConditions(MessageContext msgContext) throws AxisFault {
    }

    public void checkPreconditions(MessageContext msgContext) throws AxisFault {
    }

    public void cleanup() throws AxisFault {
    }

    public void init(HandlerDescription handlerdesc) {
    }

    private void insertAfter(Handler handler) throws PhaseException {
        String afterName = handler.getHandlerDesc().getRules().getAfter();
        for (int i = 0; i < this.handlers.size(); ++i) {
            Handler temphandler = (Handler)this.handlers.get(i);
            if (!temphandler.getName().getLocalPart().equals(afterName)) continue;
            if (this.phaselastset && i == this.handlers.size() - 1) {
                throw new PhaseException("Can't insert handler after handler '" + temphandler.getName() + "', which is marked phaseLast");
            }
            this.handlers.add(i + 1, handler);
            return;
        }
        if (this.handlers.size() > 0) {
            this.handlers.add(0, handler);
        } else {
            this.handlers.add(handler);
        }
    }

    private void insertBefore(Handler handler) throws PhaseException {
        String beforename = handler.getHandlerDesc().getRules().getBefore();
        for (int i = 0; i < this.handlers.size(); ++i) {
            Handler temphandler = (Handler)this.handlers.get(i);
            if (!temphandler.getName().getLocalPart().equals(beforename)) continue;
            if (i == 0) {
                if (this.phasefirstset) {
                    throw new PhaseException("Can't insert handler before handler '" + temphandler.getName() + "', which is marked phaseFirst");
                }
                this.handlers.add(0, handler);
                return;
            }
            this.handlers.add(i - 1, handler);
        }
        this.addHandler(handler);
    }

    private void insertBeforeandAfter(Handler handler) throws PhaseException {
        int before = -1;
        int after = -1;
        String beforeName = handler.getHandlerDesc().getRules().getBefore();
        String afterName = handler.getHandlerDesc().getRules().getAfter();
        for (int i = 0; i < this.handlers.size(); ++i) {
            Handler temphandler = (Handler)this.handlers.get(i);
            if (afterName.equals(temphandler.getName().getLocalPart())) {
                after = i;
            } else if (beforeName.equals(temphandler.getName().getLocalPart())) {
                before = i;
            }
            if (after >= 0 && before >= 0) break;
        }
        if (after > before) {
            throw new PhaseException("incorrect handler order for " + handler.getHandlerDesc().getName());
        }
        if (before == -1 && after == -1) {
            this.addHandler(handler);
            return;
        }
        if (before == -1) {
            this.addHandler(handler);
            return;
        }
        if (after == -1 && this.phasefirstset && before == 0) {
            throw new PhaseException("Can't insert handler before handler '" + ((Handler)this.handlers.get(0)).getName() + "', which is marked phaseFirst");
        }
        this.handlers.add(before, handler);
    }

    private void insertHandler(HandlerDescription handlerDesc) throws PhaseException {
        Handler handler = handlerDesc.getHandler();
        int type = this.getBeforeAfter(handler);
        switch (type) {
            case 0: {
                this.insertBeforeandAfter(handler);
                break;
            }
            case 1: {
                this.insertBefore(handler);
                break;
            }
            case 2: {
                this.insertAfter(handler);
                break;
            }
            case 3: {
                this.addHandler(handler);
            }
        }
    }

    public final void invoke(MessageContext msgctx) throws AxisFault {
        int currentIndex;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking pre-condition for Phase \"" + this.phaseName + "\""));
        }
        if ((currentIndex = msgctx.getCurrentPhaseIndex()) == 0) {
            this.checkPreconditions(msgctx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking phase \"" + this.phaseName + "\""));
        }
        while (currentIndex < this.handlers.size()) {
            Handler handler = (Handler)this.handlers.get(currentIndex);
            this.log.debug((Object)("Invoking Handler '" + handler.getName() + "' in Phase '" + this.phaseName + "'"));
            handler.invoke(msgctx);
            if (msgctx.isPaused()) {
                return;
            }
            msgctx.setCurrentPhaseIndex(++currentIndex);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking post-conditions for phase \"" + this.phaseName + "\""));
        }
        msgctx.setCurrentPhaseIndex(0);
        this.checkPostConditions(msgctx);
    }

    public String toString() {
        return this.getPhaseName();
    }

    private int getBeforeAfter(Handler handler) throws PhaseException {
        PhaseRule rules = handler.getHandlerDesc().getRules();
        String beforeRules = rules.getBefore();
        String afterRules = rules.getAfter();
        if (!"".equals(beforeRules) && !"".equals(afterRules)) {
            if (beforeRules.equals(afterRules)) {
                throw new PhaseException("Both before and after cannot be the same for this handler" + handler.getName());
            }
            return 0;
        }
        if (!"".equals(beforeRules)) {
            return 1;
        }
        if (!"".equals(afterRules)) {
            return 2;
        }
        return 3;
    }

    public int getHandlerCount() {
        return this.handlers.size();
    }

    public HandlerDescription getHandlerDesc() {
        return null;
    }

    public ArrayList getHandlers() {
        return this.handlers;
    }

    public QName getName() {
        return new QName(this.phaseName);
    }

    public Parameter getParameter(String name) {
        return null;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setName(String phaseName) {
        this.phaseName = phaseName;
    }

    public void setPhaseFirst(Handler phaseFirst) throws PhaseException {
        if (this.phasefirstset) {
            throw new PhaseException("PhaseFirst has been set already, cannot have two phaseFirst Handler for same phase " + this.getPhaseName());
        }
        this.handlers.add(0, phaseFirst);
        this.phasefirstset = true;
        if (this.getBeforeAfter(phaseFirst) != 3) {
            throw new PhaseException("Handler with PhaseFirst can not have any before or after proprty error in " + phaseFirst.getName());
        }
    }

    public void setPhaseLast(Handler phaseLast) throws PhaseException {
        if (this.phaselastset) {
            throw new PhaseException("PhaseLast already has been set, cannot have two PhaseLast Handler for same phase " + this.getPhaseName());
        }
        if (this.handlers.size() == 0) {
            this.handlers.add(phaseLast);
        } else {
            this.handlers.add(this.handlers.size() - 1, phaseLast);
        }
        this.phaselastset = true;
        if (this.getBeforeAfter(phaseLast) != 3) {
            throw new PhaseException("Handler with PhaseLast property can not have any before or after property error in " + phaseLast.getName());
        }
    }
}

