/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMNamespace;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageBodyBasedDispatcher
extends AbstractDispatcher {
    private static final long serialVersionUID = 487519840603427717L;
    public static final QName NAME = new QName("http://ws.apache.org/axis2/", "SOAPMessageBodyBasedDispatcher");
    private Log log = LogFactory.getLog(this.getClass());
    String serviceName = null;
    QName operationName = null;

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        OMElement bodyFirstChild = messageContext.getEnvelope().getBody().getFirstElement();
        if (bodyFirstChild == null) {
            return null;
        }
        this.log.debug((Object)("Checking for Operation using SOAP message body's first child's local name : " + bodyFirstChild.getLocalName()));
        this.operationName = new QName(bodyFirstChild.getLocalName());
        return service.getOperation(this.operationName);
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        OMNamespace ns;
        OMElement bodyFirstChild = messageContext.getEnvelope().getBody().getFirstElement();
        if (bodyFirstChild != null && (ns = bodyFirstChild.getNamespace()) != null) {
            String filePart = ns.getName();
            this.log.debug((Object)("Checking for Service using SOAP message body's first child's namespace : " + filePart));
            String[] values = Utils.parseRequestURLForServiceAndOperation(filePart);
            if (values[1] != null) {
                this.operationName = new QName(values[1]);
            }
            if (values[0] != null) {
                this.serviceName = values[0];
                AxisConfiguration registry = messageContext.getConfigurationContext().getAxisConfiguration();
                return registry.getService(this.serviceName);
            }
        }
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

