/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.fault;

import javax.xml.namespace.QName;
import org.apache.axis2.fault.AbstractFaultCode;
import org.apache.axis2.om.OMException;
import org.apache.axis2.soap.SOAPFaultSubCode;
import org.apache.axis2.soap.SOAPFaultValue;

public class FaultSubcode
extends AbstractFaultCode {
    private QName value;

    public FaultSubcode() {
    }

    public FaultSubcode(SOAPFaultSubCode source) {
        SOAPFaultValue value = source.getValue();
        String text = value.getText();
        QName qname = source.resolveQName(text);
        if (qname == null) {
            throw new OMException("No QName from " + text);
        }
        this.setValue(qname);
        SOAPFaultSubCode subCode = source.getSubCode();
        if (subCode != null) {
            this.setSubcode(new FaultSubcode(subCode));
        }
    }

    public FaultSubcode(QName value, FaultSubcode subcode) {
        super(subcode);
        this.value = value;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "[undefined fault]";
    }

    public QName getValue() {
        return this.value;
    }

    public void setValue(QName value) {
        this.value = value;
    }
}

