/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.om;

import org.apache.axis2.om.OMFactory;
import org.apache.axis2.om.OMFactoryException;
import org.apache.axis2.soap.SOAPFactory;

class FactoryFinder {
    private static final String DEFAULT_OM_FACTORY_CLASS_NAME = "org.apache.axis2.om.impl.llom.factory.OMLinkedListImplFactory";
    private static final String DEFAULT_SOAP11_FACTORY_CLASS_NAME = "org.apache.axis2.soap.impl.llom.soap11.SOAP11Factory";
    private static final String DEFAULT_SOAP12_FACTORY_CLASS_NAME = "org.apache.axis2.soap.impl.llom.soap12.SOAP12Factory";

    FactoryFinder() {
    }

    private static Object findFactory(ClassLoader loader, String factoryClass, String systemPropertyName) throws OMFactoryException {
        Object factory;
        String factoryClassName = factoryClass;
        if (systemPropertyName != null && System.getProperty(systemPropertyName) != null) {
            factoryClassName = systemPropertyName;
        }
        try {
            factory = loader == null ? Class.forName(factoryClassName).newInstance() : loader.loadClass(factoryClassName).newInstance();
        }
        catch (Exception e) {
            throw new OMFactoryException(e);
        }
        return factory;
    }

    public static SOAPFactory findSOAP11Factory(ClassLoader loader) throws OMFactoryException {
        return (SOAPFactory)FactoryFinder.findFactory(loader, DEFAULT_SOAP11_FACTORY_CLASS_NAME, "soap11.factory");
    }

    public static SOAPFactory findSOAP12Factory(ClassLoader loader) throws OMFactoryException {
        return (SOAPFactory)FactoryFinder.findFactory(loader, DEFAULT_SOAP12_FACTORY_CLASS_NAME, "soap12.factory");
    }

    public static OMFactory findOMFactory(ClassLoader loader) throws OMFactoryException {
        return (OMFactory)FactoryFinder.findFactory(loader, DEFAULT_OM_FACTORY_CLASS_NAME, "om.factory");
    }

    public static SOAPFactory findSOAPFactory(ClassLoader classLoader, String soapFactory) {
        return (SOAPFactory)FactoryFinder.findFactory(classLoader, soapFactory, null);
    }
}

