/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.om.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.OMText;

public class MIMEOutputUtils {
    private static byte[] CRLF = new byte[]{13, 10};

    public static void complete(OutputStream outStream, StringWriter writer, LinkedList binaryNodeList, String boundary, String contentId, String charSetEncoding, String SOAPContentType) {
        try {
            MIMEOutputUtils.startWritingMime(outStream, boundary);
            DataHandler dh = new DataHandler((Object)writer.toString(), "text/xml; charset=" + charSetEncoding);
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("content-type", "application/xop+xml; charset=" + charSetEncoding + "; type=\"" + SOAPContentType + "\";");
            rootMimeBodyPart.addHeader("content-transfer-encoding", "binary");
            rootMimeBodyPart.addHeader("content-id", "<" + contentId + ">");
            MIMEOutputUtils.writeBodyPart(outStream, rootMimeBodyPart, boundary);
            Iterator binaryNodeIterator = binaryNodeList.iterator();
            while (binaryNodeIterator.hasNext()) {
                OMText binaryNode = (OMText)binaryNodeIterator.next();
                MIMEOutputUtils.writeBodyPart(outStream, MIMEOutputUtils.createMimeBodyPart(binaryNode), boundary);
            }
            MIMEOutputUtils.finishWritingMime(outStream);
        }
        catch (IOException e) {
            throw new OMException("Problem with the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }

    public static MimeBodyPart createMimeBodyPart(OMText node) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler((DataHandler)node.getDataHandler());
        mimeBodyPart.addHeader("content-id", "<" + node.getContentID() + ">");
        mimeBodyPart.addHeader("content-type", "application/octet-stream");
        mimeBodyPart.addHeader("content-transfer-encoding", "binary");
        return mimeBodyPart;
    }

    public static void writeMimeBoundary(OutputStream outStream, String boundary) throws IOException {
        outStream.write(new byte[]{45, 45});
        outStream.write(boundary.getBytes());
    }

    public static void startWritingMime(OutputStream outStream, String boundary) throws IOException {
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
    }

    public static void writeBodyPart(OutputStream outStream, MimeBodyPart part, String boundary) throws IOException, MessagingException {
        outStream.write(CRLF);
        part.writeTo(outStream);
        outStream.write(CRLF);
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
    }

    public static void finishWritingMime(OutputStream outStream) throws IOException {
        outStream.write(new byte[]{45, 45});
    }

    public static String getContentTypeForMime(String boundary, String contentId, String charSetEncoding, String SOAPContentType) {
        StringBuffer sb = new StringBuffer();
        sb.append("multipart/related");
        sb.append("; ");
        sb.append("boundary=");
        sb.append(boundary);
        sb.append("; ");
        sb.append("type=\"application/xop+xml\"");
        sb.append("; ");
        sb.append("start=\"<" + contentId + ">\"");
        sb.append("; ");
        sb.append("start-info=\"" + SOAPContentType + "\"");
        return sb.toString();
    }
}

