/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.om.impl.llom;

import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.om.OMDocument;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.OMOutputFormat;
import org.apache.axis2.om.OMXMLParserWrapper;
import org.apache.axis2.om.impl.OMContainerEx;
import org.apache.axis2.om.impl.OMNodeEx;
import org.apache.axis2.om.impl.OMOutputImpl;
import org.apache.axis2.om.impl.llom.OMNodeImpl;
import org.apache.axis2.om.impl.llom.traverse.OMChildrenIterator;
import org.apache.axis2.om.impl.llom.traverse.OMChildrenQNameIterator;

public class OMDocumentImpl
implements OMDocument,
OMContainerEx {
    protected OMElement documentElement;
    protected OMNode firstChild;
    protected OMNode lastChild;
    protected boolean done = false;
    protected OMXMLParserWrapper parserWrapper;
    protected String charSetEncoding = "UTF-8";
    protected String xmlVersion = "1.0";
    protected String isStandalone;

    public OMDocumentImpl() {
        this.done = true;
    }

    public OMDocumentImpl(OMElement documentElement, OMXMLParserWrapper parserWrapper) {
        this.documentElement = documentElement;
        this.parserWrapper = parserWrapper;
    }

    public OMDocumentImpl(OMXMLParserWrapper parserWrapper) {
        this.parserWrapper = parserWrapper;
    }

    public OMElement getOMDocumentElement() {
        while (this.documentElement == null) {
            this.parserWrapper.next();
        }
        return this.documentElement;
    }

    public void setOMDocumentElement(OMElement documentElement) {
        this.documentElement = documentElement;
    }

    public boolean isComplete() {
        return this.done;
    }

    public void setComplete(boolean state) {
        this.done = state;
    }

    public void buildNext() {
        if (!this.parserWrapper.isCompleted()) {
            this.parserWrapper.next();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addChild(OMNode child) {
        if (child instanceof OMElement) {
            if (this.documentElement != null) throw new OMException("Document element already exists");
            this.addChild((OMNodeImpl)child);
            this.documentElement = (OMElement)child;
            return;
        } else {
            this.addChild((OMNodeImpl)child);
        }
    }

    private void addChild(OMNodeImpl child) {
        if (this.firstChild == null) {
            this.firstChild = child;
            child.setPreviousOMSibling(null);
        } else {
            child.setPreviousOMSibling(this.lastChild);
            ((OMNodeEx)this.lastChild).setNextOMSibling(child);
        }
        child.setNextOMSibling(null);
        child.setParent(this);
        this.lastChild = child;
    }

    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    public Iterator getChildrenWithName(QName elementQName) {
        return new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
    }

    public OMNode getFirstOMChild() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return this.firstChild;
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator omChildrenQNameIterator = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        OMNode omNode = null;
        if (omChildrenQNameIterator.hasNext()) {
            omNode = (OMNode)omChildrenQNameIterator.next();
        }
        return omNode != null && 1 == omNode.getType() ? (OMElement)omNode : null;
    }

    public void setFirstChild(OMNode firstChild) {
        this.firstChild = firstChild;
    }

    public String getCharsetEncoding() {
        return this.charSetEncoding;
    }

    public void setCharsetEncoding(String charEncoding) {
        this.charSetEncoding = charEncoding;
    }

    public String isStandalone() {
        return this.isStandalone;
    }

    public void setStandalone(String isStandalone) {
        this.isStandalone = isStandalone;
    }

    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public void setXMLVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public void serializeAndConsume(OMOutputImpl omOutput, boolean includeXMLDeclaration) throws XMLStreamException {
        this.serialize(omOutput, false, includeXMLDeclaration);
    }

    public void serializeAndConsume(OMOutputImpl omOutput) throws XMLStreamException {
        this.serialize(omOutput, false, !omOutput.isIgnoreXMLDeclaration());
    }

    public void serialize(OMOutputImpl omOutput) throws XMLStreamException {
        this.serialize(omOutput, true, !omOutput.isIgnoreXMLDeclaration());
    }

    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(output, new OMOutputFormat());
        this.serializeAndConsume(omOutput);
        omOutput.flush();
    }

    public void serialize(OutputStream output) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(output, new OMOutputFormat());
        this.serialize(omOutput);
        omOutput.flush();
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(output, format);
        this.serializeAndConsume(omOutput);
        omOutput.flush();
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(output, format);
        this.serialize(omOutput);
        omOutput.flush();
    }

    public void serialize(OMOutputImpl omOutput, boolean includeXMLDeclaration) throws XMLStreamException {
        this.serialize(omOutput, true, includeXMLDeclaration);
    }

    protected void serialize(OMOutputImpl omOutput, boolean cache, boolean includeXMLDeclaration) throws XMLStreamException {
        if (includeXMLDeclaration) {
            String outputCharEncoding = omOutput.getCharSetEncoding();
            if (outputCharEncoding == null || "".equals(outputCharEncoding)) {
                omOutput.getXmlStreamWriter().writeStartDocument(this.charSetEncoding, this.xmlVersion);
            } else {
                omOutput.getXmlStreamWriter().writeStartDocument(outputCharEncoding, this.xmlVersion);
            }
        }
        Iterator children = this.getChildren();
        if (cache) {
            while (children.hasNext()) {
                OMNodeEx omNode = (OMNodeEx)children.next();
                omNode.serialize(omOutput);
            }
        } else {
            while (children.hasNext()) {
                OMNodeEx omNode = (OMNodeEx)children.next();
                omNode.serializeAndConsume(omOutput);
            }
        }
    }
}

