/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.om.impl.llom;

import org.apache.axis2.om.OMContainer;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.impl.llom.OMElementImpl;
import org.apache.axis2.om.impl.llom.OMNodeImpl;

public class OMNavigator {
    protected OMNode node;
    private boolean visited;
    private OMNode next;
    private OMNode root;
    private boolean backtracked;
    private boolean end = false;
    private boolean start = true;

    public OMNavigator() {
    }

    public OMNavigator(OMNode node) {
        this.init(node);
    }

    public void init(OMNode node) {
        this.next = node;
        this.root = node;
        this.backtracked = false;
    }

    public OMNode next() {
        if (this.next == null) {
            return null;
        }
        this.node = this.next;
        this.visited = this.backtracked;
        this.backtracked = false;
        this.updateNextNode();
        if (this.root.equals(this.node)) {
            if (!this.start) {
                this.end = true;
            } else {
                this.start = false;
            }
        }
        return this.node;
    }

    private void updateNextNode() {
        if (this.next instanceof OMElement && !this.visited) {
            OMElementImpl e = (OMElementImpl)this.next;
            if (e.firstChild != null) {
                this.next = e.firstChild;
            } else if (e.isComplete()) {
                this.backtracked = true;
            } else {
                this.next = null;
            }
        } else {
            OMNodeImpl nextSibling = ((OMNodeImpl)this.next).nextSibling;
            OMContainer parent = this.next.getParent();
            if (nextSibling != null) {
                this.next = nextSibling;
            } else if (parent != null && parent.isComplete()) {
                this.next = (OMNodeImpl)((Object)parent);
                this.backtracked = true;
            } else {
                this.next = null;
            }
        }
    }

    public boolean visited() {
        return this.visited;
    }

    public void step() {
        if (!this.end) {
            this.next = this.node;
            this.updateNextNode();
        }
    }

    public boolean isNavigable() {
        if (this.end) {
            return false;
        }
        return this.next != null;
    }

    public boolean isCompleted() {
        return this.end;
    }
}

