/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.om.impl.llom;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.om.OMContainer;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.OMOutputFormat;
import org.apache.axis2.om.OMXMLParserWrapper;
import org.apache.axis2.om.impl.OMContainerEx;
import org.apache.axis2.om.impl.OMNodeEx;
import org.apache.axis2.om.impl.OMOutputImpl;

public abstract class OMNodeImpl
implements OMNode,
OMNodeEx {
    protected OMContainerEx parent;
    protected OMNodeImpl nextSibling;
    protected OMNodeImpl previousSibling;
    protected OMXMLParserWrapper builder;
    protected boolean done = false;
    protected int nodeType;

    public OMNodeImpl() {
    }

    public OMNodeImpl(OMContainer parent) {
        if (parent != null) {
            this.parent = (OMContainerEx)parent;
            parent.addChild(this);
        }
    }

    public OMContainer getParent() {
        return this.parent;
    }

    public void setParent(OMContainer element) {
        if (this.parent == element) {
            return;
        }
        if (this.parent != null) {
            this.detach();
        }
        this.parent = (OMContainerEx)element;
    }

    public OMNode getNextOMSibling() throws OMException {
        if (this.nextSibling == null && this.parent != null && !this.parent.isComplete()) {
            this.parent.buildNext();
        }
        return this.nextSibling;
    }

    public void setNextOMSibling(OMNode node) {
        this.nextSibling = (OMNodeImpl)node;
    }

    public boolean isComplete() {
        return this.done;
    }

    public void setComplete(boolean state) {
        this.done = state;
    }

    public OMNode detach() throws OMException {
        if (this.parent == null) {
            throw new OMException("Elements that doesn't have a parent can not be detached");
        }
        OMNodeImpl nextSibling = (OMNodeImpl)this.getNextOMSibling();
        if (this.previousSibling == null) {
            this.parent.setFirstChild(nextSibling);
        } else {
            ((OMNodeEx)this.getPreviousOMSibling()).setNextOMSibling(nextSibling);
        }
        if (nextSibling != null) {
            nextSibling.setPreviousOMSibling(this.getPreviousOMSibling());
        }
        this.parent = null;
        return this;
    }

    public void insertSiblingAfter(OMNode sibling) throws OMException {
        if (this.parent == null) {
            throw new OMException();
        }
        ((OMNodeEx)sibling).setParent(this.parent);
        if (sibling instanceof OMNodeImpl) {
            OMNodeImpl siblingImpl = (OMNodeImpl)sibling;
            if (this.nextSibling == null) {
                this.getNextOMSibling();
            }
            siblingImpl.setPreviousOMSibling(this);
            if (this.nextSibling != null) {
                this.nextSibling.setPreviousOMSibling(sibling);
            }
            ((OMNodeEx)sibling).setNextOMSibling(this.nextSibling);
            this.nextSibling = siblingImpl;
        }
    }

    public void insertSiblingBefore(OMNode sibling) throws OMException {
        if (this.parent == null) {
            throw new OMException();
        }
        if (sibling instanceof OMNodeImpl) {
            OMNodeImpl siblingImpl = (OMNodeImpl)sibling;
            siblingImpl.nextSibling = this;
            if (this.previousSibling == null) {
                this.parent.setFirstChild(siblingImpl);
                siblingImpl.previousSibling = null;
            } else {
                siblingImpl.setParent(this.parent);
                this.previousSibling.setNextOMSibling(siblingImpl);
                siblingImpl.setPreviousOMSibling(this.previousSibling);
            }
            this.previousSibling = siblingImpl;
        }
    }

    public int getType() {
        return this.nodeType;
    }

    public void setType(int nodeType) throws OMException {
        this.nodeType = nodeType;
    }

    public OMNode getPreviousOMSibling() {
        return this.previousSibling;
    }

    public void setPreviousOMSibling(OMNode previousSibling) {
        this.previousSibling = (OMNodeImpl)previousSibling;
    }

    public void build() throws OMException {
        while (!this.done) {
            this.builder.next();
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(xmlWriter);
        this.serialize(omOutput);
        omOutput.flush();
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(xmlWriter);
        this.serializeAndConsume(omOutput);
        omOutput.flush();
    }

    public void serialize(OMOutputImpl omOutput) throws XMLStreamException {
        throw new RuntimeException("Not implemented yet!");
    }

    public void serializeAndConsume(OMOutputImpl omOutput) throws XMLStreamException {
        throw new RuntimeException("Not implemented yet!");
    }

    public void serialize(OutputStream output) throws XMLStreamException {
        this.serialize(XMLOutputFactory.newInstance().createXMLStreamWriter(output));
    }

    public void serialize(Writer writer) throws XMLStreamException {
        this.serialize(XMLOutputFactory.newInstance().createXMLStreamWriter(writer));
    }

    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        this.serializeAndConsume(XMLOutputFactory.newInstance().createXMLStreamWriter(output));
    }

    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        this.serializeAndConsume(XMLOutputFactory.newInstance().createXMLStreamWriter(writer));
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(output, format);
        this.serialize(omOutput);
        omOutput.flush();
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(XMLOutputFactory.newInstance().createXMLStreamWriter(writer));
        omOutput.setOutputFormat(format);
        this.serialize(omOutput);
        omOutput.flush();
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(output, format);
        this.serializeAndConsume(omOutput);
        omOutput.flush();
    }

    public void serializeAndConsume(Writer writer, OMOutputFormat format) throws XMLStreamException {
        OMOutputImpl omOutput = new OMOutputImpl(XMLOutputFactory.newInstance().createXMLStreamWriter(writer));
        omOutput.setOutputFormat(format);
        this.serializeAndConsume(omOutput);
        omOutput.flush();
    }
}

