/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.om.impl.llom.mtom;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.attachments.MIMEHelper;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.OMText;
import org.apache.axis2.om.impl.MTOMConstants;
import org.apache.axis2.om.impl.OMNodeEx;
import org.apache.axis2.soap.SOAPFactory;
import org.apache.axis2.soap.impl.llom.builder.StAXSOAPModelBuilder;

public class MTOMStAXSOAPModelBuilder
extends StAXSOAPModelBuilder
implements MTOMConstants {
    MIMEHelper mimeHelper;
    int partIndex = 0;

    public MTOMStAXSOAPModelBuilder(XMLStreamReader parser, SOAPFactory factory, MIMEHelper mimeHelper, String soapVersion) {
        super(parser, factory, soapVersion);
        this.mimeHelper = mimeHelper;
    }

    public MTOMStAXSOAPModelBuilder(XMLStreamReader reader, MIMEHelper mimeHelper, String soapVersion) {
        super(reader, soapVersion);
        this.mimeHelper = mimeHelper;
    }

    protected OMNode createOMElement() throws OMException {
        OMElement node;
        ++this.elementLevel;
        String elementName = this.parser.getLocalName();
        String namespaceURI = this.parser.getNamespaceURI();
        if ("Include".equalsIgnoreCase(elementName) && "http://www.w3.org/2004/08/xop/include".equalsIgnoreCase(namespaceURI)) {
            OMText node2;
            String contentID = null;
            String contentIDName = null;
            if (this.lastNode == null) {
                throw new OMException("XOP:Include element is not supported here");
            }
            if (this.parser.getAttributeCount() > 0) {
                contentID = this.parser.getAttributeValue(0);
                contentID = contentID.trim();
                contentIDName = this.parser.getAttributeLocalName(0);
                if (contentIDName.equalsIgnoreCase("href") & contentID.substring(0, 3).equalsIgnoreCase("cid")) {
                    contentID = contentID.substring(4);
                    String charsetEncoding = this.getDocument().getCharsetEncoding();
                    String charEnc = charsetEncoding == null || "".equals(charsetEncoding) ? "UTF-8" : charsetEncoding;
                    try {
                        contentID = URLDecoder.decode(contentID, charEnc);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new OMException("Unsupported Character Encoding Found", e);
                    }
                } else if (!(contentIDName.equalsIgnoreCase("href") & !contentID.equals(""))) {
                    throw new OMException("contentID not Found in XOP:Include element");
                }
            } else {
                throw new OMException("Href attribute not found in XOP:Include element");
            }
            try {
                OMElement e = (OMElement)this.lastNode;
                node2 = this.omfactory.createText(contentID, (OMElement)this.lastNode, this);
                e.setFirstChild(node2);
            }
            catch (ClassCastException e) {
                throw new OMException("Last Node & Parent of an OMText should be an Element" + e);
            }
            return node2;
        }
        if (this.lastNode == null) {
            node = this.constructNode(null, elementName, true);
            this.setSOAPEnvelope(node);
        } else if (this.lastNode.isComplete()) {
            node = this.constructNode((OMElement)this.lastNode.getParent(), elementName, false);
            ((OMNodeEx)this.lastNode).setNextOMSibling(node);
            ((OMNodeEx)((Object)node)).setPreviousOMSibling(this.lastNode);
        } else {
            OMElement e = (OMElement)this.lastNode;
            node = this.constructNode((OMElement)this.lastNode, elementName, false);
            e.setFirstChild(node);
        }
        this.processAttributes(node);
        return node;
    }

    public DataHandler getDataHandler(String blobContentID) throws OMException {
        return this.mimeHelper.getDataHandler(blobContentID);
    }
}

