/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.om.impl.llom.serialize;

import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.om.OMSerializer;
import org.apache.axis2.om.impl.OMOutputImpl;

public class StreamingOMSerializer
implements XMLStreamConstants,
OMSerializer {
    private int depth = 0;

    public void serialize(XMLStreamReader node, XMLStreamWriter writer) throws XMLStreamException {
        this.serializeNode(node, new OMOutputImpl(writer));
    }

    public void serialize(XMLStreamReader obj, OMOutputImpl omOutput) throws XMLStreamException {
        XMLStreamReader node = obj;
        this.serializeNode(node, omOutput);
    }

    protected void serializeNode(XMLStreamReader reader, OMOutputImpl omOutput) throws XMLStreamException {
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                this.serializeElement(reader, writer);
                ++this.depth;
            } else if (event == 10) {
                this.serializeAttributes(reader, writer);
            } else if (event == 4) {
                this.serializeText(reader, writer);
            } else if (event == 5) {
                this.serializeComment(reader, writer);
            } else if (event == 12) {
                this.serializeCData(reader, writer);
            } else if (event == 2) {
                this.serializeEndElement(writer);
                --this.depth;
            } else if (event == 8) {
                try {
                    this.serializeEndElement(writer);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.depth != 0) continue;
            break;
        }
    }

    protected void serializeElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String prefix = reader.getPrefix();
        String nameSpaceName = reader.getNamespaceURI();
        String writer_prefix = writer.getPrefix(nameSpaceName);
        if (nameSpaceName != null) {
            if (writer_prefix != null) {
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
            } else if (prefix != null) {
                writer.writeStartElement(prefix, reader.getLocalName(), nameSpaceName);
                writer.writeNamespace(prefix, nameSpaceName);
                writer.setPrefix(prefix, nameSpaceName);
            } else {
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
                writer.writeDefaultNamespace(nameSpaceName);
                writer.setDefaultNamespace(nameSpaceName);
            }
        } else {
            writer.writeStartElement(reader.getLocalName());
        }
        this.serializeAttributes(reader, writer);
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            if (namespacePrefix != null && namespacePrefix.length() == 0) continue;
            this.serializeNamespace(namespacePrefix, reader.getNamespaceURI(i), writer);
        }
    }

    protected void serializeEndElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    protected void serializeText(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(reader.getText());
    }

    protected void serializeCData(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCData(reader.getText());
    }

    protected void serializeComment(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment(reader.getText());
    }

    protected void serializeAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String prefix = null;
        String namespaceName = null;
        for (int i = 0; i < count; ++i) {
            prefix = reader.getAttributePrefix(i);
            namespaceName = reader.getAttributeNamespace(i);
            if (prefix != null && !namespaceName.equals("")) {
                writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    private void serializeNamespace(String prefix, String URI2, XMLStreamWriter writer) throws XMLStreamException {
        String prefix1 = writer.getPrefix(URI2);
        if (prefix1 == null) {
            writer.writeNamespace(prefix, URI2);
            writer.setPrefix(prefix, URI2);
        }
    }
}

