/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.phaseresolver;

import java.util.ArrayList;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.phaseresolver.PhaseException;

public class PhaseHolder {
    private ArrayList phaseList;

    public PhaseHolder() {
    }

    public PhaseHolder(ArrayList phases) {
        this.phaseList = phases;
    }

    public void addHandler(HandlerDescription handlerDesc) throws PhaseException {
        String phaseName = handlerDesc.getRules().getPhaseName();
        if (!this.isPhaseExist(phaseName)) {
            throw new PhaseException(Messages.getMessage("invalidphase", phaseName, handlerDesc.getName().getLocalPart()));
        }
        this.getPhase(phaseName).addHandler(handlerDesc);
    }

    public void buildTransportHandlerChain(Phase phase, ArrayList handlers) throws PhaseException {
        try {
            Class<?> handlerClass = null;
            for (int i = 0; i < handlers.size(); ++i) {
                HandlerDescription description = (HandlerDescription)handlers.get(i);
                handlerClass = Class.forName(description.getClassName(), true, Thread.currentThread().getContextClassLoader());
                Handler handler = (Handler)handlerClass.newInstance();
                handler.init(description);
                description.setHandler(handler);
                phase.addHandler(description.getHandler());
            }
        }
        catch (ClassNotFoundException e) {
            throw new PhaseException(e);
        }
        catch (InstantiationException e) {
            throw new PhaseException(e);
        }
        catch (IllegalAccessException e) {
            throw new PhaseException(e);
        }
    }

    private Phase getPhase(String phaseName) {
        for (int i = 0; i < this.phaseList.size(); ++i) {
            Phase phase = (Phase)this.phaseList.get(i);
            if (!phase.getPhaseName().equals(phaseName)) continue;
            return phase;
        }
        return null;
    }

    private boolean isPhaseExist(String phaseName) {
        for (int i = 0; i < this.phaseList.size(); ++i) {
            Phase phase = (Phase)this.phaseList.get(i);
            if (!phase.getPhaseName().equals(phaseName)) continue;
            return true;
        }
        return false;
    }
}

