/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.phaseresolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.axis2.phaseresolver.PhaseHolder;

public class PhaseResolver {
    private static final int IN_FLOW = 1;
    private static final int OUT_FAULT_FLOW = 5;
    private AxisConfiguration axisConfig;
    private PhaseHolder phaseHolder;

    public PhaseResolver(AxisConfiguration engineConfig) {
        this.axisConfig = engineConfig;
    }

    private void buildINTransportChains(TransportInDescription transport) throws PhaseException {
        Flow flow = null;
        Phase phase = null;
        for (int type = 1; type < 5; ++type) {
            switch (type) {
                case 1: {
                    flow = transport.getInFlow();
                    phase = transport.getInPhase();
                    break;
                }
                case 3: {
                    flow = transport.getFaultFlow();
                    phase = transport.getFaultPhase();
                }
            }
            if (flow == null) continue;
            ArrayList<HandlerDescription> handlers = new ArrayList<HandlerDescription>();
            for (int j = 0; j < flow.getHandlerCount(); ++j) {
                HandlerDescription metadata = flow.getHandler(j);
                metadata.getRules().setPhaseName("TRANSPORT");
                handlers.add(metadata);
            }
            new PhaseHolder().buildTransportHandlerChain(phase, handlers);
        }
    }

    private void buildOutTransportChains(TransportOutDescription transport) throws PhaseException {
        Flow flow = null;
        Phase phase = null;
        for (int type = 1; type < 5; ++type) {
            switch (type) {
                case 2: {
                    flow = transport.getOutFlow();
                    phase = transport.getOutPhase();
                    break;
                }
                case 4: {
                    flow = transport.getFaultFlow();
                    phase = transport.getFaultPhase();
                }
            }
            if (flow == null) continue;
            ArrayList<HandlerDescription> handlers = new ArrayList<HandlerDescription>();
            for (int j = 0; j < flow.getHandlerCount(); ++j) {
                HandlerDescription metadata = flow.getHandler(j);
                metadata.getRules().setPhaseName("TRANSPORT");
                handlers.add(metadata);
            }
            new PhaseHolder().buildTransportHandlerChain(phase, handlers);
        }
    }

    public void buildTranspotsChains() throws PhaseException {
        HashMap axisTransportIn = this.axisConfig.getTransportsIn();
        HashMap axisTransportOut = this.axisConfig.getTransportsOut();
        Collection colintrnsport = axisTransportIn.values();
        Iterator iterator = colintrnsport.iterator();
        while (iterator.hasNext()) {
            TransportInDescription transport = (TransportInDescription)iterator.next();
            this.buildINTransportChains(transport);
        }
        Collection colouttrnsport = axisTransportOut.values();
        Iterator iterator2 = colouttrnsport.iterator();
        while (iterator2.hasNext()) {
            TransportOutDescription transport = (TransportOutDescription)iterator2.next();
            this.buildOutTransportChains(transport);
        }
    }

    public void engageModuleToOperation(AxisOperation axisOperation, ModuleDescription module) throws PhaseException {
        Flow flow = null;
        for (int type = 1; type < 5; ++type) {
            switch (type) {
                case 1: {
                    Object o;
                    Iterator itr_axis_config;
                    ArrayList phases = new ArrayList();
                    if (this.axisConfig != null) {
                        itr_axis_config = this.axisConfig.getInPhasesUptoAndIncludingPostDispatch().iterator();
                        while (itr_axis_config.hasNext()) {
                            o = itr_axis_config.next();
                            phases.add(o);
                        }
                    }
                    Iterator itr_ops = axisOperation.getRemainingPhasesInFlow().iterator();
                    while (itr_ops.hasNext()) {
                        o = itr_ops.next();
                        phases.add(o);
                    }
                    this.phaseHolder = new PhaseHolder(phases);
                    break;
                }
                case 2: {
                    Object o;
                    ArrayList phases = new ArrayList();
                    Iterator itr_ops = axisOperation.getPhasesOutFlow().iterator();
                    while (itr_ops.hasNext()) {
                        o = itr_ops.next();
                        phases.add(o);
                    }
                    if (this.axisConfig != null) {
                        Iterator itr_axis_config = this.axisConfig.getGlobalOutPhases().iterator();
                        while (itr_axis_config.hasNext()) {
                            Object o2 = itr_axis_config.next();
                            phases.add(o2);
                        }
                    }
                    this.phaseHolder = new PhaseHolder(phases);
                    break;
                }
                case 3: {
                    Object o;
                    Iterator itr_axis_config;
                    ArrayList phases = new ArrayList();
                    if (this.axisConfig != null) {
                        itr_axis_config = this.axisConfig.getInFaultFlow().iterator();
                        while (itr_axis_config.hasNext()) {
                            o = itr_axis_config.next();
                            phases.add(o);
                        }
                    }
                    Iterator itr_ops = axisOperation.getPhasesInFaultFlow().iterator();
                    while (itr_ops.hasNext()) {
                        o = itr_ops.next();
                        phases.add(o);
                    }
                    this.phaseHolder = new PhaseHolder(phases);
                    break;
                }
                case 4: {
                    this.phaseHolder = new PhaseHolder(axisOperation.getPhasesOutFaultFlow());
                }
            }
            switch (type) {
                case 1: {
                    flow = module.getInFlow();
                    break;
                }
                case 2: {
                    flow = module.getOutFlow();
                    break;
                }
                case 3: {
                    flow = module.getFaultInFlow();
                    break;
                }
                case 4: {
                    flow = module.getFaultOutFlow();
                }
            }
            if (flow == null) continue;
            for (int j = 0; j < flow.getHandlerCount(); ++j) {
                HandlerDescription metadata = flow.getHandler(j);
                this.phaseHolder.addHandler(metadata);
            }
        }
    }
}

