/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.receivers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.soap.SOAPFactory;

public abstract class AbstractMessageReceiver
implements MessageReceiver {
    public static final String SERVICE_CLASS = "ServiceClass";
    public static final String SCOPE = "scope";

    protected Object makeNewServiceObject(MessageContext msgContext) throws AxisFault {
        try {
            AxisService service = msgContext.getOperationContext().getServiceContext().getAxisService();
            ClassLoader classLoader = service.getClassLoader();
            Parameter implInfoParam = service.getParameter(SERVICE_CLASS);
            if (implInfoParam != null) {
                Class<?> implClass = Class.forName(((String)implInfoParam.getValue()).trim(), true, classLoader);
                return implClass.newInstance();
            }
            throw new AxisFault(Messages.getMessage("paramIsNotSpecified", "SERVICE_CLASS"));
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    public SOAPFactory getSOAPFactory(MessageContext msgContext) throws AxisFault {
        String nsURI = msgContext.getEnvelope().getNamespace().getName();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage("invalidSOAPversion"));
    }

    protected Object getTheImplementationObject(MessageContext msgContext) throws AxisFault {
        ServiceContext serviceContext = msgContext.getOperationContext().getServiceContext();
        Object serviceimpl = serviceContext.getServiceImpl();
        if (serviceimpl != null) {
            return serviceimpl;
        }
        serviceimpl = this.makeNewServiceObject(msgContext);
        serviceContext.setServiceImpl(serviceimpl);
        return serviceimpl;
    }
}

