/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.soap.impl.llom;

import org.apache.axis2.om.OMConstants;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.OMXMLParserWrapper;
import org.apache.axis2.soap.SOAPBody;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFault;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.soap.impl.llom.SOAPElement;
import org.apache.axis2.soap.impl.llom.SOAPEnvelopeImpl;

public abstract class SOAPBodyImpl
extends SOAPElement
implements SOAPBody,
OMConstants {
    private boolean hasSOAPFault = false;

    public SOAPBodyImpl(SOAPEnvelope envelope) throws SOAPProcessingException {
        super((OMElement)envelope, "Body", true);
    }

    public SOAPBodyImpl(SOAPEnvelope envelope, OMXMLParserWrapper builder) {
        super((OMElement)envelope, "Body", builder);
    }

    public abstract SOAPFault addFault(Exception var1) throws OMException;

    public boolean hasFault() {
        if (this.hasSOAPFault) {
            return true;
        }
        OMElement element = this.getFirstElement();
        if (element != null && "Fault".equals(element.getLocalName()) && ("http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespace().getName()) || "http://www.w3.org/2003/05/soap-envelope".equals(element.getNamespace().getName()))) {
            this.hasSOAPFault = true;
            return true;
        }
        return false;
    }

    public SOAPFault getFault() {
        OMElement element = this.getFirstElement();
        if (this.hasSOAPFault) {
            return (SOAPFault)element;
        }
        if (element != null && "Fault".equals(element.getLocalName()) && ("http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespace().getName()) || "http://www.w3.org/2003/05/soap-envelope".equals(element.getNamespace().getName()))) {
            this.hasSOAPFault = true;
            return (SOAPFault)element;
        }
        return null;
    }

    public void addFault(SOAPFault soapFault) throws OMException {
        if (this.hasSOAPFault) {
            throw new OMException("SOAP Body already has a SOAP Fault and there can not be more than one SOAP fault");
        }
        this.addChild(soapFault);
        this.hasSOAPFault = true;
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAPEnvelopeImpl)) {
            throw new SOAPProcessingException("Expecting an implementation of SOAP Envelope as the parent. But received some other implementation");
        }
    }

    public OMNode detach() throws OMException {
        throw new SOAPProcessingException("Can not detach SOAP Body, SOAP Envelope must have a Body !!");
    }
}

