/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.soap.impl.llom;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMConstants;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.OMNamespace;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.OMXMLParserWrapper;
import org.apache.axis2.om.impl.OMOutputImpl;
import org.apache.axis2.soap.SOAPBody;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFactory;
import org.apache.axis2.soap.SOAPHeader;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.soap.impl.llom.SOAPElement;
import org.apache.axis2.soap.impl.llom.factory.SOAPLinkedListImplFactory;

public class SOAPEnvelopeImpl
extends SOAPElement
implements SOAPEnvelope,
OMConstants {
    SOAPFactory factory;

    public SOAPEnvelopeImpl(OMXMLParserWrapper builder, SOAPFactory factory) {
        super(null, "Envelope", builder);
        this.factory = factory;
    }

    public SOAPEnvelopeImpl(OMNamespace ns, SOAPFactory factory) {
        super("Envelope", ns);
        this.factory = factory;
    }

    public SOAPHeader getHeader() throws OMException {
        SOAPHeader header = (SOAPHeader)this.getFirstChildWithName(new QName("Header"));
        if (this.builder == null && header == null) {
            this.inferFactory();
            header = this.factory.createSOAPHeader(this);
            this.addChild(header);
        }
        return header;
    }

    private void inferFactory() {
        if (this.factory instanceof SOAPLinkedListImplFactory && this.ns != null) {
            if ("http://www.w3.org/2003/05/soap-envelope".equals(this.ns.getName())) {
                this.factory = OMAbstractFactory.getSOAP12Factory();
            } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.ns.getName())) {
                this.factory = OMAbstractFactory.getSOAP11Factory();
            }
        }
    }

    public void addChild(OMNode child) {
        if (child instanceof OMElement && !(child instanceof SOAPHeader) && !(child instanceof SOAPBody)) {
            throw new SOAPProcessingException("SOAP Envelope can not have children other than SOAP Header and Body", "Sender");
        }
        super.addChild(child);
    }

    public SOAPBody getBody() throws OMException {
        OMElement element = this.getFirstElement();
        if (element != null) {
            OMNode node;
            if ("Body".equals(element.getLocalName())) {
                return (SOAPBody)element;
            }
            for (node = element.getNextOMSibling(); node != null && node.getType() != 1; node = node.getNextOMSibling()) {
            }
            element = (OMElement)node;
            if (node != null && "Body".equals(element.getLocalName())) {
                return (SOAPBody)element;
            }
            throw new OMException("SOAPEnvelope must contain a body element which is either first or second child element of the SOAPEnvelope.");
        }
        return null;
    }

    public OMNode detach() throws OMException {
        throw new OMException("Root Element can not be detached");
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
    }

    protected void serialize(OMOutputImpl omOutput, boolean cache) throws XMLStreamException {
        if (!omOutput.isIgnoreXMLDeclaration()) {
            String charSetEncoding = omOutput.getCharSetEncoding();
            String xmlVersion = omOutput.getXmlVersion();
            omOutput.getXmlStreamWriter().writeStartDocument(charSetEncoding == null ? "utf-8" : charSetEncoding, xmlVersion == null ? "1.0" : xmlVersion);
        }
        super.serialize(omOutput, cache);
    }
}

