/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.soap.impl.llom;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.om.OMConstants;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.OMXMLParserWrapper;
import org.apache.axis2.om.impl.OMNodeEx;
import org.apache.axis2.om.impl.OMOutputImpl;
import org.apache.axis2.om.impl.llom.OMElementImpl;
import org.apache.axis2.om.impl.llom.OMSerializerUtil;
import org.apache.axis2.om.impl.llom.serialize.StreamWriterToContentHandlerConverter;
import org.apache.axis2.soap.SOAPBody;
import org.apache.axis2.soap.SOAPFault;
import org.apache.axis2.soap.SOAPFaultCode;
import org.apache.axis2.soap.SOAPFaultDetail;
import org.apache.axis2.soap.SOAPFaultNode;
import org.apache.axis2.soap.SOAPFaultReason;
import org.apache.axis2.soap.SOAPFaultRole;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.soap.impl.llom.SOAPElement;
import org.apache.axis2.soap.impl.llom.SOAPFaultRoleImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SOAPFaultImpl
extends SOAPElement
implements SOAPFault,
OMConstants {
    protected Exception e;
    private Log log = LogFactory.getLog(this.getClass());

    public SOAPFaultImpl(SOAPBody parent, Exception e) throws SOAPProcessingException {
        super((OMElement)parent, "Fault", true);
        this.setException(e);
    }

    public void setException(Exception e) {
        this.e = e;
        this.putExceptionToSOAPFault(e);
    }

    public SOAPFaultImpl(SOAPBody parent) throws SOAPProcessingException {
        super((OMElement)parent, "Fault", true);
    }

    public SOAPFaultImpl(SOAPBody parent, OMXMLParserWrapper builder) {
        super((OMElement)parent, "Fault", builder);
    }

    protected abstract SOAPFaultDetail getNewSOAPFaultDetail(SOAPFault var1) throws SOAPProcessingException;

    public void setCode(SOAPFaultCode soapFaultCode) throws SOAPProcessingException {
        this.setNewElement(this.getCode(), soapFaultCode);
    }

    public SOAPFaultCode getCode() {
        return (SOAPFaultCode)this.getChildWithName("Code");
    }

    public void setReason(SOAPFaultReason reason) throws SOAPProcessingException {
        this.setNewElement(this.getReason(), reason);
    }

    public SOAPFaultReason getReason() {
        return (SOAPFaultReason)this.getChildWithName("Reason");
    }

    public void setNode(SOAPFaultNode node) throws SOAPProcessingException {
        this.setNewElement(this.getNode(), node);
    }

    public SOAPFaultNode getNode() {
        return (SOAPFaultNode)this.getChildWithName("Node");
    }

    public void setRole(SOAPFaultRole role) throws SOAPProcessingException {
        this.setNewElement(this.getRole(), role);
    }

    public SOAPFaultRole getRole() {
        return (SOAPFaultRoleImpl)this.getChildWithName("Role");
    }

    public void setDetail(SOAPFaultDetail detail) throws SOAPProcessingException {
        this.setNewElement(this.getDetail(), detail);
    }

    public SOAPFaultDetail getDetail() {
        return (SOAPFaultDetail)this.getChildWithName("Detail");
    }

    public Exception getException() throws OMException {
        SOAPFaultDetail detail = this.getDetail();
        if (detail == null) {
            return null;
        }
        OMElement exceptionElement = this.getDetail().getFirstChildWithName(new QName("Exception"));
        if (exceptionElement != null && exceptionElement.getText() != null) {
            return new Exception(exceptionElement.getText());
        }
        return null;
    }

    protected void putExceptionToSOAPFault(Exception e) throws SOAPProcessingException {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sw.flush();
        this.getDetail();
        if (this.getDetail() == null) {
            this.setDetail(this.getNewSOAPFaultDetail(this));
        }
        OMElementImpl faultDetailEnty = new OMElementImpl("Exception", this.getNamespace());
        faultDetailEnty.setText(sw.getBuffer().toString());
        this.getDetail().addChild(faultDetailEnty);
    }

    protected void setNewElement(OMElement myElement, OMElement newElement) {
        if (myElement != null) {
            myElement.discard();
        }
        if (newElement != null && newElement.getParent() != null) {
            newElement.discard();
        }
        this.addChild(newElement);
        myElement = newElement;
    }

    protected OMElement getChildWithName(String childName) {
        Iterator childrenIter = this.getChildren();
        while (childrenIter.hasNext()) {
            OMNode node = (OMNode)childrenIter.next();
            if (node.getType() != 1 || !childName.equals(((OMElement)node).getLocalName())) continue;
            return (OMElement)node;
        }
        return null;
    }

    protected void serialize(OMOutputImpl omOutput, boolean cache) throws XMLStreamException {
        SOAPFaultDetail faultDetail;
        SOAPFaultReason faultReason;
        short builderType = 1;
        if (this.builder != null) {
            builderType = this.builder.getBuilderType();
        }
        if (builderType == 0 && this.builder.getRegisteredContentHandler() == null) {
            this.builder.registerExternalContentHandler(new StreamWriterToContentHandlerConverter(omOutput));
        }
        this.build();
        OMSerializerUtil.serializeStartpart(this, omOutput);
        SOAPFaultCode faultCode = this.getCode();
        if (faultCode != null) {
            ((OMNodeEx)((Object)faultCode)).serialize(omOutput);
        }
        if ((faultReason = this.getReason()) != null) {
            ((OMNodeEx)((Object)faultReason)).serialize(omOutput);
        }
        this.serializeFaultNode(omOutput);
        SOAPFaultRole faultRole = this.getRole();
        if (faultRole != null) {
            ((OMNodeEx)((Object)faultRole)).serialize(omOutput);
        }
        if ((faultDetail = this.getDetail()) != null) {
            ((OMNodeEx)((Object)faultDetail)).serialize(omOutput);
        }
        OMSerializerUtil.serializeEndpart(omOutput);
    }

    protected abstract void serializeFaultNode(OMOutputImpl var1) throws XMLStreamException;
}

