/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.soap.impl.llom.builder;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMText;
import org.apache.axis2.om.impl.OMNodeEx;
import org.apache.axis2.om.impl.llom.exception.OMBuilderException;
import org.apache.axis2.soap.SOAP11Constants;
import org.apache.axis2.soap.SOAPFactory;
import org.apache.axis2.soap.SOAPFault;
import org.apache.axis2.soap.SOAPFaultCode;
import org.apache.axis2.soap.SOAPFaultReason;
import org.apache.axis2.soap.SOAPFaultText;
import org.apache.axis2.soap.SOAPFaultValue;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.soap.impl.llom.builder.SOAPBuilderHelper;
import org.apache.axis2.soap.impl.llom.builder.StAXSOAPModelBuilder;
import org.w3c.dom.Element;

public class SOAP11BuilderHelper
extends SOAPBuilderHelper
implements SOAP11Constants {
    private SOAPFactory factory;
    private boolean faultcodePresent = false;
    private boolean faultstringPresent = false;
    private OMElement lastProcessedSOAPElement;

    public SOAP11BuilderHelper(StAXSOAPModelBuilder builder) {
        super(builder);
        this.factory = builder.getSoapFactory();
    }

    public OMElement handleEvent(XMLStreamReader parser, OMElement parent, int elementLevel) throws SOAPProcessingException {
        this.parser = parser;
        OMElement element = null;
        String localName = parser.getLocalName();
        if (elementLevel == 4) {
            if ("faultcode".equals(localName)) {
                if (this.faultstringPresent) {
                    this.builder.setBooleanProcessingMandatoryFaultElements(false);
                }
                SOAPFaultCode code = this.factory.createSOAPFaultCode((SOAPFault)parent, this.builder);
                SOAPFaultValue value = this.factory.createSOAPFaultValue(code);
                this.processNamespaceData(code, true);
                this.processAttributes(code);
                this.processText(parser, value);
                ((OMNodeEx)((Object)code)).setComplete(true);
                element = code;
                --this.builder.elementLevel;
                this.faultcodePresent = true;
            } else if ("faultstring".equals(localName)) {
                if (this.faultcodePresent) {
                    this.builder.setBooleanProcessingMandatoryFaultElements(false);
                }
                SOAPFaultReason reason = this.factory.createSOAPFaultReason((SOAPFault)parent, this.builder);
                SOAPFaultText faultText = this.factory.createSOAPFaultText(reason);
                this.processNamespaceData(reason, true);
                this.processAttributes(reason);
                this.processText(parser, faultText);
                ((OMNodeEx)((Object)reason)).setComplete(true);
                element = reason;
                --this.builder.elementLevel;
                this.faultstringPresent = true;
            } else if ("faultactor".equals(localName)) {
                element = this.factory.createSOAPFaultRole((SOAPFault)parent, this.builder);
                this.processNamespaceData(element, true);
                this.processAttributes(element);
            } else if ("detail".equals(localName)) {
                element = this.factory.createSOAPFaultDetail((SOAPFault)parent, this.builder);
                this.processNamespaceData(element, true);
                this.processAttributes(element);
            } else {
                element = this.factory.createOMElement(localName, null, parent, this.builder);
                this.processNamespaceData(element, false);
                this.processAttributes(element);
            }
        } else if (elementLevel == 5) {
            String parentTagName = "";
            parentTagName = parent instanceof Element ? ((Element)((Object)parent)).getTagName() : parent.getLocalName();
            if (parentTagName.equals("faultcode")) {
                throw new OMBuilderException("faultcode element should not have children");
            }
            if (parentTagName.equals("faultstring")) {
                throw new OMBuilderException("faultstring element should not have children");
            }
            if (parentTagName.equals("faultactor")) {
                throw new OMBuilderException("faultactor element should not have children");
            }
            element = this.factory.createOMElement(localName, null, parent, this.builder);
            this.processNamespaceData(element, false);
            this.processAttributes(element);
        } else if (elementLevel > 5) {
            element = this.factory.createOMElement(localName, null, parent, this.builder);
            this.processNamespaceData(element, false);
            this.processAttributes(element);
        }
        return element;
    }

    private void processText(XMLStreamReader parser, OMElement value) {
        try {
            int token = parser.next();
            while (token != 2) {
                if (token != 4) {
                    throw new SOAPProcessingException("Only Characters are allowed here");
                }
                OMText text = this.factory.createText(value, parser.getText());
                value.addChild(text);
                token = parser.next();
            }
        }
        catch (XMLStreamException e) {
            throw new SOAPProcessingException(e);
        }
    }
}

