/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.soap.impl.llom.builder;

import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMNamespace;
import org.apache.axis2.om.impl.llom.exception.OMBuilderException;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.soap.impl.llom.builder.StAXSOAPModelBuilder;

public abstract class SOAPBuilderHelper {
    protected StAXSOAPModelBuilder builder;
    protected XMLStreamReader parser;

    protected SOAPBuilderHelper(StAXSOAPModelBuilder builder) {
        this.builder = builder;
    }

    public abstract OMElement handleEvent(XMLStreamReader var1, OMElement var2, int var3) throws SOAPProcessingException;

    protected void processNamespaceData(OMElement node, boolean isSOAPElement) {
        int namespaceCount = this.parser.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            node.declareNamespace(this.parser.getNamespaceURI(i), this.parser.getNamespacePrefix(i));
        }
        String namespaceURI = this.parser.getNamespaceURI();
        String prefix = this.parser.getPrefix();
        OMNamespace namespace = null;
        if (namespaceURI != null && namespaceURI.length() > 0) {
            if (prefix == null) {
                namespace = node.findNamespace(namespaceURI, "");
                if (namespace == null) {
                    namespace = node.declareNamespace(namespaceURI, "");
                }
            } else {
                namespace = node.findNamespace(namespaceURI, prefix);
            }
            node.setNamespace(namespace);
        }
        if (isSOAPElement && node.getNamespace() != null && !node.getNamespace().getName().equals("http://schemas.xmlsoap.org/soap/envelope/") && !node.getNamespace().getName().equals("http://www.w3.org/2003/05/soap-envelope")) {
            throw new OMBuilderException("invalid SOAP namespace URI");
        }
    }

    protected void processAttributes(OMElement node) {
        int attribCount = this.parser.getAttributeCount();
        for (int i = 0; i < attribCount; ++i) {
            OMNamespace ns = null;
            String uri = this.parser.getAttributeNamespace(i);
            if (uri.hashCode() != 0) {
                ns = node.findNamespace(uri, this.parser.getAttributePrefix(i));
            }
            node.addAttribute(this.parser.getAttributeLocalName(i), this.parser.getAttributeValue(i), ns);
        }
    }
}

