/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.soap.impl.llom.builder;

import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMDocument;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.OMNamespace;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.impl.OMNodeEx;
import org.apache.axis2.om.impl.llom.builder.StAXOMBuilder;
import org.apache.axis2.soap.SOAPBody;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFactory;
import org.apache.axis2.soap.SOAPFault;
import org.apache.axis2.soap.SOAPHeader;
import org.apache.axis2.soap.SOAPHeaderBlock;
import org.apache.axis2.soap.SOAPMessage;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.soap.impl.llom.builder.SOAP11BuilderHelper;
import org.apache.axis2.soap.impl.llom.builder.SOAP12BuilderHelper;
import org.apache.axis2.soap.impl.llom.builder.SOAPBuilderHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StAXSOAPModelBuilder
extends StAXOMBuilder {
    SOAPMessage soapMessage;
    private SOAPEnvelope envelope;
    private OMNamespace envelopeNamespace;
    private SOAPFactory soapFactory;
    private boolean headerPresent = false;
    private boolean bodyPresent = false;
    private Log log = LogFactory.getLog(this.getClass());
    protected int elementLevel = 0;
    private boolean processingFault = false;
    private boolean processingDetailElements = false;
    private SOAPBuilderHelper builderHelper;
    private String senderfaultCode;
    private String receiverfaultCode;
    private boolean processingMandatoryFaultElements;
    private boolean isTempSOAPFactory = true;

    public StAXSOAPModelBuilder(XMLStreamReader parser, String soapVersion) {
        super(parser);
        this.soapFactory = OMAbstractFactory.getDefaultSOAPFactory();
        this.isTempSOAPFactory = true;
        this.soapMessage = this.soapFactory.createSOAPMessage(this);
        this.document = this.soapMessage;
        if (parser.getCharacterEncodingScheme() != null) {
            this.document.setCharsetEncoding(parser.getCharacterEncodingScheme());
        }
        this.identifySOAPVersion(soapVersion);
        this.parseHeaders();
    }

    public StAXSOAPModelBuilder(XMLStreamReader parser, SOAPFactory factory, String soapVersion) {
        super(factory, parser);
        this.soapFactory = factory;
        this.isTempSOAPFactory = false;
        this.soapMessage = this.soapFactory.createSOAPMessage(this);
        this.document = this.soapMessage;
        this.identifySOAPVersion(soapVersion);
        this.parseHeaders();
    }

    private void identifySOAPVersion(String soapVersionURIFromTransport) {
        SOAPEnvelope soapEnvelope = this.getSOAPEnvelope();
        if (soapEnvelope == null) {
            throw new SOAPProcessingException("SOAP Message does not contain an Envelope", "env:VersionMismatch");
        }
        this.envelopeNamespace = soapEnvelope.getNamespace();
        String namespaceName = this.envelopeNamespace.getName();
        if (soapVersionURIFromTransport != null && !soapVersionURIFromTransport.equals(namespaceName)) {
            throw new SOAPProcessingException("Transport level information does not match with SOAP Message namespace URI", "env:VersionMismatch");
        }
        if (this.isTempSOAPFactory) {
            if ("http://www.w3.org/2003/05/soap-envelope".equals(namespaceName)) {
                this.soapFactory = OMAbstractFactory.getSOAP12Factory();
                this.log.info((Object)"Starting to process SOAP 1.2 message");
            } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceName)) {
                this.soapFactory = OMAbstractFactory.getSOAP11Factory();
                this.log.info((Object)"Starting to process SOAP 1.1 message");
            } else {
                throw new SOAPProcessingException("Only SOAP 1.1 or SOAP 1.2 messages are supported in the system", "env:VersionMismatch");
            }
        }
    }

    private void parseHeaders() {
        SOAPHeader soapHeader = this.getSOAPEnvelope().getHeader();
        if (soapHeader != null) {
            while (!soapHeader.isComplete()) {
                this.next();
            }
        } else {
            this.log.info((Object)"No SOAPHeaders present !!");
        }
    }

    public SOAPEnvelope getSOAPEnvelope() throws OMException {
        while (this.envelope == null && !this.done) {
            this.next();
        }
        return this.envelope;
    }

    protected OMNode createOMElement() throws OMException {
        OMElement node;
        ++this.elementLevel;
        String elementName = this.parser.getLocalName();
        if (this.lastNode == null) {
            node = this.constructNode(null, elementName, true);
            this.setSOAPEnvelope(node);
        } else if (this.lastNode.isComplete()) {
            node = this.constructNode((OMElement)this.lastNode.getParent(), elementName, false);
            ((OMNodeEx)this.lastNode).setNextOMSibling(node);
            ((OMNodeEx)((Object)node)).setPreviousOMSibling(this.lastNode);
        } else {
            OMElement e = (OMElement)this.lastNode;
            node = this.constructNode((OMElement)this.lastNode, elementName, false);
            e.setFirstChild(node);
        }
        this.log.debug((Object)("Build the OMElelment " + node.getLocalName() + "By the StaxSOAPModelBuilder"));
        return node;
    }

    protected void setSOAPEnvelope(OMElement node) {
        this.soapMessage.setSOAPEnvelope((SOAPEnvelope)node);
        this.soapMessage.setXMLVersion(this.parser.getVersion());
        this.soapMessage.setCharsetEncoding(this.parser.getCharacterEncodingScheme());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OMElement constructNode(OMElement parent, String elementName, boolean isEnvelope) {
        void var4_12;
        Object var4_4 = null;
        if (parent == null) {
            if (!elementName.equalsIgnoreCase("Envelope")) {
                throw new SOAPProcessingException("First Element must contain the local name, Envelope", "env:VersionMismatch");
            }
            SOAPEnvelope sOAPEnvelope = this.envelope = this.soapFactory.createSOAPEnvelope(this);
            this.processNamespaceData(sOAPEnvelope, true);
            this.processAttributes(sOAPEnvelope);
            return var4_12;
        }
        if (this.elementLevel == 2) {
            if (elementName.equals("Header")) {
                if (this.headerPresent) {
                    throw new SOAPProcessingException("Multiple headers encountered!", this.getSenderFaultCode());
                }
                if (this.bodyPresent) {
                    throw new SOAPProcessingException("Header Body wrong order!", this.getSenderFaultCode());
                }
                this.headerPresent = true;
                SOAPHeader sOAPHeader = this.soapFactory.createSOAPHeader((SOAPEnvelope)parent, this);
                this.processNamespaceData(sOAPHeader, true);
                this.processAttributes(sOAPHeader);
                return var4_12;
            } else {
                if (!elementName.equals("Body")) throw new SOAPProcessingException(elementName + " is not supported here. Envelope can not have elements other than Header and Body.", this.getSenderFaultCode());
                if (this.bodyPresent) {
                    throw new SOAPProcessingException("Multiple body elements encountered", this.getSenderFaultCode());
                }
                this.bodyPresent = true;
                SOAPBody sOAPBody = this.soapFactory.createSOAPBody((SOAPEnvelope)parent, this);
                this.processNamespaceData(sOAPBody, true);
                this.processAttributes(sOAPBody);
            }
            return var4_12;
        }
        if (this.elementLevel == 3 && parent.getLocalName().equalsIgnoreCase("Header")) {
            SOAPHeaderBlock sOAPHeaderBlock;
            try {
                sOAPHeaderBlock = this.soapFactory.createSOAPHeaderBlock(elementName, null, (SOAPHeader)parent, this);
            }
            catch (SOAPProcessingException e) {
                throw new SOAPProcessingException("Can not create SOAPHeader block", this.getReceiverFaultCode(), e);
            }
            this.processNamespaceData(sOAPHeaderBlock, false);
            this.processAttributes(sOAPHeaderBlock);
            return var4_12;
        }
        if (this.elementLevel == 3 && parent.getLocalName().equalsIgnoreCase("Body") && elementName.equalsIgnoreCase("Fault")) {
            SOAPFault sOAPFault = this.soapFactory.createSOAPFault((SOAPBody)parent, this);
            this.processNamespaceData(sOAPFault, false);
            this.processAttributes(sOAPFault);
            this.processingFault = true;
            this.processingMandatoryFaultElements = true;
            if ("http://www.w3.org/2003/05/soap-envelope".equals(this.envelopeNamespace.getName())) {
                this.builderHelper = new SOAP12BuilderHelper(this);
                return var4_12;
            } else {
                if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(this.envelopeNamespace.getName())) return var4_12;
                this.builderHelper = new SOAP11BuilderHelper(this);
            }
            return var4_12;
        } else if (this.elementLevel > 3 && this.processingFault) {
            OMElement oMElement = this.builderHelper.handleEvent(this.parser, parent, this.elementLevel);
            return var4_12;
        } else {
            OMElement oMElement = this.soapFactory.createOMElement(elementName, null, parent, this);
            this.processNamespaceData(oMElement, false);
            this.processAttributes(oMElement);
        }
        return var4_12;
    }

    private String getSenderFaultCode() {
        if (this.senderfaultCode == null) {
            this.senderfaultCode = "http://www.w3.org/2003/05/soap-envelope".equals(this.envelopeNamespace.getName()) ? "Sender" : "Client";
        }
        return this.senderfaultCode;
    }

    private String getReceiverFaultCode() {
        if (this.receiverfaultCode == null) {
            this.receiverfaultCode = "http://www.w3.org/2003/05/soap-envelope".equals(this.envelopeNamespace.getName()) ? "Receiver" : "Server";
        }
        return this.receiverfaultCode;
    }

    public void endElement() {
        if (this.lastNode.isComplete()) {
            OMElement parent = (OMElement)this.lastNode.getParent();
            ((OMNodeEx)((Object)parent)).setComplete(true);
            this.lastNode = parent;
        } else {
            OMNode e = this.lastNode;
            ((OMNodeEx)e).setComplete(true);
        }
        --this.elementLevel;
    }

    protected OMNode createDTD() throws OMException {
        throw new OMException("SOAP message MUST NOT contain a Document Type Declaration(DTD)");
    }

    protected OMNode createPI() throws OMException {
        throw new OMException("SOAP message MUST NOT contain Processing Instructions(PI)");
    }

    public OMElement getDocumentElement() {
        return this.getSOAPEnvelope();
    }

    protected void processNamespaceData(OMElement node, boolean isSOAPElement) {
        super.processNamespaceData(node, isSOAPElement);
        if (isSOAPElement && node.getNamespace() != null && !node.getNamespace().getName().equals("http://schemas.xmlsoap.org/soap/envelope/") && !node.getNamespace().getName().equals("http://www.w3.org/2003/05/soap-envelope")) {
            throw new SOAPProcessingException("invalid SOAP namespace URI. Only http://schemas.xmlsoap.org/soap/envelope/ and http://www.w3.org/2003/05/soap-envelope are supported.", "Sender");
        }
    }

    public OMNamespace getEnvelopeNamespace() {
        return this.envelopeNamespace;
    }

    public void setBooleanProcessingMandatoryFaultElements(boolean value) {
        this.processingMandatoryFaultElements = value;
    }

    public boolean isProcessingDetailElements() {
        return this.processingDetailElements;
    }

    public void setProcessingDetailElements(boolean value) {
        this.processingDetailElements = value;
    }

    public SOAPMessage getSoapMessage() {
        return this.soapMessage;
    }

    public OMDocument getDocument() {
        return this.soapMessage;
    }

    protected SOAPFactory getSoapFactory() {
        return this.soapFactory;
    }
}

