/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.soap.impl.llom.soap11;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMXMLParserWrapper;
import org.apache.axis2.om.impl.OMOutputImpl;
import org.apache.axis2.om.impl.llom.OMSerializerUtil;
import org.apache.axis2.om.impl.llom.serialize.StreamWriterToContentHandlerConverter;
import org.apache.axis2.soap.SOAPFault;
import org.apache.axis2.soap.SOAPFaultText;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.soap.impl.llom.SOAPFaultReasonImpl;
import org.apache.axis2.soap.impl.llom.soap11.SOAP11FaultImpl;
import org.apache.axis2.soap.impl.llom.soap11.SOAP11FaultTextImpl;

public class SOAP11FaultReasonImpl
extends SOAPFaultReasonImpl {
    public SOAP11FaultReasonImpl(SOAPFault parent, OMXMLParserWrapper builder) {
        super(parent, builder);
    }

    public SOAP11FaultReasonImpl(SOAPFault parent) throws SOAPProcessingException {
        super((OMElement)parent, false);
    }

    public void setSOAPText(SOAPFaultText soapFaultText) throws SOAPProcessingException {
        if (!(soapFaultText instanceof SOAP11FaultTextImpl)) {
            throw new SOAPProcessingException("Expecting SOAP 1.1 implementation of SOAP Fault Text. But received some other implementation");
        }
        super.setSOAPText(soapFaultText);
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAP11FaultImpl)) {
            throw new SOAPProcessingException("Expecting SOAP 1.1 implementation of SOAP Fault as the parent. But received some other implementation");
        }
    }

    protected void serialize(OMOutputImpl omOutput, boolean cache) throws XMLStreamException {
        short builderType = 1;
        if (this.builder != null) {
            builderType = this.builder.getBuilderType();
        }
        if (builderType == 0 && this.builder.getRegisteredContentHandler() == null) {
            this.builder.registerExternalContentHandler(new StreamWriterToContentHandlerConverter(omOutput));
        }
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        if (this.getNamespace() != null) {
            String prefix = this.getNamespace().getPrefix();
            String nameSpaceName = this.getNamespace().getName();
            writer.writeStartElement(prefix, "faultstring", nameSpaceName);
        } else {
            writer.writeStartElement("faultstring");
        }
        OMSerializerUtil.serializeAttributes(this, omOutput);
        OMSerializerUtil.serializeNamespaces(this, omOutput);
        String text = this.getSOAPText().getText();
        writer.writeCharacters(text);
        writer.writeEndElement();
    }
}

