/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport;

import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMOutputFormat;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.http.HTTPTransportUtils;

public abstract class AbstractTransportSender
extends AbstractHandler
implements TransportSender {
    public static final QName NAME = new QName("http://ws.apache.org/axis2/", "TransportSender");

    public AbstractTransportSender() {
        this.init(new HandlerDescription(NAME));
    }

    public abstract void finalizeSendWithOutputStreamFromIncomingConnection(MessageContext var1, OutputStream var2) throws AxisFault;

    public abstract void finalizeSendWithToAddress(MessageContext var1, OutputStream var2) throws AxisFault;

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        EndpointReference epr = null;
        if (msgContext.getTo() != null && !"http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(msgContext.getTo().getAddress()) && !"http://www.w3.org/2005/08/addressing/anonymous".equals(msgContext.getTo().getAddress())) {
            epr = msgContext.getTo();
        }
        if (epr != null) {
            OutputStream out = this.openTheConnection(epr, msgContext);
            OutputStream newOut = this.startSendWithToAddress(msgContext, out);
            if (newOut != null) {
                out = newOut;
            }
            this.writeMessage(msgContext, out);
            this.finalizeSendWithToAddress(msgContext, out);
        } else {
            OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
            if (out != null) {
                this.startSendWithOutputStreamFromIncomingConnection(msgContext, out);
                this.writeMessage(msgContext, out);
                this.finalizeSendWithOutputStreamFromIncomingConnection(msgContext, out);
            } else {
                throw new AxisFault("Both the TO and Property MessageContext.TRANSPORT_WRITER is Null, No where to send");
            }
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("CONTENT_WRITTEN", "true");
        }
    }

    protected abstract OutputStream openTheConnection(EndpointReference var1, MessageContext var2) throws AxisFault;

    public abstract OutputStream startSendWithOutputStreamFromIncomingConnection(MessageContext var1, OutputStream var2) throws AxisFault;

    public abstract OutputStream startSendWithToAddress(MessageContext var1, OutputStream var2) throws AxisFault;

    public void writeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        SOAPEnvelope envelope = msgContext.getEnvelope();
        OMElement outputMessage = envelope;
        if (envelope != null && msgContext.isDoingREST()) {
            outputMessage = envelope.getBody().getFirstElement();
        }
        if (outputMessage != null) {
            try {
                OMOutputFormat format = new OMOutputFormat();
                String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                format.setDoOptimize(msgContext.isDoingMTOM());
                format.setCharSetEncoding(charSetEnc);
                outputMessage.serializeAndConsume(out, format);
                out.flush();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            throw new AxisFault(Messages.getMessage("outMessageNull"));
        }
    }
}

