/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.attachments.MIMEHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.impl.llom.builder.StAXBuilder;
import org.apache.axis2.om.impl.llom.builder.StAXOMBuilder;
import org.apache.axis2.om.impl.llom.mtom.MTOMStAXSOAPModelBuilder;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.impl.llom.builder.StAXSOAPModelBuilder;
import org.apache.axis2.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.transport.http.HTTPConstants;

public class TransportUtils {
    private static final int BOM_SIZE = 4;

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext, String soapNamespaceURI) throws AxisFault {
        InputStream inStream = (InputStream)msgContext.getProperty("TRANSPORT_IN");
        msgContext.setProperty("TRANSPORT_IN", null);
        if (inStream == null) {
            throw new AxisFault(Messages.getMessage("inputstreamNull"));
        }
        return TransportUtils.createSOAPMessage(msgContext, inStream, soapNamespaceURI);
    }

    private static SOAPEnvelope createSOAPMessage(MessageContext msgContext, InputStream inStream, String soapNamespaceURI) throws AxisFault {
        try {
            Object contentType = null;
            OperationContext opContext = msgContext.getOperationContext();
            if (opContext == null) {
                throw new AxisFault(Messages.getMessage("cannotBeNullOperationContext"));
            }
            contentType = opContext.getProperty("MTOM_RECEIVED");
            StAXBuilder builder = null;
            SOAPEnvelope envelope = null;
            String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEnc == null) {
                charSetEnc = (String)opContext.getProperty("CHARACTER_SET_ENCODING");
            }
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            if (contentType != null) {
                msgContext.setDoingMTOM(true);
                builder = TransportUtils.selectBuilderForMIME(msgContext, inStream, (String)contentType);
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            } else if (msgContext.isDoingREST()) {
                XMLStreamReader xmlreader = XMLInputFactory.newInstance().createXMLStreamReader(inStream, charSetEnc);
                SOAP11Factory soapFactory = new SOAP11Factory();
                builder = new StAXOMBuilder(xmlreader);
                builder.setOmbuilderFactory(soapFactory);
                envelope = soapFactory.getDefaultEnvelope();
                envelope.getBody().addChild(builder.getDocumentElement());
            } else {
                XMLStreamReader xmlreader = XMLInputFactory.newInstance().createXMLStreamReader(inStream, charSetEnc);
                builder = new StAXSOAPModelBuilder(xmlreader, soapNamespaceURI);
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            }
            return envelope;
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    public static String getCharSetEncoding(String contentType) {
        int index = contentType.indexOf(HTTPConstants.CHAR_SET_ENCODING);
        if (index == -1) {
            return "UTF-8";
        }
        int indexOfEq = contentType.indexOf("=", index);
        int indexOfSemiColon = contentType.indexOf(";", indexOfEq);
        String value = indexOfSemiColon > 0 ? contentType.substring(indexOfEq + 1, indexOfSemiColon) : contentType.substring(indexOfEq + 1, contentType.length()).trim();
        if ("null".equalsIgnoreCase(value = value.replaceAll("\"", ""))) {
            return null;
        }
        return value.trim();
    }

    public static StAXBuilder selectBuilderForMIME(MessageContext msgContext, InputStream inStream, String contentTypeString) throws OMException, XMLStreamException, FactoryConfigurationError, UnsupportedEncodingException {
        XMLStreamReader streamReader;
        MIMEHelper mimeHelper;
        String charSetEncoding;
        StAXSOAPModelBuilder builder = null;
        Parameter parameter_cache_attachment = msgContext.getParameter("cacheAttachments");
        boolean fileCacheForAttachments = parameter_cache_attachment == null ? false : "true".equals(parameter_cache_attachment.getValue());
        String attachmentRepoDir = null;
        String attachmentSizeThreshold = null;
        if (fileCacheForAttachments) {
            Parameter parameter = msgContext.getParameter("attachmentDIR");
            attachmentRepoDir = parameter == null ? "" : parameter.getValue().toString();
            parameter = msgContext.getParameter("sizeThreshold");
            String string = attachmentSizeThreshold = parameter == null ? "" : parameter.getValue().toString();
        }
        if ((charSetEncoding = TransportUtils.getCharSetEncoding((mimeHelper = new MIMEHelper(inStream, contentTypeString, fileCacheForAttachments, attachmentRepoDir, attachmentSizeThreshold)).getSOAPPartContentType())) == null || "null".equalsIgnoreCase(charSetEncoding)) {
            charSetEncoding = "UTF-8";
        }
        try {
            streamReader = XMLInputFactory.newInstance().createXMLStreamReader(TransportUtils.getReader(mimeHelper.getSOAPPartInputStream(), charSetEncoding));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
        msgContext.setProperty("Attachments", mimeHelper);
        if (mimeHelper.getAttachmentSpecType().equals("application/xop+xml")) {
            builder = new MTOMStAXSOAPModelBuilder(streamReader, mimeHelper, null);
        } else if (mimeHelper.getAttachmentSpecType().equals("text/xml")) {
            builder = new StAXSOAPModelBuilder(streamReader, "http://schemas.xmlsoap.org/soap/envelope/");
        }
        return builder;
    }

    private static Reader getReader(InputStream is, String charSetEncoding) throws IOException {
        int unread;
        String encoding;
        PushbackInputStream is2 = new PushbackInputStream(is, 4);
        byte[] bom = new byte[4];
        int n = is2.read(bom, 0, bom.length);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            encoding = "UTF-8";
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            encoding = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            encoding = "UTF-16LE";
            unread = n - 2;
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            encoding = "UTF-32BE";
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            encoding = "UTF-32LE";
            unread = n - 4;
        } else {
            encoding = charSetEncoding;
            unread = n;
        }
        if (unread > 0) {
            is2.unread(bom, n - unread, unread);
        }
        return new BufferedReader(new InputStreamReader((InputStream)is2, encoding));
    }
}

