/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;

public class AxisServlet
extends HttpServlet {
    private static final long serialVersionUID = -2085869393709833372L;
    private static final String CONFIGURATION_CONTEXT = "CONFIGURATION_CONTEXT";
    public static final String SESSION_ID = "SessionId";
    private ConfigurationContext configContext;
    private AxisConfiguration axisConfiguration;
    private ListingAgent lister;

    private MessageContext createAndSetInitialParamsToMsgCtxt(Object sessionContext, MessageContext msgContext, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) throws AxisFault {
        msgContext = new MessageContext();
        msgContext.setConfigurationContext(this.configContext);
        msgContext.setSessionContext((SessionContext)sessionContext);
        msgContext.setTransportIn(this.axisConfiguration.getTransportIn(new QName("http")));
        msgContext.setTransportOut(this.axisConfiguration.getTransportOut(new QName("http")));
        msgContext.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(httpServletResponse));
        msgContext.setProperty("TRANSPORT_HEADERS", this.getTransportHeaders(httpServletRequest));
        msgContext.setProperty(SESSION_ID, httpServletRequest.getSession().getId());
        return msgContext;
    }

    public void destroy() {
        super.destroy();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        MessageContext msgContext = null;
        ServletOutputStream out = null;
        try {
            Object sessionContext = this.getSessionContext(httpServletRequest);
            HashMap map = this.getHTTPParameters(httpServletRequest);
            msgContext = this.createAndSetInitialParamsToMsgCtxt(sessionContext, msgContext, httpServletResponse, httpServletRequest);
            msgContext.setDoingREST(true);
            msgContext.setServerSide(true);
            out = httpServletResponse.getOutputStream();
            boolean processed = HTTPTransportUtils.processHTTPGetRequest(msgContext, (InputStream)httpServletRequest.getInputStream(), (OutputStream)out, httpServletRequest.getContentType(), httpServletRequest.getHeader("SOAPAction"), httpServletRequest.getRequestURL().toString(), this.configContext, map);
            if (!processed) {
                this.lister.handle(httpServletRequest, httpServletResponse, (OutputStream)out);
            }
        }
        catch (AxisFault e) {
            if (msgContext != null) {
                this.handleFault(msgContext, (OutputStream)out, e);
            }
            throw new ServletException((Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        MessageContext msgContext = null;
        ServletOutputStream out = null;
        try {
            Object sessionContext = this.getSessionContext(req);
            msgContext = this.createAndSetInitialParamsToMsgCtxt(sessionContext, msgContext, res, req);
            msgContext.setProperty("servletContext", sessionContext);
            out = res.getOutputStream();
            HTTPTransportUtils.processHTTPPostRequest(msgContext, (InputStream)req.getInputStream(), (OutputStream)out, req.getContentType(), req.getHeader("SOAPAction"), req.getRequestURL().toString());
            Object contextWritten = msgContext.getOperationContext().getProperty("CONTENT_WRITTEN");
            res.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
            if (contextWritten == null || !"true".equals(contextWritten)) {
                res.setStatus(202);
            }
        }
        catch (AxisFault e) {
            if (msgContext != null) {
                res.setStatus(500);
                this.handleFault(msgContext, (OutputStream)out, e);
            }
            throw new ServletException((Throwable)e);
        }
    }

    private void handleFault(MessageContext msgContext, OutputStream out, AxisFault e) throws AxisFault {
        msgContext.setProperty("TRANSPORT_OUT", out);
        AxisEngine engine = new AxisEngine(this.configContext);
        MessageContext faultContext = engine.createFaultMessageContext(msgContext, e);
        engine.sendFault(faultContext);
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.configContext = this.initConfigContext(config);
            this.lister = new ListingAgent(this.configContext);
            this.axisConfiguration = this.configContext.getAxisConfiguration();
            config.getServletContext().setAttribute(CONFIGURATION_CONTEXT, (Object)this.configContext);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        try {
            ServletContext context = config.getServletContext();
            String repoDir = context.getRealPath("/WEB-INF");
            ConfigurationContextFactory erfac = new ConfigurationContextFactory();
            ConfigurationContext configContext = erfac.createConfigurationContextFromFileSystem(repoDir);
            configContext.setProperty("ContainerManaged", "true");
            configContext.setRootDir(new File(context.getRealPath("/WEB-INF")));
            return configContext;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private HashMap getHTTPParameters(HttpServletRequest httpServletRequest) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enu = httpServletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = httpServletRequest.getParameter(name);
            map.put(name, value);
        }
        return map;
    }

    private Object getSessionContext(HttpServletRequest httpServletRequest) {
        Object sessionContext = httpServletRequest.getSession(true).getAttribute("SessionContext");
        if (sessionContext == null) {
            sessionContext = new SessionContext(null);
            httpServletRequest.getSession().setAttribute("SessionContext", sessionContext);
        }
        return sessionContext;
    }

    private Map getTransportHeaders(HttpServletRequest req) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = req.getHeader(key);
            headerMap.put(key, value);
        }
        return headerMap;
    }
}

