/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMOutputFormat;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.RESTSender;
import org.apache.axis2.transport.http.SOAPOverHTTPSender;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsHTTPTransportSender
extends AbstractHandler
implements TransportSender {
    private static final long serialVersionUID = 7929963795196215199L;
    protected static final String PROXY_HOST_NAME = "proxy_host";
    protected static final String PROXY_PORT = "proxy_port";
    public static final String HTTP_METHOD = "HTTP_METHOD";
    int soTimeout = 60000;
    protected TransportOutDescription proxyOutSetting = null;
    protected Log log = LogFactory.getLog((String)this.getClass().getName());
    protected String httpVersion = "HTTP/1.1";
    private boolean chunked = false;
    int connectionTimeout = 60000;

    public void cleanUp(MessageContext msgContext) throws AxisFault {
        HttpMethod httpMethod = (HttpMethod)msgContext.getProperty(HTTP_METHOD);
        if (httpMethod != null) {
            httpMethod.releaseConnection();
        }
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
        Parameter version = transportOut.getParameter("PROTOCOL");
        if (version != null) {
            if ("HTTP/1.1".equals(version.getValue())) {
                this.httpVersion = "HTTP/1.1";
                Parameter transferEncoding = transportOut.getParameter(HTTPConstants.HEADER_TRANSFER_ENCODING);
                if (transferEncoding != null && HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equals(transferEncoding.getValue())) {
                    this.chunked = true;
                }
            } else if ("HTTP/1.0".equals(version.getValue())) {
                this.httpVersion = "HTTP/1.0";
            } else {
                throw new AxisFault("Parameter PROTOCOL Can have values only HTTP/1.0 or HTTP/1.1");
            }
        }
        try {
            Parameter tempSoTimeoutParam = transportOut.getParameter("SO_TIMEOUT");
            Parameter tempConnTimeoutParam = transportOut.getParameter("CONNECTION_TIMEOUT");
            if (tempSoTimeoutParam != null) {
                this.soTimeout = Integer.parseInt((String)tempSoTimeoutParam.getValue());
            }
            if (tempConnTimeoutParam != null) {
                this.connectionTimeout = Integer.parseInt((String)tempConnTimeoutParam.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            this.log.error((Object)"Invalid timeout value format: not a number", (Throwable)nfe);
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            OMOutputFormat format = new OMOutputFormat();
            String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEnc != null) {
                format.setCharSetEncoding(charSetEnc);
            } else {
                OperationContext opctx = msgContext.getOperationContext();
                if (opctx != null) {
                    charSetEnc = (String)opctx.getProperty("CHARACTER_SET_ENCODING");
                }
            }
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
            msgContext.setDoingREST(HTTPTransportUtils.isDoingREST(msgContext));
            format.setSOAP11(msgContext.isSOAP11());
            format.setDoOptimize(msgContext.isDoingMTOM());
            format.setCharSetEncoding(charSetEnc);
            EndpointReference epr = null;
            String transportURL = (String)msgContext.getProperty("TransportURL");
            if (transportURL != null) {
                epr = new EndpointReference(transportURL);
            } else if (msgContext.getTo() != null && !"http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(msgContext.getTo().getAddress()) && !"http://www.w3.org/2005/08/addressing/anonymous".equals(msgContext.getTo().getAddress())) {
                epr = msgContext.getTo();
            }
            OMElement dataOut = msgContext.isDoingREST() ? msgContext.getEnvelope().getBody().getFirstElement() : msgContext.getEnvelope();
            if (epr != null) {
                this.writeMessageWithCommons(msgContext, epr, dataOut, format);
            } else {
                OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
                if (msgContext.isServerSide()) {
                    OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
                    if (transportInfo != null) {
                        boolean soap11 = msgContext.isSOAP11();
                        format.setSOAP11(soap11);
                        String contentType = format.getContentType();
                        String encoding = contentType + "; charset=" + format.getCharSetEncoding();
                        transportInfo.setContentType(encoding);
                    } else {
                        throw new AxisFault("OutTransportInfo has not been set");
                    }
                }
                format.setDoOptimize(msgContext.isDoingMTOM());
                dataOut.serializeAndConsume(out, format);
            }
            if (msgContext.getOperationContext() != null) {
                msgContext.getOperationContext().setProperty("CONTENT_WRITTEN", "true");
            }
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw new AxisFault(e);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public void writeMessageWithCommons(MessageContext msgContext, EndpointReference toURL, OMElement dataout, OMOutputFormat format) throws AxisFault {
        try {
            URL url = new URL(toURL.getAddress());
            String soapActionString = msgContext.getSoapAction();
            if (soapActionString == null || soapActionString.length() == 0) {
                soapActionString = msgContext.getWSAAction();
            }
            if (soapActionString == null) {
                soapActionString = "";
            }
            AbstractHTTPSender sender = !msgContext.isDoingREST() ? new SOAPOverHTTPSender() : new RESTSender();
            if (msgContext.getProperty("__CHUNKED__") != null) {
                this.chunked = "true".equals(msgContext.getProperty("__CHUNKED__"));
            }
            sender.setChunked(this.chunked);
            sender.setFormat(format);
            sender.send(msgContext, dataout, url, soapActionString);
        }
        catch (MalformedURLException e) {
            throw new AxisFault(e);
        }
        catch (HttpException e) {
            throw new AxisFault(e);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public void writeMessageWithToOutPutStream(MessageContext msgContext, OutputStream out) {
    }
}

