/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.i18n.Messages;

public class HTTPTransportReceiver {
    private static final int BEFORE_SEPARATOR = 3;
    private static final int AFTER_SEPARATOR = 4;
    private int lastRead = -1;
    int index = 0;
    private byte[] buf = new byte[1024];
    int length = 0;
    private boolean done = false;

    public HashMap parseTheHeaders(InputStream in, boolean serverSide) throws AxisFault {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            StringBuffer str = new StringBuffer();
            int state = 3;
            String key = null;
            String value = null;
            this.length = this.readLine(in, this.buf);
            if (serverSide) {
                if (this.buf[0] == 80 && this.buf[1] == 79 && this.buf[2] == 83 && this.buf[3] == 84) {
                    map.put("HTTP_REQ_TYPE", "POST");
                    this.index = 5;
                } else if (this.buf[0] == 71 && this.buf[1] == 69 && this.buf[2] == 84) {
                    map.put("HTTP_REQ_TYPE", "GET");
                    this.index = 4;
                } else {
                    throw new AxisFault("Unsupported HTTP request type: Only GET and POST is supported");
                }
                value = this.readFirstLineArg(' ');
                map.put("REQUEST_URI", value);
                value = this.readFirstLineArg('\n');
                map.put("PROTOCOL", value);
            } else {
                this.index = 0;
                value = this.readFirstLineArg(' ');
                if (value != null && value.indexOf("HTTP") >= 0) {
                    map.put("PROTOCOL", value);
                    value = this.readFirstLineArg(' ');
                    map.put("RESPONSE_CODE", value);
                } else {
                    map.put("RESPONSE_CODE", value);
                }
                value = this.readFirstLineArg('\n');
                map.put("RESPONSE_WORD", value);
            }
            state = 3;
            while (!this.done) {
                this.length = this.readLine(in, this.buf);
                if (this.length <= 0) {
                    throw new AxisFault(Messages.getMessage("preatureEOS"));
                }
                block7: for (int i = 0; i < this.length; ++i) {
                    switch (state) {
                        case 3: {
                            if (this.buf[i] == 58) {
                                key = str.toString();
                                str = new StringBuffer();
                                state = 4;
                                if (this.buf[i + 1] != 32) continue block7;
                                ++i;
                                continue block7;
                            }
                            str.append((char)this.buf[i]);
                            continue block7;
                        }
                        case 4: {
                            if (this.buf[i] == 10) {
                                value = str.toString();
                                map.put(key, value);
                                str = new StringBuffer();
                                i = this.length;
                                continue block7;
                            }
                            str.append((char)this.buf[i]);
                            continue block7;
                        }
                        default: {
                            throw new AxisFault("Error Occured Unknown state " + state);
                        }
                    }
                }
                state = 3;
            }
        }
        catch (IOException e) {
            throw new AxisFault(e.getMessage(), e);
        }
        return map;
    }

    private String readFirstLineArg(char terminal) throws AxisFault {
        StringBuffer str = new StringBuffer();
        try {
            while (this.buf[this.index] != terminal && this.index < this.length) {
                str.append((char)this.buf[this.index]);
                ++this.index;
            }
            ++this.index;
            return str.toString();
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), e);
        }
    }

    protected int readLine(InputStream is, byte[] b) throws IOException {
        int count = 0;
        int c = this.lastRead == -1 ? is.read() : this.lastRead;
        int off = 0;
        while (c != -1) {
            if (c != 10 && c != 13) {
                b[off++] = (byte)c;
                ++count;
                c = is.read();
                continue;
            }
            if (10 == c) {
                c = is.read();
                if (c == 13) {
                    c = is.read();
                }
                if (c == 32 || c == 9) continue;
                if (c == 10) {
                    this.done = true;
                }
                this.lastRead = c;
                b[off++] = 10;
                ++count;
                break;
            }
            c = is.read();
        }
        if (c == -1) {
            throw new AxisFault("Every line should ends with the \\n, unexpected End of stream");
        }
        return count > 0 ? count : -1;
    }

    public static Map getGetRequestParameters(String requestURI) {
        HashMap<String, String> map = new HashMap<String, String>();
        char[] chars = requestURI.toCharArray();
        int NOT_BEGUN = 1500;
        int INSIDE_NAME = 1501;
        int INSIDE_VALUE = 1502;
        int state = 1500;
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        for (int index = 0; index < chars.length; ++index) {
            if (state == 1500) {
                if (chars[index] != '?') continue;
                state = 1501;
                continue;
            }
            if (state == 1501) {
                if (chars[index] == '=') {
                    state = 1502;
                    continue;
                }
                name.append(chars[index]);
                continue;
            }
            if (state != 1502) continue;
            if (chars[index] == ',') {
                state = 1501;
                map.put(name.toString(), value.toString());
                name.delete(0, name.length());
                value.delete(0, value.length());
                continue;
            }
            value.append(chars[index]);
        }
        if (name.length() + value.length() > 0) {
            map.put(name.toString(), value.toString());
        }
        return map;
    }

    public static String getServicesHTML(ConfigurationContext configurationContext) {
        String temp = "";
        HashMap services = configurationContext.getAxisConfiguration().getServices();
        Hashtable erroneousServices = configurationContext.getAxisConfiguration().getFaultyServices();
        boolean status = false;
        if (services != null && !services.isEmpty()) {
            status = true;
            Collection serviceCollection = services.values();
            temp = temp + "<h2>Deployed services</h2>";
            Iterator it = serviceCollection.iterator();
            while (it.hasNext()) {
                AxisService axisService = (AxisService)it.next();
                HashMap operations = axisService.getOperations();
                Collection operationsList = operations.values();
                temp = temp + "<h3><a href=\"" + axisService.getName() + "?wsdl\">" + axisService.getName() + "</a></h3>";
                if (operationsList.size() > 0) {
                    temp = temp + "Available operations <ul>";
                    Iterator iterator1 = operationsList.iterator();
                    while (iterator1.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)iterator1.next();
                        temp = temp + "<li>" + axisOperation.getName().getLocalPart() + "</li>";
                    }
                    temp = temp + "</ul>";
                    continue;
                }
                temp = temp + "No operations specified for this service";
            }
        }
        if (erroneousServices != null && !erroneousServices.isEmpty()) {
            temp = temp + "<hr><h2><font color=\"blue\">Faulty Services</font></h2>";
            status = true;
            Enumeration faultyservices = erroneousServices.keys();
            while (faultyservices.hasMoreElements()) {
                String faultyserviceName = (String)faultyservices.nextElement();
                temp = temp + "<h3><font color=\"blue\">" + faultyserviceName + "</font></h3>";
            }
        }
        if (!status) {
            temp = "<h2>There are no services deployed</h2>";
        }
        temp = "<html><head><title>Axis2: Services</title></head><body>" + temp + "</body></html>";
        return temp;
    }
}

