/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.OMNamespace;
import org.apache.axis2.om.OMNode;
import org.apache.axis2.om.OMText;
import org.apache.axis2.om.impl.llom.OMNamespaceImpl;
import org.apache.axis2.om.impl.llom.builder.StAXBuilder;
import org.apache.axis2.om.impl.llom.builder.StAXOMBuilder;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.soap.impl.llom.builder.StAXSOAPModelBuilder;
import org.apache.axis2.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.Utils;

public class HTTPTransportUtils {
    public static boolean checkEnvelopeForOptimise(SOAPEnvelope envelope) {
        return HTTPTransportUtils.isOptimised(envelope);
    }

    public static SOAPEnvelope createEnvelopeFromGetRequest(String requestUrl, Map map) {
        String[] values = Utils.parseRequestURLForServiceAndOperation(requestUrl);
        if (values[1] != null && values[0] != null) {
            String operation = values[1];
            SOAP11Factory soapFactory = new SOAP11Factory();
            SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
            OMNamespace omNs = soapFactory.createOMNamespace(values[0], "services");
            OMNamespaceImpl defualtNs = new OMNamespaceImpl("", null);
            OMElement opElement = soapFactory.createOMElement(operation, omNs);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                String value = (String)map.get(name);
                OMElement omEle = soapFactory.createOMElement(name, defualtNs);
                omEle.setText(value);
                opElement.addChild(omEle);
            }
            envelope.getBody().addChild(opElement);
            return envelope;
        }
        return null;
    }

    public static boolean doWriteMTOM(MessageContext msgContext) {
        boolean forceMIME;
        boolean enableMTOM = false;
        if (msgContext.getParameter("enableMTOM") != null) {
            enableMTOM = "true".equals(msgContext.getParameter("enableMTOM").getValue());
        }
        if (msgContext.getProperty("enableMTOM") != null) {
            enableMTOM = "true".equals(msgContext.getProperty("enableMTOM"));
        }
        if (forceMIME = "true".equals(msgContext.getProperty("ForceMimeBoundary"))) {
            return true;
        }
        if (!enableMTOM) {
            return false;
        }
        boolean envelopeContainsOptimise = HTTPTransportUtils.checkEnvelopeForOptimise(msgContext.getEnvelope());
        return enableMTOM && envelopeContainsOptimise;
    }

    public static boolean processHTTPGetRequest(MessageContext msgContext, InputStream in, OutputStream out, String contentType, String soapAction, String requestURI, ConfigurationContext configurationContext, Map requestParameters) throws AxisFault {
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        msgContext.setWSAAction(soapAction);
        msgContext.setSoapAction(soapAction);
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("TRANSPORT_OUT", out);
        msgContext.setServerSide(true);
        SOAPEnvelope envelope = HTTPTransportUtils.createEnvelopeFromGetRequest(requestURI, requestParameters);
        if (envelope == null) {
            return false;
        }
        msgContext.setDoingREST(true);
        msgContext.setEnvelope(envelope);
        AxisEngine engine = new AxisEngine(configurationContext);
        engine.receive(msgContext);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processHTTPPostRequest(MessageContext msgContext, InputStream in, OutputStream out, String contentType, String soapActionHeader, String requestURI) throws AxisFault {
        boolean soap11 = false;
        try {
            try {
                String charsetEncoding;
                if (soapActionHeader != null && soapActionHeader.startsWith("\"") && soapActionHeader.endsWith("\"")) {
                    soapActionHeader = soapActionHeader.substring(1, soapActionHeader.length() - 1);
                }
                msgContext.setWSAAction(soapActionHeader);
                msgContext.setSoapAction(soapActionHeader);
                msgContext.setTo(new EndpointReference(requestURI));
                msgContext.setProperty("TRANSPORT_OUT", out);
                msgContext.setServerSide(true);
                SOAPEnvelope envelope = null;
                StAXBuilder builder = null;
                if (contentType != null) {
                    if (contentType.indexOf("multipart/related") > -1) {
                        builder = TransportUtils.selectBuilderForMIME(msgContext, in, contentType);
                        envelope = (SOAPEnvelope)builder.getDocumentElement();
                    } else {
                        XMLStreamReader xmlreader;
                        if (TransportUtils.getCharSetEncoding(contentType) == null) {
                            xmlreader = XMLInputFactory.newInstance().createXMLStreamReader(in, "UTF-8");
                            msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                        } else {
                            String charSetEnc = TransportUtils.getCharSetEncoding(contentType);
                            xmlreader = XMLInputFactory.newInstance().createXMLStreamReader(in, charSetEnc);
                            msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
                        }
                        if (contentType.indexOf("application/soap+xml") > -1) {
                            soap11 = false;
                            builder = new StAXSOAPModelBuilder(xmlreader, "http://www.w3.org/2003/05/soap-envelope");
                            envelope = (SOAPEnvelope)builder.getDocumentElement();
                        } else if (contentType.indexOf("text/xml") > -1) {
                            soap11 = true;
                            Parameter enable = msgContext.getParameter("enableREST");
                            if ((soapActionHeader == null || soapActionHeader.length() == 0) && enable != null) {
                                if ("true".equals(enable.getValue())) {
                                    msgContext.setDoingREST(true);
                                    SOAP11Factory soapFactory = new SOAP11Factory();
                                    builder = new StAXOMBuilder(xmlreader);
                                    builder.setOmbuilderFactory(soapFactory);
                                    envelope = soapFactory.getDefaultEnvelope();
                                    envelope.getBody().addChild(builder.getDocumentElement());
                                }
                            } else {
                                builder = new StAXSOAPModelBuilder(xmlreader, "http://schemas.xmlsoap.org/soap/envelope/");
                                envelope = (SOAPEnvelope)builder.getDocumentElement();
                            }
                        }
                    }
                }
                if ((charsetEncoding = builder.getDocument().getCharsetEncoding()) != null && !"".equals(charsetEncoding) && !charsetEncoding.equalsIgnoreCase((String)msgContext.getProperty("CHARACTER_SET_ENCODING"))) {
                    String faultCode;
                    if ("http://www.w3.org/2003/05/soap-envelope".equals(envelope.getNamespace().getName())) {
                        faultCode = "Sender";
                        throw new AxisFault("Character Set Encoding from transport information do not match with character set encoding in the received SOAP message", faultCode);
                    }
                    faultCode = "Client";
                    throw new AxisFault("Character Set Encoding from transport information do not match with character set encoding in the received SOAP message", faultCode);
                }
                msgContext.setEnvelope(envelope);
                AxisEngine engine = new AxisEngine(msgContext.getConfigurationContext());
                if (envelope.getBody().hasFault()) {
                    engine.receiveFault(msgContext);
                }
                engine.receive(msgContext);
            }
            catch (SOAPProcessingException e) {
                throw new AxisFault(e);
            }
            catch (AxisFault e) {
                throw e;
            }
            catch (OMException e) {
                throw new AxisFault(e);
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
            catch (FactoryConfigurationError e) {
                throw new AxisFault(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new AxisFault(e);
            }
            Object var13_18 = null;
            if (msgContext.getEnvelope() != null) return;
            if (soap11) return;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (msgContext.getEnvelope() != null) throw throwable;
            if (soap11) throw throwable;
            msgContext.setEnvelope(new SOAP12Factory().createSOAPEnvelope());
            throw throwable;
        }
        msgContext.setEnvelope(new SOAP12Factory().createSOAPEnvelope());
    }

    public static boolean isDoingREST(MessageContext msgContext) {
        boolean enableREST = false;
        if (msgContext.isDoingREST()) {
            return true;
        }
        Parameter parameter = msgContext.getParameter("enableREST");
        if (parameter != null) {
            enableREST = "true".equals(parameter.getValue());
        } else if (msgContext.getProperty("enableREST") != null) {
            enableREST = "true".equals(msgContext.getProperty("enableREST"));
        }
        msgContext.setDoingREST(enableREST);
        return enableREST;
    }

    private static boolean isOptimised(OMElement element) {
        Iterator childrenIter = element.getChildren();
        boolean isOptimized = false;
        while (childrenIter.hasNext() && !isOptimized) {
            OMNode node = (OMNode)childrenIter.next();
            if (4 == node.getType() && ((OMText)node).isOptimized()) {
                isOptimized = true;
                continue;
            }
            if (1 != node.getType()) continue;
            isOptimized = HTTPTransportUtils.isOptimised((OMElement)node);
        }
        return isOptimized;
    }
}

