/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.SimpleHTTPOutTransportInfo;
import org.apache.axis2.transport.http.server.HttpRequestHandler;
import org.apache.axis2.transport.http.server.SimpleHttpServerConnection;
import org.apache.axis2.transport.http.server.SimpleRequest;
import org.apache.axis2.transport.http.server.SimpleResponse;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPWorker
implements HttpRequestHandler {
    protected Log log = LogFactory.getLog((String)this.getClass().getName());
    private ConfigurationContext configurationContext;
    private Hashtable sessionContextTable = new Hashtable();

    public HTTPWorker(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public boolean processRequest(SimpleHttpServerConnection conn, SimpleRequest request) throws IOException {
        MessageContext msgContext = null;
        SimpleResponse response = new SimpleResponse();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.configurationContext == null) {
                throw new AxisFault(Messages.getMessage("cannotBeNullConfigurationContext"));
            }
            InputStream inStream = request.getBody();
            TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut(new QName("http"));
            String cookieID = request.getCookieID();
            SessionContext sessionContext = this.getSessionContext(cookieID);
            msgContext = new MessageContext();
            msgContext.setConfigurationContext(this.configurationContext);
            msgContext.setSessionContext(sessionContext);
            msgContext.setTransportIn(this.configurationContext.getAxisConfiguration().getTransportIn(new QName("http")));
            msgContext.setTransportOut(transportOut);
            msgContext.setServerSide(true);
            HttpVersion ver = request.getRequestLine().getHttpVersion();
            if (ver == null) {
                throw new AxisFault("HTTP version can not be Null");
            }
            if (!HttpVersion.HTTP_1_0.equals(ver)) {
                if (HttpVersion.HTTP_1_1.equals(ver)) {
                    this.transportOutConfiguration(this.configurationContext, response);
                } else {
                    throw new AxisFault("Unknown supported protocol version " + ver);
                }
            }
            msgContext.setProperty("TRANSPORT_OUT", baos);
            msgContext.setProperty("TRANSPORT_HEADERS", this.getHeaders(request));
            msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
            msgContext.setProperty("OutTransportInfo", new SimpleHTTPOutTransportInfo(response));
            String soapAction = null;
            if (request.getFirstHeader("SOAPAction") != null) {
                soapAction = request.getFirstHeader("SOAPAction").getValue();
            }
            if ("GET".equals(request.getRequestLine().getMethod())) {
                boolean processed;
                AxisService service;
                HashMap services;
                String serviceName;
                String uri = request.getRequestLine().getUri();
                this.log.debug((Object)("HTTP GET:" + uri));
                if (uri.equals("/favicon.ico")) {
                    response.setStatusLine(request.getRequestLine().getHttpVersion(), 301, "Redirect");
                    response.addHeader(new Header("Location", "http://ws.apache.org/favicon.ico"));
                    conn.writeResponse(response);
                    return true;
                }
                if (!uri.startsWith("/axis2/services/")) {
                    response.setStatusLine(request.getRequestLine().getHttpVersion(), 301, "Redirect");
                    response.addHeader(new Header("Location", "/axis2/services/"));
                    conn.writeResponse(response);
                    return true;
                }
                if (uri.endsWith("?wsdl")) {
                    serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 5);
                    services = this.configurationContext.getAxisConfiguration().getServices();
                    service = (AxisService)services.get(serviceName);
                    if (service != null) {
                        response.addHeader(new Header("Content-Type", "text/xml"));
                        String url = conn.getURL(uri.substring(1, uri.length() - 5));
                        service.printWSDL(baos, url);
                        byte[] buf = baos.toByteArray();
                        response.setBody(new ByteArrayInputStream(buf));
                        conn.writeResponse(response);
                        return true;
                    }
                }
                if (uri.endsWith("?xsd")) {
                    serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 4);
                    services = this.configurationContext.getAxisConfiguration().getServices();
                    service = (AxisService)services.get(serviceName);
                    if (service != null) {
                        response.addHeader(new Header("Content-Type", "text/xml"));
                        service.printSchema(baos);
                        byte[] buf = baos.toByteArray();
                        response.setBody(new ByteArrayInputStream(buf));
                        conn.writeResponse(response);
                        return true;
                    }
                }
                if (!(processed = HTTPTransportUtils.processHTTPGetRequest(msgContext, inStream, baos, request.getContentType(), soapAction, request.getRequestLine().getUri(), this.configurationContext, HTTPTransportReceiver.getGetRequestParameters(request.getRequestLine().getUri())))) {
                    response.setStatusLine(request.getRequestLine().getHttpVersion(), 200, "OK");
                    response.addHeader(new Header("Content-Type", "text/html"));
                    response.setBodyString(HTTPTransportReceiver.getServicesHTML(this.configurationContext));
                    this.setResponseHeaders(conn, request, response, 0L, msgContext);
                    conn.writeResponse(response);
                    return true;
                }
            } else {
                int size;
                ByteArrayOutputStream baosIn = new ByteArrayOutputStream();
                byte[] bytes = new byte[8192];
                while ((size = inStream.read(bytes)) > 0) {
                    baosIn.write(bytes, 0, size);
                }
                inStream = new ByteArrayInputStream(baosIn.toByteArray());
                HTTPTransportUtils.processHTTPPostRequest(msgContext, inStream, baos, request.getContentType(), soapAction, request.getRequestLine().getUri());
            }
            OperationContext operationContext = msgContext.getOperationContext();
            Object contextWritten = null;
            if (operationContext != null) {
                contextWritten = operationContext.getProperty("CONTENT_WRITTEN");
            }
            if (contextWritten != null && "true".equals(contextWritten)) {
                response.setStatusLine(request.getRequestLine().getHttpVersion(), 200, "OK");
            } else {
                response.setStatusLine(request.getRequestLine().getHttpVersion(), 202, "OK");
            }
            byte[] buf = baos.toByteArray();
            response.setBody(new ByteArrayInputStream(buf));
            this.setResponseHeaders(conn, request, response, buf.length, msgContext);
            conn.writeResponse(response);
        }
        catch (Throwable e) {
            if (!(e instanceof SocketException)) {
                this.log.debug((Object)e.getMessage(), e);
            }
            try {
                AxisEngine engine = new AxisEngine(this.configurationContext);
                if (msgContext != null) {
                    msgContext.setProperty("TRANSPORT_OUT", baos);
                    MessageContext faultContext = engine.createFaultMessageContext(msgContext, e);
                    response.setStatusLine(request.getRequestLine().getHttpVersion(), 500, "Internal server error");
                    engine.sendFault(faultContext);
                    byte[] buf = baos.toByteArray();
                    response.setBody(new ByteArrayInputStream(buf));
                    this.setResponseHeaders(conn, request, response, buf.length, msgContext);
                    conn.writeResponse(response);
                }
            }
            catch (SocketException e1) {
                this.log.debug((Object)e1.getMessage(), (Throwable)e1);
            }
            catch (Exception e1) {
                this.log.warn((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        return true;
    }

    private void transportOutConfiguration(ConfigurationContext configContext, SimpleResponse response) {
        AxisConfiguration axisConf = configContext.getAxisConfiguration();
        HashMap transportOuts = axisConf.getTransportsOut();
        Iterator values = transportOuts.values().iterator();
        while (values.hasNext()) {
            Parameter transferEncoding;
            TransportOutDescription transportOut = (TransportOutDescription)values.next();
            Parameter version = transportOut.getParameter("PROTOCOL");
            if (version == null || !"HTTP/1.1".equals(version.getValue()) || (transferEncoding = transportOut.getParameter(HTTPConstants.HEADER_TRANSFER_ENCODING)) == null || !HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equals(transferEncoding.getValue())) continue;
            response.setHeader(new Header(HTTPConstants.HEADER_TRANSFER_ENCODING, HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED));
        }
    }

    private Map getHeaders(SimpleRequest request) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Header[] headers = request.getHeaders();
        for (int i = 0; i < headers.length; ++i) {
            headerMap.put(headers[i].getName(), headers[i].getValue());
        }
        return headerMap;
    }

    private void setResponseHeaders(SimpleHttpServerConnection conn, SimpleRequest request, SimpleResponse response, long contentLength, MessageContext msgContext) {
        Object cookieString;
        Header header;
        if (!response.containsHeader("Connection")) {
            Header connheader = request.getFirstHeader("Connection");
            if (connheader != null) {
                if (connheader.getValue().equalsIgnoreCase("keep-alive")) {
                    header = new Header("Connection", "keep-alive");
                    response.addHeader(header);
                    conn.setKeepAlive(true);
                }
                if (connheader.getValue().equalsIgnoreCase("close")) {
                    header = new Header("Connection", "close");
                    response.addHeader(header);
                    conn.setKeepAlive(false);
                }
            } else if (response.getHttpVersion().greaterEquals(HttpVersion.HTTP_1_1)) {
                conn.setKeepAlive(true);
            } else {
                conn.setKeepAlive(false);
            }
        }
        if ((cookieString = msgContext.getProperty("Cookie")) != null) {
            response.addHeader(new Header("Set-Cookie", (String)cookieString));
            response.addHeader(new Header("Set-Cookie2", (String)cookieString));
        }
        if (!response.containsHeader("Transfer-Encoding") && contentLength != 0L) {
            header = new Header("Content-Length", String.valueOf(contentLength));
            response.addHeader(header);
        }
    }

    private synchronized SessionContext getSessionContext(String cookieID) {
        SessionContext sessionContext = null;
        if (cookieID != null && !cookieID.trim().equals("")) {
            sessionContext = (SessionContext)this.sessionContextTable.get(cookieID);
        }
        if (sessionContext == null) {
            String cookieString = UUIDGenerator.getUUID();
            sessionContext = new SessionContext(null);
            sessionContext.setCookieID(cookieString);
            this.sessionContextTable.put(cookieString, sessionContext);
        }
        sessionContext.touch();
        this.cleanupServiceGroupContexts();
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupServiceGroupContexts() {
        Hashtable hashtable = this.sessionContextTable;
        synchronized (hashtable) {
            long currentTime = new Date().getTime();
            Iterator sgCtxtMapKeyIter = this.sessionContextTable.keySet().iterator();
            while (sgCtxtMapKeyIter.hasNext()) {
                String cookieID = (String)sgCtxtMapKeyIter.next();
                SessionContext sessionContext = (SessionContext)this.sessionContextTable.get(cookieID);
                if (currentTime - sessionContext.getLastTouchedTime() <= sessionContext.sessionContextTimeoutInterval) continue;
                sgCtxtMapKeyIter.remove();
            }
        }
    }
}

