/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterImpl;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.http.server.AdminAppException;

public class ListingAgent {
    private static final String LIST_MULTIPLE_SERVICE_JSP_NAME = "listServices.jsp";
    private static final String LIST_SERVICE_GROUP_JSP = "ListServiceGroup.jsp";
    private static final String LIST_SERVICES_JSP_NAME = "listService.jsp";
    private static final String SELECT_SERVICE_JSP_NAME = "SelectService.jsp";
    private static final String REMOVE_SERVICE_JSP_NAME = "RemoveService.jsp";
    private static final String LIST_SINGLE_SERVICE_JSP_NAME = "listSingleService.jsp";
    private static final String LIST_PHASES_JSP_NAME = "viewphases.jsp";
    private static final String LIST_GLOABLLY_ENGAGED_MODULES_JSP_NAME = "globalModules.jsp";
    private static final String LIST_AVAILABLE_MODULES_JSP_NAME = "listModules.jsp";
    private static final String ENGAGING_MODULE_TO_SERVICE_JSP_NAME = "engagingtoaservice.jsp";
    private static final String ENGAGING_MODULE_TO_SERVICE_GROUP_JSP_NAME = "EngageToServiceGroup.jsp";
    private static final String ENGAGING_MODULE_GLOBALLY_JSP_NAME = "engagingglobally.jsp";
    public static final String ADMIN_JSP_NAME = "admin.jsp";
    private static final String VIEW_GLOBAL_HANDLERS_JSP_NAME = "ViewGlobalHandlers.jsp";
    private static final String VIEW_SERVICE_HANDLERS_JSP_NAME = "ViewServiceHandlers.jsp";
    private static final String SERVICE_PARA_EDIT_JSP_NAME = "ServiceParaEdit.jsp";
    private static final String ENGAGE_TO_OPERATION_JSP_NAME = "engagingtoanoperation.jsp";
    private OutputStream out = null;
    private ConfigurationContext configContext;

    public ListingAgent(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    private void adminLogging(HttpServletRequest req, HttpServletResponse res) throws AdminAppException, IOException {
        String username = req.getParameter("userName");
        String password = req.getParameter("password");
        if (username == null || password == null || username.trim().equals("") || password.trim().equals("")) {
            throw new AdminAppException(Messages.getMessage("invaliduser"));
        }
        String adminUserName = (String)this.configContext.getAxisConfiguration().getParameter("userName").getValue();
        String adminPassword = (String)this.configContext.getAxisConfiguration().getParameter("password").getValue();
        if (!username.equals(adminUserName) || !password.equals(adminPassword)) {
            throw new AdminAppException(Messages.getMessage("invaliduser"));
        }
        req.getSession().setAttribute("Logged", (Object)"Yes");
        res.sendRedirect(ADMIN_JSP_NAME);
    }

    private void changeParameters(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getParameter("editServicepara") != null) {
            String serviceName = req.getParameter("axisService");
            AxisService service = this.configContext.getAxisConfiguration().getService(serviceName);
            if (service != null) {
                ArrayList service_para = service.getParameters();
                for (int i = 0; i < service_para.size(); ++i) {
                    Parameter parameter = (Parameter)service_para.get(i);
                    String para = req.getParameter(serviceName + "_" + parameter.getName());
                    service.addParameter(new ParameterImpl(parameter.getName(), para));
                }
                HashMap operation = service.getOperations();
                Collection op_col = operation.values();
                Iterator iterator = op_col.iterator();
                while (iterator.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)iterator.next();
                    String op_name = axisOperation.getName().getLocalPart();
                    ArrayList operation_para = axisOperation.getParameters();
                    for (int i = 0; i < operation_para.size(); ++i) {
                        Parameter parameter = (Parameter)operation_para.get(i);
                        String para = req.getParameter(op_name + "_" + parameter.getName());
                        axisOperation.addParameter(new ParameterImpl(parameter.getName(), para));
                    }
                }
            }
            res.setContentType("text/css");
            PrintWriter out_writer = new PrintWriter(this.out);
            out_writer.println("Parameters  changed Successfully");
            out_writer.flush();
            out_writer.close();
            req.getSession().removeAttribute("service");
            return;
        }
        String service = req.getParameter("axisService");
        if (service != null) {
            req.getSession().setAttribute("service", (Object)this.configContext.getAxisConfiguration().getService(service));
        }
        res.sendRedirect(SERVICE_PARA_EDIT_JSP_NAME);
    }

    private void engageModulesGlobally(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        String moduleName = req.getParameter("modules");
        req.getSession().setAttribute("engagestatus", null);
        if (moduleName != null) {
            try {
                this.configContext.getAxisConfiguration().engageModule(new QName(moduleName));
                req.getSession().setAttribute("engagestatus", (Object)(moduleName + " module engaged globally Successfully"));
            }
            catch (AxisFault axisFault) {
                req.getSession().setAttribute("engagestatus", (Object)axisFault.getMessage());
            }
        }
        req.getSession().setAttribute("modules", null);
        res.sendRedirect(ENGAGING_MODULE_GLOBALLY_JSP_NAME);
    }

    private void engageModulesToOperation(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        String moduleName = req.getParameter("modules");
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("modules", null);
        String serviceName = req.getParameter("axisService");
        if (serviceName != null) {
            req.getSession().setAttribute("service", (Object)serviceName);
        } else {
            serviceName = (String)req.getSession().getAttribute("service");
        }
        req.getSession().setAttribute("operationmap", (Object)this.configContext.getAxisConfiguration().getService(serviceName).getOperations());
        req.getSession().setAttribute("engagestatus", null);
        String operationName = req.getParameter("operation");
        if (serviceName != null && moduleName != null && operationName != null) {
            try {
                AxisOperation od = this.configContext.getAxisConfiguration().getService(serviceName).getOperation(new QName(operationName));
                od.engageModule(this.configContext.getAxisConfiguration().getModule(new QName(moduleName)), this.configContext.getAxisConfiguration());
                req.getSession().setAttribute("engagestatus", (Object)(moduleName + " module engaged to the operation Successfully"));
            }
            catch (AxisFault axisFault) {
                req.getSession().setAttribute("engagestatus", (Object)axisFault.getMessage());
            }
        }
        req.getSession().setAttribute("operation", null);
        res.sendRedirect(ENGAGE_TO_OPERATION_JSP_NAME);
    }

    private void engageModulesToService(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        req.getSession().setAttribute("servicemap", (Object)services);
        String moduleName = req.getParameter("modules");
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("modules", null);
        String serviceName = req.getParameter("service");
        req.getSession().setAttribute("engagestatus", null);
        if (serviceName != null && moduleName != null) {
            try {
                this.configContext.getAxisConfiguration().getService(serviceName).engageModule(this.configContext.getAxisConfiguration().getModule(new QName(moduleName)), this.configContext.getAxisConfiguration());
                req.getSession().setAttribute("engagestatus", (Object)(moduleName + " module engaged to the service Successfully"));
            }
            catch (AxisFault axisFault) {
                req.getSession().setAttribute("engagestatus", (Object)axisFault.getMessage());
            }
        }
        req.getSession().setAttribute("service", null);
        res.sendRedirect(ENGAGING_MODULE_TO_SERVICE_JSP_NAME);
    }

    private void engageModulesToServiceGroup(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        Iterator services = this.configContext.getAxisConfiguration().getServiceGroups();
        req.getSession().setAttribute("serviceGroupmap", (Object)services);
        String moduleName = req.getParameter("modules");
        req.getSession().setAttribute("engagestatus", null);
        req.getSession().setAttribute("modules", null);
        String serviceName = req.getParameter("service");
        req.getSession().setAttribute("engagestatus", null);
        if (serviceName != null && moduleName != null) {
            this.configContext.getAxisConfiguration().getServiceGroup(serviceName).engageModule(this.configContext.getAxisConfiguration().getModule(new QName(moduleName)));
            req.getSession().setAttribute("engagestatus", (Object)(moduleName + " module engaged to the serviceGroup Successfully"));
        }
        req.getSession().setAttribute("service", null);
        res.sendRedirect(ENGAGING_MODULE_TO_SERVICE_GROUP_JSP_NAME);
    }

    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, OutputStream out) throws IOException, Exception {
        this.out = out;
        String filePart = httpServletRequest.getRequestURL().toString();
        if (filePart != null && filePart.endsWith("listService")) {
            this.listAdminServices(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("listModules")) {
            this.listModules(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("globalModules")) {
            this.listGloballyModules(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("listPhases")) {
            this.listPhases(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("engagingglobally")) {
            this.engageModulesGlobally(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("engageToService")) {
            this.engageModulesToService(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("engageToServiceGroup")) {
            this.engageModulesToServiceGroup(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("adminlogin")) {
            this.adminLogging(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("viewGlobalHandlers")) {
            this.viewGlobalHandlers(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("selectService")) {
            this.selectService(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("viewServiceHandlers")) {
            this.viewServiceHandlers(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("listoperation")) {
            this.lsitServiceformodules(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("listOperations")) {
            this.engageModulesToOperation(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("removeService")) {
            this.removeService(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("selectServiceParaEdit")) {
            this.lsitServiceforParameterChanged(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("editServicepara")) {
            this.changeParameters(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("listServciceGroups")) {
            this.listServiceGroups(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("listContexts")) {
            this.listContexts(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("logout")) {
            this.logout(httpServletRequest, httpServletResponse);
            return;
        }
        if (filePart != null && filePart.endsWith("listServices")) {
            this.listServices(httpServletRequest, httpServletResponse);
        } else {
            this.listService(httpServletRequest, httpServletResponse, filePart);
        }
    }

    private void listAdminServices(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        req.getSession().setAttribute("servicemap", (Object)services);
        req.getSession().setAttribute("errprservicemap", (Object)this.configContext.getAxisConfiguration().getFaultyServices());
        res.sendRedirect(LIST_SERVICES_JSP_NAME);
    }

    private void listContexts(HttpServletRequest req, HttpServletResponse res) throws IOException {
        req.getSession().setAttribute("config_context", (Object)this.configContext);
        res.sendRedirect("ViewContexts.jsp");
    }

    private void listGloballyModules(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Collection modules = this.configContext.getAxisConfiguration().getEngagedModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        res.sendRedirect(LIST_GLOABLLY_ENGAGED_MODULES_JSP_NAME);
    }

    private void listModules(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap modules = this.configContext.getAxisConfiguration().getModules();
        req.getSession().setAttribute("modulemap", (Object)modules);
        req.getSession().setAttribute("errormodulesmap", (Object)this.configContext.getAxisConfiguration().getFaultyModules());
        res.sendRedirect(LIST_AVAILABLE_MODULES_JSP_NAME);
    }

    private void listPhases(HttpServletRequest req, HttpServletResponse res) throws IOException {
        ArrayList<ArrayList> phaselist = new ArrayList<ArrayList>();
        PhasesInfo info = this.configContext.getAxisConfiguration().getPhasesInfo();
        phaselist.add(info.getINPhases());
        phaselist.add(info.getIN_FaultPhases());
        phaselist.add(info.getOUTPhases());
        phaselist.add(info.getOUT_FaultPhases());
        phaselist.add(info.getOperationInPhases());
        phaselist.add(info.getOperationInFaultPhases());
        phaselist.add(info.getOperationOutPhases());
        phaselist.add(info.getOperationOutFaultPhases());
        req.getSession().setAttribute("phaseList", phaselist);
        res.sendRedirect(LIST_PHASES_JSP_NAME);
    }

    private void listService(HttpServletRequest req, HttpServletResponse res, String filePart) throws IOException {
        Object serviceObj;
        String serviceName = filePart.substring(filePart.lastIndexOf("/") + 1, filePart.length());
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        String wsdl = req.getParameter("wsdl");
        String xsd = req.getParameter("xsd");
        if (services != null && !services.isEmpty() && (serviceObj = services.get(serviceName)) != null) {
            if (wsdl != null) {
                res.setContentType("text/xml");
                ((AxisService)serviceObj).printWSDL(this.out, filePart);
                this.out.flush();
                this.out.close();
                return;
            }
            if (xsd != null) {
                res.setContentType("text/xml");
                ((AxisService)serviceObj).printSchema(this.out);
                this.out.flush();
                this.out.close();
                return;
            }
            req.getSession().setAttribute("singleservice", serviceObj);
        }
        String URI2 = req.getRequestURI();
        URI2 = URI2.substring(0, URI2.indexOf("services"));
        res.sendRedirect(URI2 + LIST_SINGLE_SERVICE_JSP_NAME);
    }

    private void listServiceGroups(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Iterator serviceGroups = this.configContext.getAxisConfiguration().getServiceGroups();
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        req.getSession().setAttribute("servicemap", (Object)services);
        req.getSession().setAttribute("serviceGroupmap", (Object)serviceGroups);
        res.sendRedirect(LIST_SERVICE_GROUP_JSP);
    }

    private void listServices(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        req.getSession().setAttribute("servicemap", (Object)services);
        req.getSession().setAttribute("errprservicemap", (Object)this.configContext.getAxisConfiguration().getFaultyServices());
        res.sendRedirect(LIST_MULTIPLE_SERVICE_JSP_NAME);
    }

    private void logout(HttpServletRequest req, HttpServletResponse res) throws IOException {
        req.getSession().invalidate();
        res.sendRedirect("index.jsp");
    }

    private void lsitServiceforParameterChanged(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        req.getSession().setAttribute("servicemap", (Object)services);
        req.getSession().setAttribute("SELECT_SERVICE_TYPE", (Object)"SERVICE_PARAMETER");
        res.sendRedirect(SELECT_SERVICE_JSP_NAME);
    }

    private void lsitServiceformodules(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        req.getSession().setAttribute("servicemap", (Object)services);
        req.getSession().setAttribute("SELECT_SERVICE_TYPE", (Object)"MODULE");
        res.sendRedirect(SELECT_SERVICE_JSP_NAME);
    }

    private void removeService(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getParameter("submit") != null) {
            String serviceName = req.getParameter("service");
            String turnoff = req.getParameter("turnoff");
            if (serviceName != null && turnoff != null) {
                this.configContext.getAxisConfiguration().removeService(serviceName);
                res.setContentType("text/css");
                PrintWriter out_writer = new PrintWriter(this.out);
                out_writer.println("Service removed from the system Successfully");
                out_writer.flush();
                out_writer.close();
                return;
            }
        } else {
            HashMap services = this.configContext.getAxisConfiguration().getServices();
            req.getSession().setAttribute("servicemap", (Object)services);
        }
        res.sendRedirect(REMOVE_SERVICE_JSP_NAME);
    }

    private void selectService(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        req.getSession().setAttribute("servicemap", (Object)services);
        req.getSession().setAttribute("SELECT_SERVICE_TYPE", (Object)"VIEW");
        res.sendRedirect(SELECT_SERVICE_JSP_NAME);
    }

    private void viewGlobalHandlers(HttpServletRequest req, HttpServletResponse res) throws IOException {
        req.getSession().setAttribute("axisconfig", (Object)this.configContext.getAxisConfiguration());
        res.sendRedirect(VIEW_GLOBAL_HANDLERS_JSP_NAME);
    }

    private void viewServiceHandlers(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String service = req.getParameter("axisService");
        if (service != null) {
            req.getSession().setAttribute("serviceHandlers", (Object)this.configContext.getAxisConfiguration().getService(service));
        }
        res.sendRedirect(VIEW_SERVICE_HANDLERS_JSP_NAME);
    }
}

