/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMOutputFormat;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class SOAPOverHTTPSender
extends AbstractHTTPSender {
    public void send(MessageContext msgContext, OMElement dataout, URL url, String soapActionString) throws MalformedURLException, AxisFault, IOException {
        Object cookieString;
        this.httpClient = new HttpClient();
        this.getTimeoutValues(msgContext);
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.soTimeout);
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout);
        PostMethod postMethod = new PostMethod(url.toString());
        String charEncoding = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charEncoding == null) {
            charEncoding = "UTF-8";
        }
        postMethod.setPath(url.getPath());
        postMethod.setRequestEntity((RequestEntity)new AxisSOAPRequestEntity(dataout, this.chunked, msgContext, charEncoding, soapActionString));
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            postMethod.setContentChunked(true);
        }
        postMethod.setRequestHeader("User-Agent", "Axis/2.0");
        if (msgContext.isSOAP11()) {
            postMethod.setRequestHeader("SOAPAction", soapActionString);
        }
        if ((cookieString = msgContext.getProperty("Cookie")) != null) {
            postMethod.setRequestHeader("Cookie", (String)cookieString);
            postMethod.setRequestHeader("Cookie2", (String)cookieString);
        }
        postMethod.setRequestHeader("Host", url.getHost());
        if (this.httpVersion != null) {
            if (this.httpVersion.equals("HTTP/1.0")) {
                this.httpClient.getParams().setVersion(HttpVersion.HTTP_1_0);
                postMethod.setRequestHeader("Connection", HTTPConstants.HEADER_CONNECTION_KEEPALIVE);
            } else {
                postMethod.setRequestHeader("Connection", HTTPConstants.HEADER_CONNECTION_KEEPALIVE);
                postMethod.setRequestHeader("Expect", "100-continue");
            }
        }
        HostConfiguration config = this.getHostConfiguration(this.httpClient, msgContext, url);
        this.httpClient.executeMethod(config, (HttpMethod)postMethod);
        if (postMethod.getStatusCode() == 200) {
            this.processResponse((HttpMethodBase)postMethod, msgContext);
            return;
        }
        if (postMethod.getStatusCode() == 202) {
            return;
        }
        if (postMethod.getStatusCode() == 500) {
            String value;
            Header contentTypeHeader = postMethod.getResponseHeader("Content-Type");
            if (contentTypeHeader != null && ((value = contentTypeHeader.getValue()).indexOf("text/xml") >= 0 || value.indexOf("application/soap+xml") >= 0)) {
                this.processResponse((HttpMethodBase)postMethod, msgContext);
                return;
            }
        } else {
            throw new AxisFault("Axis2 transport error : " + postMethod.getStatusText(), "Sender");
        }
        throw new AxisFault(Messages.getMessage("transportError", String.valueOf(postMethod.getStatusCode()), postMethod.getResponseBodyAsString()));
    }

    public class AxisSOAPRequestEntity
    implements RequestEntity {
        private boolean doingMTOM = false;
        private byte[] bytes;
        private String charSetEnc;
        private boolean chunked;
        private OMElement element;
        private MessageContext msgCtxt;
        private String soapActionString;

        public AxisSOAPRequestEntity(OMElement element, boolean chunked, MessageContext msgCtxt, String charSetEncoding, String soapActionString) {
            this.element = element;
            this.chunked = chunked;
            this.msgCtxt = msgCtxt;
            this.doingMTOM = msgCtxt.isDoingMTOM();
            this.charSetEnc = charSetEncoding;
            this.soapActionString = soapActionString;
        }

        private void handleOMOutput(OutputStream out, boolean doingMTOM) throws XMLStreamException {
            SOAPOverHTTPSender.this.format.setDoOptimize(doingMTOM);
            this.element.serializeAndConsume(out, SOAPOverHTTPSender.this.format);
        }

        public byte[] writeBytes() throws AxisFault {
            try {
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                if (!this.doingMTOM) {
                    OMOutputFormat format2 = new OMOutputFormat();
                    format2.setCharSetEncoding(this.charSetEnc);
                    this.element.serializeAndConsume(bytesOut, format2);
                    return bytesOut.toByteArray();
                }
                SOAPOverHTTPSender.this.format.setCharSetEncoding(this.charSetEnc);
                SOAPOverHTTPSender.this.format.setDoOptimize(true);
                this.element.serializeAndConsume(bytesOut, SOAPOverHTTPSender.this.format);
                return bytesOut.toByteArray();
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
            catch (FactoryConfigurationError e) {
                throw new AxisFault(e);
            }
        }

        public void writeRequest(OutputStream out) throws IOException {
            try {
                if (this.chunked) {
                    this.handleOMOutput(out, this.doingMTOM);
                } else {
                    if (this.bytes == null) {
                        this.bytes = this.writeBytes();
                    }
                    out.write(this.bytes);
                }
                out.flush();
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
            catch (FactoryConfigurationError e) {
                throw new AxisFault(e);
            }
            catch (IOException e) {
                throw new AxisFault(e);
            }
        }

        public long getContentLength() {
            try {
                if (this.chunked) {
                    return -1L;
                }
                if (this.bytes == null) {
                    this.bytes = this.writeBytes();
                }
                return this.bytes.length;
            }
            catch (AxisFault e) {
                return -1L;
            }
        }

        public String getContentType() {
            String encoding = SOAPOverHTTPSender.this.format.getCharSetEncoding();
            String contentType = SOAPOverHTTPSender.this.format.getContentType();
            if (encoding != null) {
                contentType = contentType + "; charset=" + encoding;
            }
            if (!this.msgCtxt.isSOAP11() && this.soapActionString != null && !"".equals(this.soapActionString.trim())) {
                contentType = contentType + ";action=\"" + this.soapActionString + "\";";
            }
            return contentType;
        }

        public boolean isRepeatable() {
            return true;
        }
    }
}

