/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.HTTPWorker;
import org.apache.axis2.transport.http.server.SimpleHttpServer;
import org.apache.axis2.transport.http.server.SimpleHttpServerConnection;
import org.apache.axis2.util.OptionsParser;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleHTTPServer
extends TransportListener {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis2$transport$http$SimpleHTTPServer == null ? (class$org$apache$axis2$transport$http$SimpleHTTPServer = SimpleHTTPServer.class$("org.apache.axis2.transport.http.SimpleHTTPServer")) : class$org$apache$axis2$transport$http$SimpleHTTPServer).getName());
    SimpleHttpServer embedded = null;
    int port = -1;
    private ThreadFactory threadPool = null;
    public static int DEFAULT_PORT = 8080;
    protected ConfigurationContext configurationContext;
    static /* synthetic */ Class class$org$apache$axis2$transport$http$SimpleHTTPServer;

    public SimpleHTTPServer() {
    }

    public SimpleHTTPServer(ConfigurationContext systemContext, int port) {
        this(systemContext, port, null);
    }

    public SimpleHTTPServer(String dir, int port) throws AxisFault {
        this(dir, port, null);
    }

    public SimpleHTTPServer(ConfigurationContext systemContext, int port, ThreadFactory pool) {
        if (pool == null) {
            pool = systemContext.getThreadPool();
        }
        this.configurationContext = systemContext;
        this.port = port;
        this.threadPool = pool;
    }

    public SimpleHTTPServer(String dir, int port, ThreadFactory pool) throws AxisFault {
        try {
            this.port = port;
            ConfigurationContextFactory erfac = new ConfigurationContextFactory();
            this.configurationContext = erfac.createConfigurationContextFromFileSystem(dir);
            if (pool == null) {
                pool = this.configurationContext.getThreadPool();
            } else {
                this.configurationContext.setThreadPool(pool);
            }
            this.threadPool = pool;
            Thread.sleep(2000L);
        }
        catch (Exception e1) {
            throw new AxisFault(e1);
        }
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
        try {
            this.configurationContext = axisConf;
            Parameter param = transprtIn.getParameter("port");
            if (param != null) {
                this.port = Integer.parseInt((String)param.getValue());
            }
        }
        catch (Exception e1) {
            throw new AxisFault(e1);
        }
    }

    public static void main(String[] args) throws Exception {
        String paramPort;
        int port = DEFAULT_PORT;
        OptionsParser optionsParser = new OptionsParser(args);
        args = optionsParser.getRemainingArgs();
        if (optionsParser.isFlagSet('?') > 0 || optionsParser.isFlagSet('h') > 0 || args == null || args.length == 0 || args.length > 1) {
            SimpleHTTPServer.printUsage();
        }
        if ((paramPort = optionsParser.isValueSet('p')) != null) {
            port = Integer.parseInt(paramPort);
        }
        System.out.println("[SimpleHTTPServer] Starting");
        System.out.println("[SimpleHTTPServer] Using the Axis2 Repository " + new File(args[0]).getAbsolutePath());
        System.out.println("[SimpleHTTPServer] Listening on port " + port);
        try {
            SimpleHTTPServer receiver = new SimpleHTTPServer(args[0], port);
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(receiver));
            receiver.start();
            System.out.println("[SimpleHTTPServer] Started");
        }
        catch (Throwable t) {
            log.fatal((Object)"Error starting SimpleHTTPServer", t);
            System.out.println("[SimpleHTTPServer] Shutting down");
        }
    }

    public static void printUsage() {
        System.out.println("Usage: SimpleHTTPServer [options] <repository>");
        System.out.println(" Opts: -? this message");
        System.out.println();
        System.out.println("       -p port to listen on (default is 8080)");
        System.exit(1);
    }

    public void start() throws AxisFault {
        try {
            this.embedded = new SimpleHttpServer(this.port, this.threadPool);
            this.embedded.setRequestHandler(new HTTPWorker(this.configurationContext));
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new AxisFault(e);
        }
    }

    public void stop() {
        System.out.println("[SimpleHTTPServer] Stop called");
        if (this.embedded != null) {
            this.embedded.destroy();
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public EndpointReference getReplyToEPR(String serviceName) throws AxisFault {
        String hostAddress = null;
        try {
            hostAddress = SimpleHttpServerConnection.getIpAddress();
        }
        catch (SocketException e) {
            throw AxisFault.makeFault(e);
        }
        return new EndpointReference("http://" + hostAddress + ":" + this.embedded.getLocalPort() + "/axis2/services/" + serviceName);
    }

    public boolean isRunning() {
        if (this.embedded == null) {
            return false;
        }
        return this.embedded.isRunning();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ShutdownThread
    extends Thread {
        private SimpleHTTPServer server = null;

        public ShutdownThread(SimpleHTTPServer server) {
            this.server = server;
        }

        public void run() {
            System.out.println("[SimpleHTTPServer] Shutting down");
            this.server.stop();
            System.out.println("[SimpleHTTPServer] Shutdown complete");
        }
    }
}

