/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.axis2.transport.http.server.HttpRequestHandler;
import org.apache.axis2.transport.http.server.SimpleConnSet;
import org.apache.axis2.transport.http.server.SimpleHttpServerConnection;
import org.apache.axis2.transport.http.server.SimpleRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleConnectionThread
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$axis2$transport$http$server$SimpleConnectionThread == null ? (class$org$apache$axis2$transport$http$server$SimpleConnectionThread = SimpleConnectionThread.class$("org.apache.axis2.transport.http.server.SimpleConnectionThread")) : class$org$apache$axis2$transport$http$server$SimpleConnectionThread));
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private SimpleHttpServerConnection conn = null;
    private SimpleConnSet connpool = null;
    private HttpRequestHandler handler = null;
    private String name = null;
    transient boolean stopped;
    static /* synthetic */ Class class$org$apache$axis2$transport$http$server$SimpleConnectionThread;

    public SimpleConnectionThread(String name, SimpleHttpServerConnection conn, SimpleConnSet connpool, HttpRequestHandler handler) {
        if (conn == null) {
            throw new IllegalArgumentException("Connection may not be null");
        }
        if (connpool == null) {
            throw new IllegalArgumentException("Connection pool not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Request handler may not be null");
        }
        this.conn = conn;
        this.connpool = connpool;
        this.handler = handler;
        this.stopped = false;
        this.name = name;
    }

    public synchronized void destroy() {
        if (this.conn != null) {
            this.conn.close();
            this.connpool.removeConnection(this.conn);
            this.conn = null;
        }
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            do {
                this.conn.setKeepAlive(false);
                SimpleRequest request = this.conn.readRequest();
                if (request == null) continue;
                this.handler.processRequest(this.conn, request);
            } while (this.conn.isKeepAlive());
        }
        catch (InterruptedIOException e) {
            log.error((Object)"Can not run SimpleConnectionThread ", (Throwable)e);
        }
        catch (IOException e) {
            if (!this.stopped && !Thread.interrupted() && log.isDebugEnabled()) {
                log.debug((Object)("[" + this.name + "] I/O error: " + e.getMessage()));
            }
        }
        finally {
            this.destroy();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

